/*
 * Decompiled with CFR 0.152.
 */
package mb.jsglr.shared;

import java.util.Iterator;
import java.util.NoSuchElementException;
import mb.jsglr.shared.IToken;

public class FilteredTokenIterator
implements Iterator<IToken> {
    final Iterator<IToken> allTokensIterator;
    IToken next = null;
    int offset = -1;

    public FilteredTokenIterator(Iterable<IToken> allTokens) {
        this.allTokensIterator = allTokens.iterator();
        this.calculateNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public IToken next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IToken res = this.next;
        this.calculateNext();
        return res;
    }

    private void calculateNext() {
        while (this.allTokensIterator.hasNext()) {
            this.next = this.allTokensIterator.next();
            if (this.next.getKind() != IToken.Kind.TK_RESERVED && this.next.getKind() != IToken.Kind.TK_EOF && this.next.getStartOffset() == this.next.getEndOffset() + 1 || this.next.getStartOffset() <= this.offset) continue;
            this.offset = this.next.getEndOffset();
            return;
        }
        this.next = null;
    }
}

