/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter.expressions;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import io.usethesource.capsule.Set;
import mb.flowspec.runtime.interpreter.SymbolicLargestSetException;
import mb.flowspec.runtime.interpreter.expressions.ExpressionNode;
import mb.flowspec.runtime.interpreter.values.EmptyMapOrSet;
import mb.flowspec.runtime.interpreter.values.IMap;
import mb.flowspec.runtime.interpreter.values.ISet;
import mb.flowspec.runtime.interpreter.values.Map;
import mb.flowspec.runtime.interpreter.values.Set;

@NodeChildren(value={@NodeChild(value="left"), @NodeChild(value="right")})
public abstract class SetUnionNode
extends ExpressionNode {
    @Specialization
    protected EmptyMapOrSet union(EmptyMapOrSet left, EmptyMapOrSet right) {
        return left;
    }

    @Specialization
    protected ISet union(ISet left, ISet right) {
        try {
            left.getSet();
        }
        catch (SymbolicLargestSetException e) {
            return left;
        }
        try {
            right.getSet();
        }
        catch (SymbolicLargestSetException e) {
            return right;
        }
        return new Set(Set.Immutable.union(left.getSet(), right.getSet()));
    }

    @Specialization
    protected IMap union(IMap left, IMap right) {
        return new Map(left.getMap().__putAll(right.getMap()));
    }
}

