/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.runtime.interpreter;

import com.oracle.truffle.api.dsl.TypeSystem;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import mb.flowspec.controlflow.ICFGNode;
import mb.flowspec.runtime.interpreter.expressions.BooleanLiteralNode;
import mb.flowspec.runtime.interpreter.values.Function;
import mb.flowspec.runtime.interpreter.values.IMap;
import mb.flowspec.runtime.interpreter.values.ISet;
import mb.flowspec.runtime.interpreter.values.Name;
import mb.flowspec.terms.B;
import mb.nabl2.terms.stratego.TermIndex;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

@TypeSystem(value={Function.class, ISet.class, IMap.class, TermIndex.class, Name.class, ICFGNode.class, IStrategoTerm.class})
public abstract class Types {
    public static Object typeSpecializeTerm(Object value) {
        if (!(value instanceof IStrategoTerm)) {
            return value;
        }
        if (Types.isInteger(value)) {
            return Types.asInteger(value);
        }
        if (Types.isBoolean(value)) {
            return Types.asBoolean(value);
        }
        return value;
    }

    public static boolean isInteger(Object value) {
        return value instanceof Integer || value instanceof IStrategoTerm && TermUtils.isInt((IStrategoTerm)value);
    }

    public static int asInteger(Object value) {
        assert (Types.isInteger(value)) : "Types.asInt: int or IIntTerm expected";
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return ((IStrategoInt)value).intValue();
    }

    public static int expectInteger(Object value) throws UnexpectedResultException {
        if (Types.isInteger(value)) {
            return Types.asInteger(value);
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isString(Object value) {
        return value instanceof String || value instanceof IStrategoTerm && TermUtils.isString((IStrategoTerm)value);
    }

    public static String asString(Object value) {
        assert (Types.isString(value)) : "Types.asString: String or IStringTerm expected";
        if (value instanceof String) {
            return (String)value;
        }
        return ((IStrategoString)value).stringValue();
    }

    public static String expectString(Object value) throws UnexpectedResultException {
        if (Types.isString(value)) {
            return Types.asString(value);
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isBoolean(Object value) {
        return value instanceof Boolean || BooleanLiteralNode.isTrueTerm(value) || BooleanLiteralNode.isFalseTerm(value);
    }

    public static boolean asBoolean(Object value) {
        assert (Types.isBoolean(value)) : "Types.asBoolean: boolean or IApplTerm True() or False() expected";
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return BooleanLiteralNode.isTrueTerm(value);
    }

    public static boolean expectBoolean(Object value) throws UnexpectedResultException {
        if (Types.isBoolean(value)) {
            return Types.asBoolean(value);
        }
        throw new UnexpectedResultException(value);
    }

    public static boolean isIStrategoTerm(Object value) {
        return value instanceof IStrategoTerm || value instanceof Integer || value instanceof String || value instanceof Boolean;
    }

    public static IStrategoTerm asIStrategoTerm(Object value) {
        if (value instanceof IStrategoTerm) {
            return (IStrategoTerm)value;
        }
        if (Types.isInteger(value)) {
            return B.integer(Types.asInteger(value));
        }
        if (Types.isString(value)) {
            return B.string(Types.asString(value));
        }
        if (Types.isBoolean(value)) {
            return BooleanLiteralNode.booleanToTerm(Types.asBoolean(value));
        }
        return (IStrategoTerm)value;
    }

    public static IStrategoTerm expectIStrategoTerm(Object value) throws UnexpectedResultException {
        if (Types.isIStrategoTerm(value)) {
            return Types.asIStrategoTerm(value);
        }
        throw new UnexpectedResultException(value);
    }
}

