/*
 * Decompiled with CFR 0.152.
 */
package mb.flowspec.controlflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import mb.flowspec.controlflow.IBasicBlock;
import mb.flowspec.controlflow.ICFGNode;

public class BasicBlock
implements IBasicBlock,
Serializable {
    private final Deque<ICFGNode> nodes;
    private final boolean inversed;
    private BasicBlock inverse = null;
    public final Set<ICFGNode> ignored;

    public BasicBlock(Deque<ICFGNode> nodes) {
        this.nodes = nodes;
        this.inversed = false;
        this.ignored = new HashSet<ICFGNode>(nodes.size() * 2);
    }

    protected BasicBlock(Deque<ICFGNode> nodes, BasicBlock inverse) {
        this.nodes = nodes;
        this.inversed = true;
        this.inverse = inverse;
        this.ignored = inverse.ignored;
    }

    @Override
    public ICFGNode first() {
        if (this.inversed) {
            return this.nodes.peekLast();
        }
        return this.nodes.peekFirst();
    }

    @Override
    public ICFGNode last() {
        if (this.inversed) {
            return this.nodes.peekFirst();
        }
        return this.nodes.peekLast();
    }

    @Override
    public Iterator<ICFGNode> iterator() {
        if (this.inversed) {
            return this.nodes.descendingIterator();
        }
        return this.nodes.iterator();
    }

    @Override
    public IBasicBlock inverse() {
        if (this.inverse == null) {
            this.inverse = new BasicBlock(this.nodes, this);
        }
        return this.inverse;
    }

    @Override
    public boolean ignored(ICFGNode node) {
        return this.ignored.contains(node);
    }

    @Override
    public void ignore(ICFGNode node) {
        this.ignored.add(node);
    }

    @Override
    public void clearIgnored() {
        this.ignored.clear();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inversed ? 1231 : 1237);
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicBlock other = (BasicBlock)obj;
        if (this.inversed != other.inversed) {
            return false;
        }
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }

    public String toString() {
        ArrayList<ICFGNode> activeNodes = new ArrayList<ICFGNode>(this.nodes.size());
        for (ICFGNode node : this) {
            if (this.ignored(node)) continue;
            activeNodes.add(node);
        }
        return "BasicBlock " + activeNodes + ", inversed=" + this.inversed + ", nodes=" + this.nodes + "]";
    }

    @Override
    public int size() {
        return this.nodes.size();
    }
}

