/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.PgxVect;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.api.internal.PropertyProxy;
import oracle.pgx.api.internal.ProxyException;
import oracle.pgx.client.RemotePropertyEntryIterator;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.internal.EntityDeserializationHelper;
import oracle.pgx.config.LinkTemplate;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePropertyProxy<T>
implements PropertyProxy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RemotePropertyProxy.class);
    private final Executor httpExecutor;
    private final String remotePropertyProxyPath;
    private final long size;
    private final int prefetchSize;
    private final PropertyType keyType;
    private final IdType keyNodeEdgeValueType;
    private final PropertyType valueType;
    private final IdType nodeEdgeValueType;
    private final int dimension;
    private final URI baseUri;
    private final String propertyProxyUuid;

    public RemotePropertyProxy(Executor httpExecutor, URI baseUri, String propertyProxyUuid, String path, long size, int prefetchSize, PropertyType keyType, IdType keyNodeEdgeValueType, PropertyType valueType, IdType nodeEdgeValueType, int dimension) {
        this.httpExecutor = httpExecutor;
        this.remotePropertyProxyPath = RemoteUtils.stripTrailingSlash(path);
        this.size = size;
        this.prefetchSize = prefetchSize;
        this.keyType = keyType;
        this.keyNodeEdgeValueType = keyNodeEdgeValueType;
        this.valueType = valueType;
        if (valueType.isNodeOrEdge() && nodeEdgeValueType == null) {
            throw new IllegalArgumentException("if value is node/edge, nodeEdgeValueType must be set");
        }
        this.nodeEdgeValueType = nodeEdgeValueType;
        this.dimension = dimension;
        this.baseUri = baseUri;
        this.propertyProxyUuid = propertyProxyUuid;
    }

    public String getId() {
        throw new RuntimeException("getId() should never be called on RemotePropertyProxy");
    }

    public long size() {
        return this.size;
    }

    public synchronized T getValueFor(Object key) {
        try {
            Object value;
            boolean isKeyWrapped = key instanceof Entity;
            Object id = isKeyWrapped ? JsonUtil.toJson((Object)key) : key;
            URIBuilder builder = new URIBuilder(LinkTemplate.PROPERTY_PROXY_VALUE_SELF.generateUrl(this.baseUri, new Object[0]));
            builder.addParameter("keyWrapped", Boolean.valueOf(isKeyWrapped).toString());
            Request r = Request.get((URI)builder.build());
            r.addHeader("x-proxy-id", this.propertyProxyUuid);
            r.addHeader("x-property-key", id.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requesting {}", (Object)r);
            }
            String responseContent = RemoteUtils.getResponseContent(this.httpExecutor.execute(r));
            Class typeClass = this.valueType.getTypeClass();
            JsonNode propertyValue = JsonUtil.readTopLevelJsonToTree((String)responseContent);
            String stringValue = propertyValue.get("value").toString();
            if (this.valueType.isNodeOrEdge()) {
                assert (this.dimension == 0);
                JsonNode isValueWrappedNode = propertyValue.get("valueWrapped");
                boolean isWrapped = false;
                if (isValueWrappedNode != null) {
                    isWrapped = Boolean.TRUE.equals(JsonUtil.fromJsonNode((JsonNode)isValueWrappedNode, Boolean.class));
                }
                if (isWrapped) {
                    value = EntityDeserializationHelper.deserializeEntityOrKey((JsonNode)JsonUtil.readTopLevelJsonToTree((String)stringValue)).getLeft().get();
                } else {
                    typeClass = this.nodeEdgeValueType.getTypeClass();
                    value = JsonUtil.readValue((String)stringValue, (Class)typeClass);
                }
            } else {
                value = this.dimension > 0 ? JsonUtil.readValue((String)stringValue, PgxVect.class) : JsonUtil.readValue((String)stringValue, (Class)typeClass);
            }
            return (T)value;
        }
        catch (IOException | URISyntaxException | RemoteUtils.RequestPendingException e) {
            throw new ProxyException("could not get the value for the key " + key, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ProxyException(e.getCause());
        }
    }

    private Iterable<Map.Entry<Object, T>> getRemoteIterable(String url, String proxyId, int prefetchSize) {
        return () -> new RemotePropertyEntryIterator(this.httpExecutor, url, proxyId, prefetchSize, this.keyType, this.keyNodeEdgeValueType, this.valueType, this.nodeEdgeValueType, this.dimension);
    }

    public synchronized Iterable<Map.Entry<Object, T>> getValues() {
        return this.getRemoteIterable(this.remotePropertyProxyPath + "/values", this.propertyProxyUuid, this.prefetchSize);
    }

    public synchronized Iterable<Map.Entry<Object, T>> getTopKValues(int k) {
        return this.getRemoteIterable(this.remotePropertyProxyPath + "/topKValues?k=" + k, this.propertyProxyUuid, Math.min(this.prefetchSize, k));
    }

    public synchronized Iterable<Map.Entry<Object, T>> getBottomKValues(int k) {
        return this.getRemoteIterable(this.remotePropertyProxyPath + "/bottomKValues?k=" + k, this.propertyProxyUuid, Math.min(this.prefetchSize, k));
    }

    public IdType getKeyNodeEdgeValueType() {
        return this.keyNodeEdgeValueType;
    }

    public PropertyType getPropertyType() {
        return this.valueType;
    }

    public IdType getNodeEdgeValueType() {
        return this.nodeEdgeValueType;
    }

    public int getDimension() {
        return this.dimension;
    }
}

