/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.pypgx.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import oracle.pgx.api.PgqlResultElement;

public class SerializedColumn {
    private final PgqlResultElement.Type type;
    private final int byteWidth;
    private final int numRows;
    private final String name;
    private ByteBuffer asByteBuffer;
    private ByteBuffer nullIndicesBuffer = null;
    private ArrayList<Integer> nullIndicesList;
    private Object[] asObjects;

    public SerializedColumn(PgqlResultElement element, int numRows) {
        this.type = element.getElementType();
        this.name = element.getVarName();
        this.numRows = numRows;
        this.byteWidth = SerializedColumn.getByteWidth(this.type);
        if (this.isBytes()) {
            this.asByteBuffer = ByteBuffer.allocate(this.numRows * this.byteWidth);
            this.asByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.nullIndicesList = new ArrayList();
        } else {
            this.asObjects = new Object[this.numRows];
        }
    }

    public void write(Object object, int rowIndex) {
        if (this.isBytes()) {
            if (object == null) {
                this.nullIndicesList.add(rowIndex);
                return;
            }
            int byteIndex = rowIndex * this.byteWidth;
            switch (this.type) {
                case DOUBLE: {
                    this.asByteBuffer.putDouble(byteIndex, (Double)object);
                    break;
                }
                case LONG: {
                    this.asByteBuffer.putLong(byteIndex, (Long)object);
                    break;
                }
                case FLOAT: {
                    this.asByteBuffer.putFloat(byteIndex, ((Float)object).floatValue());
                    break;
                }
                case INTEGER: {
                    this.asByteBuffer.putInt(byteIndex, (Integer)object);
                    break;
                }
                case BOOLEAN: {
                    this.asByteBuffer.put(byteIndex, (byte)((Boolean)object != false ? 1 : 0));
                    break;
                }
                default: {
                    throw new IllegalStateException("Data type " + this.type + " can't be serialized to raw bytes");
                }
            }
        } else {
            this.asObjects[rowIndex] = object;
        }
    }

    private static int getByteWidth(PgqlResultElement.Type type) {
        switch (type) {
            case DOUBLE: {
                return 8;
            }
            case LONG: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case INTEGER: {
                return 4;
            }
            case BOOLEAN: {
                return 1;
            }
        }
        return 0;
    }

    private void initNullIndicesBuffer() {
        int intByteWidth = 4;
        this.nullIndicesBuffer = ByteBuffer.allocate(this.nullIndicesList.size() * intByteWidth);
        this.nullIndicesBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < this.nullIndicesList.size(); ++i) {
            this.nullIndicesBuffer.putInt(intByteWidth * i, this.nullIndicesList.get(i));
        }
    }

    public byte[] getNullIndicesAsBytes() {
        if (this.nullIndicesBuffer == null) {
            this.initNullIndicesBuffer();
        }
        return this.nullIndicesBuffer.array();
    }

    public boolean isBytes() {
        return this.byteWidth > 0;
    }

    public int getByteWidth() {
        return this.byteWidth;
    }

    public byte[] getAsBytes() {
        return this.asByteBuffer.array();
    }

    public Object[] getAsObjects() {
        return this.asObjects;
    }

    public PgqlResultElement.Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }
}

