/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library.misc;

import java.util.Arrays;
import java.util.Optional;

public class AutoCloseableHelper {
    public static void closeAll(AutoCloseable ... closeables) throws RuntimeException {
        Optional<Exception> exception = Arrays.stream(closeables).map(c -> {
            try {
                c.close();
                return Optional.empty();
            }
            catch (Exception e) {
                return Optional.of(e);
            }
        }).filter(Optional::isPresent).map(Optional::get).reduce((e1, e2) -> {
            e1.addSuppressed((Throwable)e2);
            return e1;
        });
        if (exception.isPresent()) {
            throw new RuntimeException(exception.get());
        }
    }
}

