/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library;

import java.util.Optional;
import javax.annotation.Nonnull;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.PgqlResult;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryType;
import oracle.pgql.lang.ir.SchemaQualifiedName;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.modify.InsertClause;
import oracle.pgql.lang.ir.modify.Modification;
import oracle.pgql.lang.ir.modify.ModificationType;
import oracle.pgql.lang.ir.modify.ModifyQuery;
import oracle.pgql.lang.util.AbstractQueryExpressionVisitor;
import oracle.pgx.graphviz.library.PgqlParser;
import oracle.pgx.graphviz.library.misc.MalformedQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEnhancerUtils {
    private static Logger LOG = LoggerFactory.getLogger(QueryEnhancerUtils.class);

    public static void addGraphNameToQueryAndSubqueries(GraphQuery query, final SchemaQualifiedName graphName) {
        LOG.debug("Adding graph name to query and subqueries, schema qualified name {}", (Object)graphName);
        query.accept((QueryExpressionVisitor)new AbstractQueryExpressionVisitor(){

            public void visit(SelectQuery query) {
                if (query.getGraphName() == null) {
                    query.setGraphName(graphName);
                }
                super.visit(query);
            }

            public void visit(ModifyQuery query) {
                if (query.getGraphName() == null) {
                    query.setGraphName(graphName);
                }
                for (Modification modification : query.getModifications()) {
                    InsertClause insertClause;
                    if (modification.getModificationType() != ModificationType.INSERT || (insertClause = (InsertClause)modification).getGraphName() != null) continue;
                    insertClause.setGraphName(graphName);
                }
                super.visit(query);
            }
        });
    }

    @Nonnull
    public static GraphQuery parseQuery(@Nonnull String query, String schema, String graphName) throws PgqlException, MalformedQueryException {
        PgqlResult parseResult = PgqlParser.getParser().parse(query);
        if (!parseResult.isQueryValid()) {
            throw new MalformedQueryException(parseResult);
        }
        String graphNameToBeUsed = null;
        String schemaToBeUsed = null;
        GraphQuery graphQuery = parseResult.getGraphQuery();
        if (graphName != null) {
            graphNameToBeUsed = graphName;
        }
        if (schema != null) {
            schemaToBeUsed = schema;
        }
        if (graphQuery.getQueryType() == QueryType.MODIFY) {
            ModifyQuery modifyQuery = (ModifyQuery)graphQuery;
            Optional<Modification> firstInsert = modifyQuery.getModifications().stream().filter(modification -> modification.getModificationType() == ModificationType.INSERT).findFirst();
            if (firstInsert.isPresent()) {
                InsertClause insertClause = (InsertClause)firstInsert.get();
                if (insertClause.getGraphName() == null || insertClause.getGraphName().getName() == null) {
                    throw new IllegalArgumentException("Missing INTO or ON clause: graph name is not provided");
                }
                schemaToBeUsed = insertClause.getGraphName().getSchemaName();
                graphNameToBeUsed = insertClause.getGraphName().getName();
            }
        } else if (graphQuery.getGraphName() != null) {
            schemaToBeUsed = graphQuery.getGraphName().getSchemaName();
            graphNameToBeUsed = graphQuery.getGraphName().getName();
        } else if (graphNameToBeUsed == null) {
            throw new IllegalArgumentException("Missing ON clause: graph name is not provided");
        }
        LOG.debug("Schema to be used on query and subqueries {}", (Object)schemaToBeUsed);
        LOG.debug("Graph name to be used on query and subqueries {}", (Object)graphNameToBeUsed);
        QueryEnhancerUtils.addGraphNameToQueryAndSubqueries(graphQuery, new SchemaQualifiedName(schemaToBeUsed, graphNameToBeUsed));
        return graphQuery;
    }
}

