/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.metadata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.pgview.metadata.Column;
import oracle.pg.rdbms.pgql.pgview.metadata.EdgeTable;
import oracle.pg.rdbms.pgql.pgview.metadata.ElementTable;
import oracle.pg.rdbms.pgql.pgview.metadata.Key;
import oracle.pg.rdbms.pgql.pgview.metadata.Label;
import oracle.pg.rdbms.pgql.pgview.metadata.Property;
import oracle.pg.rdbms.pgql.pgview.metadata.VertexTable;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class MetadataConnector {
    public static final String VERTEX_TYPE = "VERTEX";
    public static final String EDGE_TYPE = "EDGE";
    public static final String EDGE_SOURCE_TYPE = "EDGE_SOURCE";
    public static final String EDGE_DESTINATION_TYPE = "EDGE_DESTINATION";
    public static final String ELEM_TABLE_SUFFIX = "_ELEM_TABLE$";
    public static final String LABEL_SUFFIX = "_LABEL$";
    public static final String PROPERTY_SUFFIX = "_PROPERTY$";
    public static final String KEY_SUFFIX = "_KEY$";
    public static final String SRC_DST_KEY_SUFFIX = "_SRC_DST_KEY$";
    private final Connection conn;
    private final String graphSchema;
    private final String graphName;
    private Map<String, VertexTable> vertexTables;
    private Map<String, EdgeTable> edgeTables;
    private Map<String, Set<String>> labelVertexTables;
    private Map<String, Set<String>> labelEdgeTables;
    private Map<String, Label> vertexLabels;
    private Map<String, Label> edgeLabels;

    public MetadataConnector(Connection conn, String graphSchema, String graphName, int fetchSize) {
        this.conn = conn;
        this.graphSchema = graphSchema;
        this.graphName = graphName;
        this.loadMetadata(fetchSize);
    }

    private void loadMetadata(int fetchSize) {
        String previousEtName4;
        Object column;
        int dataLength;
        String dataType;
        String etName;
        Object previousKeyType;
        String previousEtName2;
        Object previousEtType2;
        Throwable throwable;
        Object rs;
        this.vertexTables = new HashMap<String, VertexTable>();
        this.edgeTables = new HashMap<String, EdgeTable>();
        this.labelVertexTables = new HashMap<String, Set<String>>();
        this.labelEdgeTables = new HashMap<String, Set<String>>();
        this.vertexLabels = new HashMap<String, Label>();
        this.edgeLabels = new HashMap<String, Label>();
        String queryKeys = "SELECT t1.et_name, t2.schema_name, t2.table_name, t1.key_type, t1.column_name, \n       t3.data_type, t3.data_length \nFROM " + this.getTableForSuffix(KEY_SUFFIX) + "t1, \n     " + this.getTableForSuffix(ELEM_TABLE_SUFFIX) + " t2, \n     sys.all_tab_columns t3 WHERE t1.et_name = t2.et_name\n  AND t1.key_type = t2.et_type\n  AND t2.schema_name = t3.owner\n  AND t2.table_name = t3.table_name\n  AND t1.column_name = t3.column_name\nORDER BY et_name, et_type, column_number";
        try (PreparedStatement ps = this.conn.prepareStatement(queryKeys);){
            rs = ps.executeQuery();
            throwable = null;
            try {
                previousEtType2 = "";
                previousEtName2 = "";
                ElementTable currentTable = null;
                rs.setFetchSize(fetchSize);
                while (rs.next()) {
                    String etName2 = rs.getString(1);
                    String schemaName = rs.getString(2);
                    String tableName = rs.getString(3);
                    String keyType = rs.getString(4);
                    String columnName = rs.getString(5);
                    String dataType2 = rs.getString(6);
                    int dataLength2 = rs.getInt(7);
                    if (!previousEtName2.equals(etName2) || !((String)previousEtType2).equals(keyType)) {
                        switch (keyType) {
                            case "VERTEX": {
                                currentTable = this.addVertexTable(etName2, schemaName, tableName);
                                break;
                            }
                            case "EDGE": {
                                currentTable = this.addEdgeTable(etName2, schemaName, tableName);
                            }
                        }
                    }
                    Column column2 = new Column(columnName, dataType2, dataLength2);
                    assert (currentTable != null);
                    currentTable.getKey().add(column2);
                    previousEtName2 = etName2;
                    previousEtType2 = keyType;
                }
            }
            catch (Throwable previousEtType2) {
                throwable = previousEtType2;
                throw previousEtType2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable previousEtType2) {
                            throwable.addSuppressed(previousEtType2);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
        String querySrcDstKeys = "SELECT t1.et_name, t1.key_type, t1.vt_name, t1.et_column_name, t1.vt_column_name, \n       t3.data_type, t3.data_length \nFROM " + this.getTableForSuffix(SRC_DST_KEY_SUFFIX) + " t1, \n     " + this.getTableForSuffix(ELEM_TABLE_SUFFIX) + " t2, \n     sys.all_tab_columns t3 \nWHERE t1.et_name = t2.et_name\n  AND t2.et_type = 'EDGE'\n  AND t2.schema_name = t3.owner\n  AND t2.table_name = t3.table_name\n  AND t1.et_column_name = t3.column_name\nORDER BY et_name, key_type, et_column_number";
        try {
            PreparedStatement ps = this.conn.prepareStatement(querySrcDstKeys);
            rs = null;
            try {
                ResultSet rs2 = ps.executeQuery();
                previousEtType2 = null;
                try {
                    previousEtName2 = "";
                    previousKeyType = "";
                    String previousVtName = "";
                    Key currentKey = null;
                    Key currentVtKey = null;
                    rs2.setFetchSize(fetchSize);
                    while (rs2.next()) {
                        etName = rs2.getString(1);
                        String keyType = rs2.getString(2);
                        String vtName = rs2.getString(3);
                        String columnName = rs2.getString(4);
                        String vtColumnName = rs2.getString(5);
                        dataType = rs2.getString(6);
                        dataLength = rs2.getInt(7);
                        if (!(previousEtName2.equals(etName) && ((String)previousKeyType).equals(keyType) && previousVtName.equals(vtName))) {
                            EdgeTable currentEt = this.edgeTables.get(etName);
                            switch (keyType) {
                                case "EDGE_SOURCE": {
                                    currentEt.setSource(vtName);
                                    currentEt.setRefSourceVtColumns(new Key());
                                    currentKey = currentEt.getSourceKey();
                                    currentVtKey = currentEt.getRefSourceVtColumns();
                                    break;
                                }
                                case "EDGE_DESTINATION": {
                                    currentEt.setDestination(vtName);
                                    currentEt.setRefDestinationVtColumns(new Key());
                                    currentKey = currentEt.getDestinationKey();
                                    currentVtKey = currentEt.getRefDestinationVtColumns();
                                }
                            }
                        }
                        column = new Column(columnName, dataType, dataLength);
                        Column columnVt = new Column(vtColumnName, dataType, dataLength);
                        assert (currentKey != null);
                        assert (currentVtKey != null);
                        currentKey.add((Column)column);
                        currentVtKey.add(columnVt);
                        previousEtName2 = etName;
                        previousKeyType = keyType;
                        previousVtName = vtName;
                    }
                }
                catch (Throwable previousEtName3) {
                    previousEtType2 = previousEtName3;
                    throw previousEtName3;
                }
                finally {
                    if (rs2 != null) {
                        if (previousEtType2 != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable previousEtName3) {
                                ((Throwable)previousEtType2).addSuppressed(previousEtName3);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs2) {
                rs = rs2;
                throw rs2;
            }
            finally {
                if (ps != null) {
                    if (rs != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable rs2) {
                            ((Throwable)rs).addSuppressed(rs2);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 904) {
                String querySrcDstKeysR = "SELECT t1.et_name, t1.key_type, t1.vt_name, t1.et_column_name, \n       t3.data_type, t3.data_length \nFROM " + this.getTableForSuffix(SRC_DST_KEY_SUFFIX) + " t1, \n     " + this.getTableForSuffix(ELEM_TABLE_SUFFIX) + " t2, \n     sys.all_tab_columns t3 \nWHERE t1.et_name = t2.et_name\n  AND t2.et_type = 'EDGE'\n  AND t2.schema_name = t3.owner\n  AND t2.table_name = t3.table_name\n  AND t1.et_column_name = t3.column_name\nORDER BY et_name, key_type, et_column_number";
                try {
                    PreparedStatement psR = this.conn.prepareStatement(querySrcDstKeysR);
                    previousEtType2 = null;
                    try {
                        ResultSet rsR = psR.executeQuery();
                        previousKeyType = null;
                        try {
                            previousEtName4 = "";
                            String previousKeyType2 = "";
                            String previousVtName = "";
                            Key currentKey = null;
                            rsR.setFetchSize(fetchSize);
                            while (rsR.next()) {
                                String etName3 = rsR.getString(1);
                                String keyType = rsR.getString(2);
                                String vtName = rsR.getString(3);
                                String columnName = rsR.getString(4);
                                dataType = rsR.getString(5);
                                dataLength = rsR.getInt(6);
                                if (!(previousEtName4.equals(etName3) && previousKeyType2.equals(keyType) && previousVtName.equals(vtName))) {
                                    EdgeTable currentEt = this.edgeTables.get(etName3);
                                    switch (keyType) {
                                        case "EDGE_SOURCE": {
                                            currentEt.setSource(vtName);
                                            currentKey = currentEt.getSourceKey();
                                            break;
                                        }
                                        case "EDGE_DESTINATION": {
                                            currentEt.setDestination(vtName);
                                            currentKey = currentEt.getDestinationKey();
                                        }
                                    }
                                }
                                column = new Column(columnName, dataType, dataLength);
                                assert (currentKey != null);
                                currentKey.add((Column)column);
                                previousEtName4 = etName3;
                                previousKeyType2 = keyType;
                                previousVtName = vtName;
                            }
                        }
                        catch (Throwable previousEtName4) {
                            previousKeyType = previousEtName4;
                            throw previousEtName4;
                        }
                        finally {
                            if (rsR != null) {
                                if (previousKeyType != null) {
                                    try {
                                        rsR.close();
                                    }
                                    catch (Throwable previousEtName4) {
                                        ((Throwable)previousKeyType).addSuppressed(previousEtName4);
                                    }
                                } else {
                                    rsR.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        previousEtType2 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (psR != null) {
                            if (previousEtType2 != null) {
                                try {
                                    psR.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)previousEtType2).addSuppressed(throwable3);
                                }
                            } else {
                                psR.close();
                            }
                        }
                    }
                }
                catch (SQLException exR) {
                    throw new PgqlToSqlException(exR.getMessage());
                }
            }
            throw new PgqlToSqlException(ex.getMessage());
        }
        String queryProperties = "SELECT t1.et_name, t1.et_type, t1.label_name, t1.property_name, t1.column_name,\n       t2.data_type, t2.data_length\nFROM\n  (SELECT t1.et_name, t1.et_type, t1.label_name, t2.table_name, t2.schema_name,\n          t3.property_name, t3.column_name\n   FROM " + this.getTableForSuffix(LABEL_SUFFIX) + " t1,\n        " + this.getTableForSuffix(ELEM_TABLE_SUFFIX) + " t2,\n        " + this.getTableForSuffix(PROPERTY_SUFFIX) + " t3\n   WHERE t1.et_name = t2.et_name\n     AND t1.et_type = t2.et_type\n     AND t1.et_name = t3.et_name(+)\n     AND t1.et_type = t3.et_type(+)\n     AND t1.label_name = t3.label_name(+)) t1,\n  sys.all_tab_columns t2\nWHERE t1.schema_name = t2.owner(+)\n  AND t1.table_name = t2.table_name(+) \n  AND t1.column_name = t2.column_name(+)\nORDER BY et_name, et_type, label_name";
        try {
            throwable = null;
            try (PreparedStatement ps = this.conn.prepareStatement(queryProperties);
                 ResultSet rs3 = ps.executeQuery();){
                String previousEtType3 = "";
                previousEtName4 = "";
                String previousLabel = "";
                ElementTable currentTable = null;
                Label currentLabel = null;
                rs3.setFetchSize(fetchSize);
                while (rs3.next()) {
                    etName = rs3.getString(1);
                    String etType = rs3.getString(2);
                    String labelName = rs3.getString(3);
                    String propertyName = rs3.getString(4);
                    String columnName = rs3.getString(5);
                    dataType = rs3.getString(6);
                    dataLength = rs3.getInt(7);
                    if (!previousEtName4.equals(etName) || !previousEtType3.equals(etType)) {
                        switch (etType) {
                            case "VERTEX": {
                                currentTable = this.vertexTables.get(etName);
                                currentLabel = this.addVertexLabel(labelName, etName);
                                break;
                            }
                            case "EDGE": {
                                currentTable = this.edgeTables.get(etName);
                                currentLabel = this.addEdgeLabel(labelName, etName);
                            }
                        }
                        if (currentTable == null) {
                            if (etName != null) {
                                String queryTable = "SELECT t1.schema_name, t1.table_name \nFROM " + this.getTableForSuffix(ELEM_TABLE_SUFFIX) + " t1 WHERE t1.et_name = ?";
                                try (PreparedStatement ps2 = this.conn.prepareStatement(queryTable);){
                                    ps2.setString(1, etName);
                                    try (ResultSet rs2 = ps2.executeQuery();){
                                        if (rs2.next()) {
                                            String schemaName = rs2.getString(1);
                                            String tableName = rs2.getString(2);
                                            throw new PgqlToSqlException("Table " + schemaName + "." + tableName + " does not exist");
                                        }
                                    }
                                }
                            }
                            throw new PgqlToSqlException("Some of the provided tables are not available");
                        }
                        currentTable.addLabel(currentLabel);
                    } else if (!previousLabel.equals(labelName)) {
                        switch (etType) {
                            case "VERTEX": {
                                currentLabel = this.addVertexLabel(labelName, etName);
                                break;
                            }
                            case "EDGE": {
                                currentLabel = this.addEdgeLabel(labelName, etName);
                            }
                        }
                        assert (currentTable != null);
                        currentTable.addLabel(currentLabel);
                    }
                    if (propertyName != null) {
                        Property property = new Property(propertyName, columnName, dataType, dataLength);
                        assert (currentLabel != null);
                        currentLabel.addProperty(property);
                    }
                    previousEtName4 = etName;
                    previousEtType3 = etType;
                    previousLabel = labelName;
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    private VertexTable addVertexTable(String etName, String schemaName, String tableName) {
        VertexTable vt = new VertexTable(new SchemaQualifiedName(schemaName, tableName));
        this.vertexTables.put(etName, vt);
        return vt;
    }

    private EdgeTable addEdgeTable(String etName, String schemaName, String tableName) {
        EdgeTable et = new EdgeTable(new SchemaQualifiedName(schemaName, tableName));
        this.edgeTables.put(etName, et);
        return et;
    }

    private Label addVertexLabel(String labelName, String etName) {
        Label vl = new Label(labelName);
        MetadataConnector.addLabel(this.labelVertexTables, labelName, etName);
        this.vertexLabels.put(labelName, vl);
        return vl;
    }

    private Label addEdgeLabel(String labelName, String etName) {
        Label el = new Label(labelName);
        MetadataConnector.addLabel(this.labelEdgeTables, labelName, etName);
        this.edgeLabels.put(labelName, el);
        return el;
    }

    private static void addLabel(Map<String, Set<String>> labelTables, String labelName, String tableName) {
        if (!labelTables.containsKey(labelName)) {
            labelTables.put(labelName, new HashSet());
        }
        labelTables.get(labelName).add(tableName);
    }

    public boolean isVertexLabel(String labelName) {
        return this.labelVertexTables.containsKey(labelName);
    }

    public boolean isEdgeLabel(String labelName) {
        return this.labelEdgeTables.containsKey(labelName);
    }

    public boolean isPropertyForVertexTable(String tableName, String propertyName) {
        return this.isPropertyForTable(this.vertexTables.get(tableName), propertyName);
    }

    public boolean isPropertyForEdgeTable(String tableName, String propertyName) {
        return this.isPropertyForTable(this.edgeTables.get(tableName), propertyName);
    }

    private boolean isPropertyForTable(ElementTable table, String propertyName) {
        return table.getLabels().stream().anyMatch(label -> label.hasProperty(propertyName));
    }

    public Set<String> getAllVertexLabels() {
        return this.labelVertexTables.keySet();
    }

    public Set<String> getAllEdgeLabels() {
        return this.labelEdgeTables.keySet();
    }

    public Set<String> getVertexTablesForLabel(String labelName) {
        return this.labelVertexTables.get(labelName);
    }

    public Set<String> getEdgeTablesForLabel(String labelName) {
        return this.labelEdgeTables.get(labelName);
    }

    public Set<String> getVertexPropertiesForLabel(String labelName) {
        return this.getPropertiesForLabel(this.vertexLabels.get(labelName));
    }

    public Set<String> getEdgePropertiesForLabel(String labelName) {
        return this.getPropertiesForLabel(this.edgeLabels.get(labelName));
    }

    private Set<String> getPropertiesForLabel(Label label) {
        return label.getProperties();
    }

    public String getSrcTable(String edgeTable) {
        return this.edgeTables.get(edgeTable).getSource();
    }

    public String getDstTable(String edgeTable) {
        return this.edgeTables.get(edgeTable).getDestination();
    }

    public Set<String> getInputTables(String vertexTable) {
        return this.getInputOrOutputTables(vertexTable, EdgeTable::getDestination);
    }

    public Set<String> getOutputTables(String vertexTable) {
        return this.getInputOrOutputTables(vertexTable, EdgeTable::getSource);
    }

    private Set<String> getInputOrOutputTables(String vertexTable, Function<EdgeTable, String> getTable) {
        HashSet<String> tables = new HashSet<String>();
        for (String edgeTable : this.edgeTables.keySet()) {
            if (!getTable.apply(this.edgeTables.get(edgeTable)).equals(vertexTable)) continue;
            tables.add(edgeTable);
        }
        return tables;
    }

    public SchemaQualifiedName getSchemaQualifiedVertexTableName(String tableName) {
        return this.vertexTables.get(tableName).getTableName();
    }

    public SchemaQualifiedName getSchemaQualifiedEdgeTableName(String tableName) {
        return this.edgeTables.get(tableName).getTableName();
    }

    public List<String> getVertexTableKey(String tableName) {
        return this.getTableKey(this.vertexTables.get(tableName));
    }

    public List<String> getEdgeTableKey(String tableName) {
        return this.getTableKey(this.edgeTables.get(tableName));
    }

    private List<String> getTableKey(ElementTable table) {
        return table.getKey().getColumnsList();
    }

    public List<String> getVertexTableKeyTypes(String tableName) {
        return this.getTableKeyTypes(this.vertexTables.get(tableName));
    }

    public List<String> getEdgeTableKeyTypes(String tableName) {
        return this.getTableKeyTypes(this.edgeTables.get(tableName));
    }

    public List<String> getTableKeyTypes(ElementTable table) {
        return table.getKey().getColumnsTypes();
    }

    public List<Pair<String, String>> getEdgeTableSrcKey(String tableName) {
        EdgeTable et = this.edgeTables.get(tableName);
        if (et.getRefSourceVtColumns() != null) {
            return this.getEdgeTableAdjacentKey(et.getSourceKey(), et.getRefSourceVtColumns());
        }
        return this.getEdgeTableAdjacentKey(et.getSourceKey(), this.vertexTables.get(et.getSource()).getKey());
    }

    public List<Pair<String, String>> getEdgeTableDstKey(String tableName) {
        EdgeTable et = this.edgeTables.get(tableName);
        if (et.getRefDestinationVtColumns() != null) {
            return this.getEdgeTableAdjacentKey(et.getDestinationKey(), et.getRefDestinationVtColumns());
        }
        return this.getEdgeTableAdjacentKey(et.getDestinationKey(), this.vertexTables.get(et.getDestination()).getKey());
    }

    private List<Pair<String, String>> getEdgeTableAdjacentKey(Key etKey, Key vtKey) {
        ArrayList<Pair<String, String>> key = new ArrayList<Pair<String, String>>();
        List<String> etList = etKey.getColumnsList();
        List<String> vtList = vtKey.getColumnsList();
        for (int i = 0; i < etList.size(); ++i) {
            key.add(new Pair<String, String>(etList.get(i), vtList.get(i)));
        }
        return key;
    }

    public String getColumnNameForVertexTable(String tableName, String propertyName) {
        return this.getColumnNameForTable(this.vertexTables.get(tableName), propertyName);
    }

    public String getColumnNameForEdgeTable(String tableName, String propertyName) {
        return this.getColumnNameForTable(this.edgeTables.get(tableName), propertyName);
    }

    private String getColumnNameForTable(ElementTable table, String propertyName) {
        for (Label label : table.getLabels()) {
            if (!label.hasProperty(propertyName)) continue;
            return label.getProperty(propertyName).getColumn().getName();
        }
        return null;
    }

    private String getTableForSuffix(String suffix) {
        try {
            return DbmsUtils.getTableForSuffix(this.conn, this.graphSchema, this.graphName, suffix);
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    public static boolean existsPgView(Connection conn, String graphOwner, String graphName) {
        if (graphName == null) {
            throw new PgqlToSqlException("Graph name is not set for this PgqlStatement. Use setGraph method in PgqlConnection or specify a graph name in the query");
        }
        return GraphType.PG_VIEWS == PgqlUtils.getGraphType(conn, graphOwner, graphName, false, false);
    }

    public String getLabelForVertexTable(String tableName) {
        return this.getLabelForTable(this.vertexTables.get(tableName));
    }

    public String getLabelForEdgeTable(String tableName) {
        return this.getLabelForTable(this.edgeTables.get(tableName));
    }

    public String getLabelForTable(ElementTable table) {
        return table.getLabels().iterator().next().getLabel();
    }

    public boolean isNotVertexStringKeyColumn(String tableName, String columnName) {
        return this.isNotStringKeyColumn(this.vertexTables.get(tableName), tableName, columnName);
    }

    public boolean isNotEdgeStringKeyColumn(String tableName, String columnName) {
        return this.isNotStringKeyColumn(this.edgeTables.get(tableName), tableName, columnName);
    }

    private boolean isNotStringKeyColumn(ElementTable table, String tableName, String columnName) {
        return !Column.isStringType(this.getTypeForKeyColumn(table, tableName, columnName, false));
    }

    public String getTypeForVertexKeyColumn(String tableName, String columnName) {
        return this.getTypeForKeyColumn(this.vertexTables.get(tableName), tableName, columnName, true);
    }

    public String getTypeForEdgeKeyColumn(String tableName, String columnName) {
        return this.getTypeForKeyColumn(this.edgeTables.get(tableName), tableName, columnName, true);
    }

    private String getTypeForKeyColumn(ElementTable table, String tableName, String columnName, boolean appendLength) {
        if (table.getKey().hasColumn(columnName)) {
            return table.getKey().getColumn(columnName).getType(appendLength);
        }
        if (table instanceof EdgeTable) {
            EdgeTable et = (EdgeTable)table;
            Key sourceKey = et.getSourceKey();
            if (sourceKey.hasColumn(columnName)) {
                return sourceKey.getColumn(columnName).getType(appendLength);
            }
            Key destinationKey = et.getDestinationKey();
            if (destinationKey.hasColumn(columnName)) {
                return destinationKey.getColumn(columnName).getType(appendLength);
            }
        }
        throw new PgqlToSqlException("Table or view " + tableName + " does not have a column " + columnName);
    }

    public String getColumnTypeForVertexProperty(String tableName, String propertyName) {
        return this.getColumnTypeForProperty(this.vertexTables.get(tableName), propertyName);
    }

    public String getColumnTypeForEdgeProperty(String tableName, String propertyName) {
        return this.getColumnTypeForProperty(this.edgeTables.get(tableName), propertyName);
    }

    private String getColumnTypeForProperty(ElementTable table, String propertyName) {
        for (Label label : table.getLabels()) {
            if (!label.hasProperty(propertyName)) continue;
            return label.getProperty(propertyName).getColumn().getType(true);
        }
        return null;
    }

    public Map<String, VertexTable> getVertexTables() {
        return this.vertexTables;
    }

    public Map<String, EdgeTable> getEdgeTables() {
        return this.edgeTables;
    }
}

