/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.pgview.translation.GraphPatternTranslator;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.ElementTable;
import oracle.pgql.lang.ddl.propertygraph.Label;
import oracle.pgql.lang.ddl.propertygraph.Property;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.QueryExpression;

public class PgqlCreatePgVerifier {
    static final String CHECK_TYPE_STMT = "select data_type, data_length\nfrom sys.all_tab_columns atc\nwhere atc.owner = ?\n  and atc.table_name = ?\n  and atc.column_name = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verify(CreatePropertyGraph cpg, Connection conn, boolean checkTypes) throws SQLException {
        HashMap<String, Pair<String, Set<String>>> labelProperties = new HashMap<String, Pair<String, Set<String>>>();
        HashMap<String, Pair<String, Map<String, String>>> labelTypes = new HashMap<String, Pair<String, Map<String, String>>>();
        try (PreparedStatement ps = null;){
            if (checkTypes) {
                ps = conn.prepareStatement(CHECK_TYPE_STMT);
            }
            for (VertexTable vt : cpg.getVertexTables()) {
                PgqlCreatePgVerifier.verifyElementTable((ElementTable)vt, labelProperties, labelTypes, ps, checkTypes);
            }
            for (EdgeTable et : cpg.getEdgeTables()) {
                PgqlCreatePgVerifier.verifyElementTable((ElementTable)et, labelProperties, labelTypes, ps, checkTypes);
            }
        }
    }

    public static void verifyElementTable(ElementTable et, Map<String, Pair<String, Set<String>>> labelProperties, Map<String, Pair<String, Map<String, String>>> labelTypes, PreparedStatement ps, boolean checkTypes) throws SQLException {
        String tableAlias = et.getTableAlias();
        String tableSchema = et.getTableName().getSchemaName();
        String tableName = et.getTableName().getName();
        if (et.getLabels().size() > 1) {
            throw new PgqlToSqlException("Table " + et.getTableAlias() + " has multiple labels. Multiple labels are not supported");
        }
        for (Label l : et.getLabels()) {
            PgqlCreatePgVerifier.verifyLabel(tableAlias, tableSchema, tableName, l, labelProperties, labelTypes, ps, checkTypes);
        }
    }

    private static void verifyLabel(String tableAlias, String tableSchema, String tableName, Label l, Map<String, Pair<String, Set<String>>> labelProperties, Map<String, Pair<String, Map<String, String>>> labelTypes, PreparedStatement ps, boolean checkTypes) throws SQLException {
        HashSet<String> properties = new HashSet<String>();
        HashMap<String, String> types = new HashMap<String, String>();
        for (Property property : l.getProperties()) {
            String propertyName = property.getPropertyName();
            properties.add(propertyName);
            if (!checkTypes) continue;
            QueryExpression qe = property.getValueExpression();
            String columnName = ((QueryExpression.VarRef)qe).getVariable().getName();
            String type = PgqlCreatePgVerifier.getColumnType(ps, tableSchema, tableName, columnName);
            types.put(propertyName, type);
        }
        String labelName = l.getName();
        if (labelProperties.containsKey(labelName)) {
            if (!((Set)labelProperties.get((Object)labelName).second).equals(properties)) {
                String provider2;
                String provider1;
                HashSet difference;
                Set checkProperties = (Set)labelProperties.get((Object)labelName).second;
                if (properties.size() < checkProperties.size()) {
                    difference = new HashSet(checkProperties);
                    difference.removeAll(properties);
                    provider1 = tableAlias;
                    provider2 = (String)labelProperties.get((Object)labelName).first;
                } else {
                    difference = new HashSet(properties);
                    difference.removeAll(checkProperties);
                    provider1 = (String)labelProperties.get((Object)labelName).first;
                    provider2 = tableAlias;
                }
                throw new PgqlToSqlException("Property " + (String)difference.iterator().next() + " is not in label " + labelName + " of provider " + provider1 + ", but it is in label " + labelName + " of provider " + provider2);
            }
            if (checkTypes) {
                Map previousTypes = (Map)labelTypes.get((Object)labelName).second;
                for (String property : previousTypes.keySet()) {
                    String type2;
                    String type1 = (String)types.get(property);
                    if (GraphPatternTranslator.areCompatibleTypes(type1, type2 = (String)previousTypes.get(property))) continue;
                    String provider2 = (String)labelProperties.get((Object)labelName).first;
                    throw new PgqlToSqlException("Incompatible types. Property " + property + " of label " + labelName + " is of type " + type2 + " in provider " + provider2 + " but it is of type " + type1 + " in provider " + tableAlias);
                }
            }
        } else {
            labelProperties.put(labelName, new Pair(tableAlias, properties));
            if (checkTypes) {
                labelTypes.put(labelName, new Pair(tableAlias, types));
            }
        }
    }

    static String getColumnType(PreparedStatement ps, String owner, String tableName, String columnName) throws SQLException {
        ps.setString(1, owner);
        ps.setString(2, tableName);
        ps.setString(3, columnName);
        try (ResultSet rs = ps.executeQuery();){
            rs.next();
            String string = rs.getString(1);
            return string;
        }
    }
}

