/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractFileGraphConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ExternalStoreConfig;
import oracle.pgx.config.FileGraphStoringConfig;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphErrorHandlingConfig;
import oracle.pgx.config.GraphLoadingConfig;
import oracle.pgx.config.GraphOptimizedFor;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PartitionWhileLoading;
import oracle.pgx.config.PropertiesConfigParser;

public class FileGraphConfig
extends AbstractFileGraphConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static FileGraphConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return FileGraphConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static FileGraphConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return FileGraphConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static FileGraphConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new FileGraphConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static FileGraphConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new FileGraphConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static FileGraphConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new FileGraphConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected FileGraphConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    @Override
    public List<String> getVertexUris() {
        return (List)this.values.get(Field.VERTEX_URIS);
    }

    @Override
    public List<String> getEdgeUris() {
        return (List)this.values.get(Field.EDGE_URIS);
    }

    @Override
    public Object getVertexIdColumn() {
        return this.values.get(Field.VERTEX_ID_COLUMN);
    }

    @Override
    public Object getEdgeIdColumn() {
        return this.values.get(Field.EDGE_ID_COLUMN);
    }

    @Override
    public Object getEdgeSourceColumn() {
        return this.values.get(Field.EDGE_SOURCE_COLUMN);
    }

    @Override
    public Object getEdgeDestinationColumn() {
        return this.values.get(Field.EDGE_DESTINATION_COLUMN);
    }

    @Override
    public Object getVertexLabelsColumn() {
        return this.values.get(Field.VERTEX_LABELS_COLUMN);
    }

    @Override
    public Object getEdgeLabelColumn() {
        return this.values.get(Field.EDGE_LABEL_COLUMN);
    }

    @Override
    public String getSeparator() {
        return (String)this.values.get(Field.SEPARATOR);
    }

    @Override
    public Boolean isHeader() {
        return (Boolean)this.values.get(Field.HEADER);
    }

    @Override
    public Boolean isDetectGzip() {
        return (Boolean)this.values.get(Field.DETECT_GZIP);
    }

    @Override
    public FileGraphStoringConfig getStoring() {
        return (FileGraphStoringConfig)this.values.get(Field.STORING);
    }

    @Override
    public GraphOptimizedFor getOptimizedFor() {
        return (GraphOptimizedFor)((Object)this.values.get(Field.OPTIMIZED_FOR));
    }

    @Override
    public PartitionWhileLoading getPartitionWhileLoading() {
        return (PartitionWhileLoading)((Object)this.values.get(Field.PARTITION_WHILE_LOADING));
    }

    @Override
    public IdStrategy getVertexIdStrategy() {
        return (IdStrategy)this.values.get(Field.VERTEX_ID_STRATEGY);
    }

    @Override
    public IdStrategy getEdgeIdStrategy() {
        return (IdStrategy)this.values.get(Field.EDGE_ID_STRATEGY);
    }

    @Override
    public IdType getVertexIdType() {
        return (IdType)this.values.get(Field.VERTEX_ID_TYPE);
    }

    @Override
    public IdType getEdgeIdType() {
        return (IdType)this.values.get(Field.EDGE_ID_TYPE);
    }

    @Override
    public Format getFormat() {
        return (Format)((Object)this.values.get(Field.FORMAT));
    }

    @Override
    public Double getArrayCompactionThreshold() {
        return (Double)this.values.get(Field.ARRAY_COMPACTION_THRESHOLD);
    }

    @Override
    public List<GraphPropertyConfig> getVertexProps() {
        return (List)this.values.get(Field.VERTEX_PROPS);
    }

    @Override
    public List<GraphPropertyConfig> getEdgeProps() {
        return (List)this.values.get(Field.EDGE_PROPS);
    }

    @Override
    public GraphLoadingConfig getLoading() {
        return (GraphLoadingConfig)this.values.get(Field.LOADING);
    }

    @Override
    public List<ExternalStoreConfig> getExternalStores() {
        return (List)this.values.get(Field.EXTERNAL_STORES);
    }

    @Override
    public GraphErrorHandlingConfig getErrorHandling() {
        return (GraphErrorHandlingConfig)this.values.get(Field.ERROR_HANDLING);
    }

    @Override
    public List<String> getLocalDateFormat() {
        return (List)this.values.get(Field.LOCAL_DATE_FORMAT);
    }

    @Override
    public List<String> getTimeFormat() {
        return (List)this.values.get(Field.TIME_FORMAT);
    }

    @Override
    public List<String> getTimestampFormat() {
        return (List)this.values.get(Field.TIMESTAMP_FORMAT);
    }

    @Override
    public List<String> getTimeWithTimezoneFormat() {
        return (List)this.values.get(Field.TIME_WITH_TIMEZONE_FORMAT);
    }

    @Override
    public List<String> getTimestampWithTimezoneFormat() {
        return (List)this.values.get(Field.TIMESTAMP_WITH_TIMEZONE_FORMAT);
    }

    @Override
    public Character getVectorComponentDelimiter() {
        return (Character)this.values.get(Field.VECTOR_COMPONENT_DELIMITER);
    }

    public String getPoint2d() {
        return (String)this.values.get(Field.POINT2D);
    }

    @Override
    public Map getAttributes() {
        return (Map)this.values.get(Field.ATTRIBUTES);
    }

    @Override
    public String getKeystoreAlias() {
        return (String)this.values.get(Field.KEYSTORE_ALIAS);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileGraphConfig other = (FileGraphConfig)obj;
        if (!Objects.equals(this.getVertexUrisWithScheme(), other.getVertexUrisWithScheme())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeUrisWithScheme(), other.getEdgeUrisWithScheme())) {
            return false;
        }
        if (!Objects.equals(this.getVertexIdColumn(), other.getVertexIdColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeIdColumn(), other.getEdgeIdColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeSourceColumn(), other.getEdgeSourceColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeDestinationColumn(), other.getEdgeDestinationColumn())) {
            return false;
        }
        if (!Objects.equals(this.getVertexLabelsColumn(), other.getVertexLabelsColumn())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeLabelColumn(), other.getEdgeLabelColumn())) {
            return false;
        }
        if (!Objects.equals(this.getSeparator(), other.getSeparator())) {
            return false;
        }
        if (!Objects.equals(this.isHeader(), other.isHeader())) {
            return false;
        }
        if (!Objects.equals(this.isDetectGzip(), other.isDetectGzip())) {
            return false;
        }
        if (!Objects.equals((Object)this.getOptimizedFor(), (Object)other.getOptimizedFor())) {
            return false;
        }
        if (!Objects.equals((Object)this.getPartitionWhileLoading(), (Object)other.getPartitionWhileLoading())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedVertexIdStrategy(), other.getValidatedVertexIdStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedEdgeIdStrategy(), other.getValidatedEdgeIdStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedVertexIdType(), other.getValidatedVertexIdType())) {
            return false;
        }
        if (!Objects.equals(this.getValidatedEdgeIdType(), other.getValidatedEdgeIdType())) {
            return false;
        }
        if (!Objects.equals((Object)this.getFormat(), (Object)other.getFormat())) {
            return false;
        }
        if (!Objects.equals(this.getArrayCompactionThreshold(), other.getArrayCompactionThreshold())) {
            return false;
        }
        if (!Objects.equals(this.getVertexProps(), other.getVertexProps())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeProps(), other.getEdgeProps())) {
            return false;
        }
        if (!Objects.equals(this.getLoading(), other.getLoading())) {
            return false;
        }
        if (!Objects.equals(this.getExternalStores(), other.getExternalStores())) {
            return false;
        }
        if (!Objects.equals(this.getErrorHandling(), other.getErrorHandling())) {
            return false;
        }
        if (!Objects.equals(this.getLocalDateFormat(), other.getLocalDateFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimeFormat(), other.getTimeFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimestampFormat(), other.getTimestampFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimeWithTimezoneFormat(), other.getTimeWithTimezoneFormat())) {
            return false;
        }
        if (!Objects.equals(this.getTimestampWithTimezoneFormat(), other.getTimestampWithTimezoneFormat())) {
            return false;
        }
        if (!Objects.equals(this.getVectorComponentDelimiter(), other.getVectorComponentDelimiter())) {
            return false;
        }
        if (!Objects.equals(this.getPoint2d(), other.getPoint2d())) {
            return false;
        }
        if (!Objects.equals(this.getAttributes(), other.getAttributes())) {
            return false;
        }
        if (!Objects.equals(this.values.get(Field.PASSWORD), other.values.get(Field.PASSWORD))) {
            return false;
        }
        return Objects.equals(this.getKeystoreAlias(), other.getKeystoreAlias());
    }

    public static enum Field implements ConfigField
    {
        VERTEX_URIS(Arrays.asList("uris", "vertex_uri_list"), Arrays.asList("uri"), String.class, false, Collections.emptyList(), true, true, false, false),
        EDGE_URIS(Arrays.asList("edge_uri_list"), Collections.emptyList(), String.class, false, Collections.emptyList(), true, true, false, false),
        VERTEX_ID_COLUMN(Collections.emptyList(), Collections.emptyList(), Object.class, false, null, false, false, false, false),
        EDGE_ID_COLUMN(Collections.emptyList(), Collections.emptyList(), Object.class, false, null, false, false, false, false),
        EDGE_SOURCE_COLUMN(Collections.emptyList(), Collections.emptyList(), Object.class, false, null, false, false, false, false),
        EDGE_DESTINATION_COLUMN(Collections.emptyList(), Collections.emptyList(), Object.class, false, null, false, false, false, false),
        VERTEX_LABELS_COLUMN(Collections.emptyList(), Collections.emptyList(), Object.class, false, null, false, false, false, false),
        EDGE_LABEL_COLUMN(Collections.emptyList(), Collections.emptyList(), Object.class, false, null, false, false, false, false),
        SEPARATOR(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        HEADER(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, false, false, false, false, false),
        DETECT_GZIP(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        STORING(Arrays.asList("storing_options"), Collections.emptyList(), FileGraphStoringConfig.class, false, Collections.emptyMap(), false, false, false, false),
        OPTIMIZED_FOR(Collections.emptyList(), Collections.emptyList(), GraphOptimizedFor.class, false, (Object)((Object)GraphOptimizedFor.READ), false, false, false, false),
        PARTITION_WHILE_LOADING(Collections.emptyList(), Collections.emptyList(), PartitionWhileLoading.class, false, null, false, false, false, false),
        VERTEX_ID_STRATEGY(Collections.emptyList(), Collections.emptyList(), IdStrategy.class, false, null, false, false, false, false),
        EDGE_ID_STRATEGY(Collections.emptyList(), Collections.emptyList(), IdStrategy.class, false, null, false, false, false, false),
        VERTEX_ID_TYPE(Arrays.asList("node_id_type"), Collections.emptyList(), IdType.class, false, null, false, false, false, false),
        EDGE_ID_TYPE(Collections.emptyList(), Collections.emptyList(), IdType.class, false, null, false, false, false, false),
        FORMAT(Collections.emptyList(), Collections.emptyList(), Format.class, false, null, false, false, false, false),
        ARRAY_COMPACTION_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Double.class, false, 0.2, false, false, false, false),
        VERTEX_PROPS(Arrays.asList("node_props"), Collections.emptyList(), GraphPropertyConfig.class, false, Collections.emptyList(), true, false, false, false),
        EDGE_PROPS(Collections.emptyList(), Collections.emptyList(), GraphPropertyConfig.class, false, Collections.emptyList(), true, false, false, false),
        LOADING(Arrays.asList("loading_options"), Collections.emptyList(), GraphLoadingConfig.class, false, Collections.emptyMap(), false, false, false, false),
        EXTERNAL_STORES(Collections.emptyList(), Collections.emptyList(), ExternalStoreConfig.class, false, Collections.emptyList(), true, false, false, false),
        ERROR_HANDLING(Collections.emptyList(), Collections.emptyList(), GraphErrorHandlingConfig.class, false, Collections.emptyMap(), false, false, false, false),
        LOCAL_DATE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-M[M]-d[d]", "M[M]/d[d]/yyyy", "d[d]-MMM-yyyy", "d[d]-M[M]-yyyy", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIME_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("h[h]:m[m][:s[s][.SSS]] a[ XXX]", "[yyyy-MM-dd'T']H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIMESTAMP_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIME_WITH_TIMEZONE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("h[h]:m[m][:s[s]] a[ XXX]", "[yyyy-MM-dd'T']H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        TIMESTAMP_WITH_TIMEZONE_FORMAT(Collections.emptyList(), Collections.emptyList(), String.class, false, Arrays.asList("yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd H[H]:m[m][:s[s][.SSS[SSS]]][XXX]", "yyyy-MM-dd'T'H[H]:m[m][:s[s][.SSSSSS]][XXX]"), true, false, false, false),
        VECTOR_COMPONENT_DELIMITER(Collections.emptyList(), Collections.emptyList(), Character.class, false, Character.valueOf(';'), false, false, false, false),
        POINT2D(Collections.emptyList(), Collections.emptyList(), String.class, false, "0.0 0.0", false, false, false, false),
        ATTRIBUTES(Collections.emptyList(), Collections.emptyList(), Map.class, false, Collections.emptyMap(), false, false, false, false),
        PASSWORD(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, true, true),
        KEYSTORE_ALIAS(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("file.graph.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

