/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.BasicSchedulerConfig;

public final class BasicSchedulerConfigBuilder {
    private final Map<BasicSchedulerConfig.Field, Object> values = new HashMap<BasicSchedulerConfig.Field, Object>();

    public static BasicSchedulerConfig buildBasicSchedulerConfig(Consumer<BasicSchedulerConfigBuilder> builderSetup) {
        BasicSchedulerConfigBuilder builder = new BasicSchedulerConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public BasicSchedulerConfigBuilder() {
    }

    public BasicSchedulerConfigBuilder(Map<BasicSchedulerConfig.Field, Object> values) {
        this.putAll(values);
    }

    public BasicSchedulerConfigBuilder(BasicSchedulerConfig config) {
        this.putAll(config);
    }

    public BasicSchedulerConfigBuilder(BasicSchedulerConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public BasicSchedulerConfigBuilder putAll(Map<BasicSchedulerConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public BasicSchedulerConfigBuilder putAll(BasicSchedulerConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public BasicSchedulerConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public BasicSchedulerConfig build(String parentPath) {
        try {
            return BasicSchedulerConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public BasicSchedulerConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<BasicSchedulerConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "BasicSchedulerConfigBuilder" + this.values;
    }

    public BasicSchedulerConfigBuilder setNumWorkersAnalysis(int numWorkersAnalysis) {
        this.values.put(BasicSchedulerConfig.Field.NUM_WORKERS_ANALYSIS, numWorkersAnalysis);
        return this;
    }

    public BasicSchedulerConfigBuilder setNumWorkersFastTrackAnalysis(int numWorkersFastTrackAnalysis) {
        this.values.put(BasicSchedulerConfig.Field.NUM_WORKERS_FAST_TRACK_ANALYSIS, numWorkersFastTrackAnalysis);
        return this;
    }

    public BasicSchedulerConfigBuilder setNumWorkersIo(int numWorkersIo) {
        this.values.put(BasicSchedulerConfig.Field.NUM_WORKERS_IO, numWorkersIo);
        return this;
    }
}

