# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .offer_term_info import OfferTermInfo


class MonetaryCredit(OfferTermInfo):
    """MonetaryCredit.

    :param effective_date: Indicates the date from which the meter rate or
     offer term is effective.
    :type effective_date: datetime
    :param excluded_meter_ids: An array of meter ids that are excluded from
     the given offer terms.
    :type excluded_meter_ids: list of str
    :param Name: Polymorphic Discriminator
    :type Name: str
    :param credit: The amount of credit provided under the terms of the given
     offer level. This field is used only by offer terms of type
     'MonetaryCredit'.
    :type credit: Decimal
    """ 

    _validation = {
        'Name': {'required': True},
    }

    _attribute_map = {
        'effective_date': {'key': 'EffectiveDate', 'type': 'iso-8601'},
        'excluded_meter_ids': {'key': 'ExcludedMeterIds', 'type': '[str]'},
        'Name': {'key': 'Name', 'type': 'str'},
        'credit': {'key': 'Credit', 'type': 'decimal'},
    }

    def __init__(self, effective_date=None, excluded_meter_ids=None, credit=None):
        super(MonetaryCredit, self).__init__(effective_date=effective_date, excluded_meter_ids=excluded_meter_ids)
        self.credit = credit
        self.Name = 'Monetary Credit'
