# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MeterInfo(Model):
    """Detailed information about the meter.

    :param meter_id: The unique identifier of the resource.
    :type meter_id: str
    :param meter_name: The name of the meter, within the given meter category
    :type meter_name: str
    :param meter_category: The category of the meter, e.g., 'Cloud services',
     'Networking', etc..
    :type meter_category: str
    :param meter_sub_category: The subcategory of the meter, e.g., 'A6 Cloud
     services', 'ExpressRoute (IXP)', etc..
    :type meter_sub_category: str
    :param unit: The unit in which the meter consumption is charged, e.g.,
     'Hours', 'GB', etc.
    :type unit: str
    :param meter_rates: The list of key/value pairs for the meter rates, in
     the format 'key':'value' where key = the meter quantity, and value = the
     corresponding price
    :type meter_rates: dict
    :param effective_date: Indicates the date from which the meter rate or
     offer term is effective.
    :type effective_date: datetime
    :param included_quantity: The resource quantity that is included in the
     offer at no cost. Consumption beyond this quantity will be charged.
    :type included_quantity: float
    """ 

    _attribute_map = {
        'meter_id': {'key': 'MeterId', 'type': 'str'},
        'meter_name': {'key': 'MeterName', 'type': 'str'},
        'meter_category': {'key': 'MeterCategory', 'type': 'str'},
        'meter_sub_category': {'key': 'MeterSubCategory', 'type': 'str'},
        'unit': {'key': 'Unit', 'type': 'str'},
        'meter_rates': {'key': 'MeterRates', 'type': '{float}'},
        'effective_date': {'key': 'EffectiveDate', 'type': 'iso-8601'},
        'included_quantity': {'key': 'IncludedQuantity', 'type': 'float'},
    }

    def __init__(self, meter_id=None, meter_name=None, meter_category=None, meter_sub_category=None, unit=None, meter_rates=None, effective_date=None, included_quantity=None):
        self.meter_id = meter_id
        self.meter_name = meter_name
        self.meter_category = meter_category
        self.meter_sub_category = meter_sub_category
        self.unit = unit
        self.meter_rates = meter_rates
        self.effective_date = effective_date
        self.included_quantity = included_quantity
