# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AutoPauseProperties(Model):
    """Spark pool auto-pausing properties.

    Auto-pausing properties of a Big Data pool powered by Apache Spark.

    :param delay_in_minutes: Number of minutes of idle time before the Big
     Data pool is automatically paused.
    :type delay_in_minutes: int
    :param enabled: Whether auto-pausing is enabled for the Big Data pool.
    :type enabled: bool
    """

    _attribute_map = {
        'delay_in_minutes': {'key': 'delayInMinutes', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(AutoPauseProperties, self).__init__(**kwargs)
        self.delay_in_minutes = kwargs.get('delay_in_minutes', None)
        self.enabled = kwargs.get('enabled', None)


class AutoScaleProperties(Model):
    """Spark pool auto-scaling properties.

    Auto-scaling properties of a Big Data pool powered by Apache Spark.

    :param min_node_count: The minimum number of nodes the Big Data pool can
     support.
    :type min_node_count: int
    :param enabled: Whether automatic scaling is enabled for the Big Data
     pool.
    :type enabled: bool
    :param max_node_count: The maximum number of nodes the Big Data pool can
     support.
    :type max_node_count: int
    """

    _attribute_map = {
        'min_node_count': {'key': 'minNodeCount', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'max_node_count': {'key': 'maxNodeCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(AutoScaleProperties, self).__init__(**kwargs)
        self.min_node_count = kwargs.get('min_node_count', None)
        self.enabled = kwargs.get('enabled', None)
        self.max_node_count = kwargs.get('max_node_count', None)


class AvailableRpOperation(Model):
    """An operation that is available in this resource provider.

    :param display: Display properties of the operation
    :type display: ~azure.mgmt.synapse.models.AvailableRpOperationDisplayInfo
    :param is_data_action: Whether this operation is a data action
    :type is_data_action: str
    :param name: Operation name
    :type name: str
    :param service_specification: Operation service specification
    :type service_specification:
     ~azure.mgmt.synapse.models.OperationMetaServiceSpecification
    :param origin: Operation origin
    :type origin: str
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'AvailableRpOperationDisplayInfo'},
        'is_data_action': {'key': 'isDataAction', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationMetaServiceSpecification'},
        'origin': {'key': 'origin', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AvailableRpOperation, self).__init__(**kwargs)
        self.display = kwargs.get('display', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.name = kwargs.get('name', None)
        self.service_specification = kwargs.get('service_specification', None)
        self.origin = kwargs.get('origin', None)


class AvailableRpOperationDisplayInfo(Model):
    """Description of an available operation.

    :param description: Operation description
    :type description: str
    :param resource: Resource type
    :type resource: str
    :param provider: Resource provider name
    :type provider: str
    :param operation: Operation name
    :type operation: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AvailableRpOperationDisplayInfo, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.resource = kwargs.get('resource', None)
        self.provider = kwargs.get('provider', None)
        self.operation = kwargs.get('operation', None)


class Resource(Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for a Azure Resource Manager resource with an
    etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class BigDataPoolPatchInfo(Model):
    """Patch for a Big Data pool.

    Properties patch for a Big Data pool.

    :param tags: Updated tags for the Big Data pool
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(BigDataPoolPatchInfo, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)


class BigDataPoolResourceInfo(TrackedResource):
    """Big Data pool.

    A Big Data pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param provisioning_state: The state of the Big Data pool.
    :type provisioning_state: str
    :param auto_scale: Auto-scaling properties
    :type auto_scale: ~azure.mgmt.synapse.models.AutoScaleProperties
    :param creation_date: The time when the Big Data pool was created.
    :type creation_date: datetime
    :param auto_pause: Auto-pausing properties
    :type auto_pause: ~azure.mgmt.synapse.models.AutoPauseProperties
    :param spark_events_folder: The Spark events folder
    :type spark_events_folder: str
    :param node_count: The number of nodes in the Big Data pool.
    :type node_count: int
    :param library_requirements: Library version requirements
    :type library_requirements: ~azure.mgmt.synapse.models.LibraryRequirements
    :param spark_version: The Apache Spark version.
    :type spark_version: str
    :param default_spark_log_folder: The default folder where Spark logs will
     be written.
    :type default_spark_log_folder: str
    :param node_size: The level of compute power that each node in the Big
     Data pool has. Possible values include: 'None', 'Small', 'Medium', 'Large'
    :type node_size: str or ~azure.mgmt.synapse.models.NodeSize
    :param node_size_family: The kind of nodes that the Big Data pool
     provides. Possible values include: 'None', 'MemoryOptimized'
    :type node_size_family: str or ~azure.mgmt.synapse.models.NodeSizeFamily
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'node_count': {'maximum': 200, 'minimum': 3},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'auto_scale': {'key': 'properties.autoScale', 'type': 'AutoScaleProperties'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'auto_pause': {'key': 'properties.autoPause', 'type': 'AutoPauseProperties'},
        'spark_events_folder': {'key': 'properties.sparkEventsFolder', 'type': 'str'},
        'node_count': {'key': 'properties.nodeCount', 'type': 'int'},
        'library_requirements': {'key': 'properties.libraryRequirements', 'type': 'LibraryRequirements'},
        'spark_version': {'key': 'properties.sparkVersion', 'type': 'str'},
        'default_spark_log_folder': {'key': 'properties.defaultSparkLogFolder', 'type': 'str'},
        'node_size': {'key': 'properties.nodeSize', 'type': 'str'},
        'node_size_family': {'key': 'properties.nodeSizeFamily', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BigDataPoolResourceInfo, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.auto_scale = kwargs.get('auto_scale', None)
        self.creation_date = kwargs.get('creation_date', None)
        self.auto_pause = kwargs.get('auto_pause', None)
        self.spark_events_folder = kwargs.get('spark_events_folder', None)
        self.node_count = kwargs.get('node_count', None)
        self.library_requirements = kwargs.get('library_requirements', None)
        self.spark_version = kwargs.get('spark_version', None)
        self.default_spark_log_folder = kwargs.get('default_spark_log_folder', None)
        self.node_size = kwargs.get('node_size', None)
        self.node_size_family = kwargs.get('node_size_family', None)


class CheckNameAvailabilityRequest(Model):
    """Check name availability request.

    A request about whether a workspace name is available.

    :param name: Workspace name
    :type name: str
    :param type: Type: workspace
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class CheckNameAvailabilityResponse(Model):
    """Check name availability response.

    A response saying whether the workspace name is available.

    :param message: Validation message
    :type message: str
    :param available: Whether the workspace name is available
    :type available: bool
    :param reason: Reason the workspace name is or is not available
    :type reason: str
    :param name: Workspace name
    :type name: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'available': {'key': 'available', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityResponse, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.available = kwargs.get('available', None)
        self.reason = kwargs.get('reason', None)
        self.name = kwargs.get('name', None)


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class CreateSqlPoolRestorePointDefinition(Model):
    """Contains the information necessary to perform a create Sql pool restore
    point operation.

    All required parameters must be populated in order to send to Azure.

    :param restore_point_label: Required. The restore point label to apply
    :type restore_point_label: str
    """

    _validation = {
        'restore_point_label': {'required': True},
    }

    _attribute_map = {
        'restore_point_label': {'key': 'restorePointLabel', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CreateSqlPoolRestorePointDefinition, self).__init__(**kwargs)
        self.restore_point_label = kwargs.get('restore_point_label', None)


class DataLakeStorageAccountDetails(Model):
    """Details of the data lake storage account associated with the workspace.

    :param account_url: Account URL
    :type account_url: str
    :param filesystem: Filesystem name
    :type filesystem: str
    """

    _attribute_map = {
        'account_url': {'key': 'accountUrl', 'type': 'str'},
        'filesystem': {'key': 'filesystem', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(DataLakeStorageAccountDetails, self).__init__(**kwargs)
        self.account_url = kwargs.get('account_url', None)
        self.filesystem = kwargs.get('filesystem', None)


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProxyResource, self).__init__(**kwargs)


class DataWarehouseUserActivities(ProxyResource):
    """User activities of a data warehouse.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar active_queries_count: Count of running and suspended queries.
    :vartype active_queries_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'active_queries_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'active_queries_count': {'key': 'properties.activeQueriesCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(DataWarehouseUserActivities, self).__init__(**kwargs)
        self.active_queries_count = None


class ErrorAdditionalInfo(Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorContract(Model):
    """Error details.

    Contains details when the response code indicates an error.

    :param error: The error details.
    :type error: ~azure.mgmt.synapse.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(self, **kwargs):
        super(ErrorContract, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorContractException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorContract'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorContractException, self).__init__(deserialize, response, 'ErrorContract', *args)


class ErrorDetail(Model):
    """Error details.

    :param message: Error message
    :type message: str
    :param code: Error code
    :type code: str
    :param target: Error target
    :type target: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorDetail, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.code = kwargs.get('code', None)
        self.target = kwargs.get('target', None)


class ErrorResponse(Model):
    """The resource management error response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.synapse.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.synapse.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class GeoBackupPolicy(ProxyResource):
    """A database geo backup policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param state: Required. The state of the geo backup policy. Possible
     values include: 'Disabled', 'Enabled'
    :type state: str or ~azure.mgmt.synapse.models.GeoBackupPolicyState
    :ivar storage_type: The storage type of the geo backup policy.
    :vartype storage_type: str
    :ivar kind: Kind of geo backup policy.  This is metadata used for the
     Azure portal experience.
    :vartype kind: str
    :ivar location: Backup policy location.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
        'storage_type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'GeoBackupPolicyState'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(GeoBackupPolicy, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.storage_type = None
        self.kind = None
        self.location = None


class IpFirewallRuleInfo(ProxyResource):
    """IP firewall rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param end_ip_address: The end IP address of the firewall rule. Must be
     IPv4 format. Must be greater than or equal to startIpAddress
    :type end_ip_address: str
    :ivar provisioning_state: Resource provisioning state. Possible values
     include: 'Provisioning', 'Succeeded', 'Deleting', 'Failed', 'DeleteError'
    :vartype provisioning_state: str or
     ~azure.mgmt.synapse.models.ProvisioningState
    :param start_ip_address: The start IP address of the firewall rule. Must
     be IPv4 format
    :type start_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IpFirewallRuleInfo, self).__init__(**kwargs)
        self.end_ip_address = kwargs.get('end_ip_address', None)
        self.provisioning_state = None
        self.start_ip_address = kwargs.get('start_ip_address', None)


class IpFirewallRuleProperties(Model):
    """IP firewall rule properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param end_ip_address: The end IP address of the firewall rule. Must be
     IPv4 format. Must be greater than or equal to startIpAddress
    :type end_ip_address: str
    :ivar provisioning_state: Resource provisioning state. Possible values
     include: 'Provisioning', 'Succeeded', 'Deleting', 'Failed', 'DeleteError'
    :vartype provisioning_state: str or
     ~azure.mgmt.synapse.models.ProvisioningState
    :param start_ip_address: The start IP address of the firewall rule. Must
     be IPv4 format
    :type start_ip_address: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'end_ip_address': {'key': 'endIpAddress', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'start_ip_address': {'key': 'startIpAddress', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IpFirewallRuleProperties, self).__init__(**kwargs)
        self.end_ip_address = kwargs.get('end_ip_address', None)
        self.provisioning_state = None
        self.start_ip_address = kwargs.get('start_ip_address', None)


class LibraryRequirements(Model):
    """Spark pool library version requirements.

    Library requirements for a Big Data pool powered by Apache Spark.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar time: The last update time of the library requirements file.
    :vartype time: datetime
    :param content: The library requirements.
    :type content: str
    :param filename: The filename of the library requirements file.
    :type filename: str
    """

    _validation = {
        'time': {'readonly': True},
    }

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'content': {'key': 'content', 'type': 'str'},
        'filename': {'key': 'filename', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LibraryRequirements, self).__init__(**kwargs)
        self.time = None
        self.content = kwargs.get('content', None)
        self.filename = kwargs.get('filename', None)


class ManagedIdentity(Model):
    """The workspace managed identity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal ID of the workspace managed identity
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the workspace managed identity
    :vartype tenant_id: str
    :param type: The type of managed identity for the workspace. Possible
     values include: 'None', 'SystemAssigned'
    :type type: str or ~azure.mgmt.synapse.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceIdentityType'},
    }

    def __init__(self, **kwargs):
        super(ManagedIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)


class ManagedIdentitySqlControlSettingsModel(ProxyResource):
    """Managed Identity Sql Control Settings.

    Sql Control Settings for workspace managed identity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param grant_sql_control_to_managed_identity: Grant sql control to managed
     identity
    :type grant_sql_control_to_managed_identity:
     ~azure.mgmt.synapse.models.ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'grant_sql_control_to_managed_identity': {'key': 'properties.grantSqlControlToManagedIdentity', 'type': 'ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity'},
    }

    def __init__(self, **kwargs):
        super(ManagedIdentitySqlControlSettingsModel, self).__init__(**kwargs)
        self.grant_sql_control_to_managed_identity = kwargs.get('grant_sql_control_to_managed_identity', None)


class ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity(Model):
    """Grant sql control to managed identity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param desired_state: Desired state. Possible values include: 'Enabled',
     'Disabled'
    :type desired_state: str or ~azure.mgmt.synapse.models.enum
    :ivar actual_state: Actual state. Possible values include: 'Enabling',
     'Enabled', 'Disabling', 'Disabled', 'Unknown'
    :vartype actual_state: str or ~azure.mgmt.synapse.models.enum
    """

    _validation = {
        'actual_state': {'readonly': True},
    }

    _attribute_map = {
        'desired_state': {'key': 'desiredState', 'type': 'str'},
        'actual_state': {'key': 'actualState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentity, self).__init__(**kwargs)
        self.desired_state = kwargs.get('desired_state', None)
        self.actual_state = None


class MetadataSyncConfig(ProxyResource):
    """Metadata sync configuration.

    Configuration for metadata sync.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param enabled: Indicates whether the metadata sync is enabled or disabled
    :type enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(MetadataSyncConfig, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)


class OperationMetaLogSpecification(Model):
    """What is this?.

    :param display_name: Log display name
    :type display_name: str
    :param blob_duration: Time range the log covers
    :type blob_duration: str
    :param name: Log unique name
    :type name: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationMetaLogSpecification, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.blob_duration = kwargs.get('blob_duration', None)
        self.name = kwargs.get('name', None)


class OperationMetaMetricDimensionSpecification(Model):
    """What is this?.

    :param display_name: Dimension display name
    :type display_name: str
    :param name: Dimension unique name
    :type name: str
    :param to_be_exported_for_shoebox: Whether this metric should be exported
     for Shoebox
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(OperationMetaMetricDimensionSpecification, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.name = kwargs.get('name', None)
        self.to_be_exported_for_shoebox = kwargs.get('to_be_exported_for_shoebox', None)


class OperationMetaMetricSpecification(Model):
    """What is this?.

    :param source_mdm_namespace: The source MDM namespace
    :type source_mdm_namespace: str
    :param display_name: Metric display name
    :type display_name: str
    :param name: Metric unique name
    :type name: str
    :param aggregation_type: Metric aggregation type
    :type aggregation_type: str
    :param display_description: Metric description
    :type display_description: str
    :param source_mdm_account: The source MDM account
    :type source_mdm_account: str
    :param enable_regional_mdm_account: Whether the regional MDM account is
     enabled
    :type enable_regional_mdm_account: bool
    :param unit: Metric units
    :type unit: str
    :param dimensions: Metric dimensions
    :type dimensions:
     list[~azure.mgmt.synapse.models.OperationMetaMetricDimensionSpecification]
    :param supports_instance_level_aggregation: Whether the metric supports
     instance-level aggregation
    :type supports_instance_level_aggregation: bool
    :param metric_filter_pattern: Metric filter
    :type metric_filter_pattern: str
    """

    _attribute_map = {
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'unit': {'key': 'unit', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[OperationMetaMetricDimensionSpecification]'},
        'supports_instance_level_aggregation': {'key': 'supportsInstanceLevelAggregation', 'type': 'bool'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationMetaMetricSpecification, self).__init__(**kwargs)
        self.source_mdm_namespace = kwargs.get('source_mdm_namespace', None)
        self.display_name = kwargs.get('display_name', None)
        self.name = kwargs.get('name', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.display_description = kwargs.get('display_description', None)
        self.source_mdm_account = kwargs.get('source_mdm_account', None)
        self.enable_regional_mdm_account = kwargs.get('enable_regional_mdm_account', None)
        self.unit = kwargs.get('unit', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.supports_instance_level_aggregation = kwargs.get('supports_instance_level_aggregation', None)
        self.metric_filter_pattern = kwargs.get('metric_filter_pattern', None)


class OperationMetaServiceSpecification(Model):
    """What is this?.

    :param metric_specifications: Service metric specifications
    :type metric_specifications:
     list[~azure.mgmt.synapse.models.OperationMetaMetricSpecification]
    :param log_specifications: Service log specifications
    :type log_specifications:
     list[~azure.mgmt.synapse.models.OperationMetaLogSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationMetaMetricSpecification]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[OperationMetaLogSpecification]'},
    }

    def __init__(self, **kwargs):
        super(OperationMetaServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)
        self.log_specifications = kwargs.get('log_specifications', None)


class OperationResource(Model):
    """An operation.

    :param id: Operation ID
    :type id: str
    :param name: Operation name
    :type name: str
    :param status: Operation status. Possible values include: 'InProgress',
     'Succeeded', 'Failed', 'Canceled'
    :type status: str or ~azure.mgmt.synapse.models.OperationStatus
    :param properties: Operation properties
    :type properties: object
    :param error: Errors from the operation
    :type error: ~azure.mgmt.synapse.models.ErrorDetail
    :param start_time: Operation start time
    :type start_time: datetime
    :param end_time: Operation start time
    :type end_time: datetime
    :param percent_complete: Completion percentage of the operation
    :type percent_complete: float
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'percentComplete', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(OperationResource, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.status = kwargs.get('status', None)
        self.properties = kwargs.get('properties', None)
        self.error = kwargs.get('error', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.percent_complete = kwargs.get('percent_complete', None)


class QueryInterval(Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar interval_start_time: The start time of the measurement interval
     (ISO8601 format).
    :vartype interval_start_time: datetime
    :ivar execution_count: The number of times the query was executed during
     this interval.
    :vartype execution_count: float
    :ivar metrics: The list of query metrics during this interval.
    :vartype metrics: list[~azure.mgmt.synapse.models.QueryMetric]
    """

    _validation = {
        'interval_start_time': {'readonly': True},
        'execution_count': {'readonly': True},
        'metrics': {'readonly': True},
    }

    _attribute_map = {
        'interval_start_time': {'key': 'intervalStartTime', 'type': 'iso-8601'},
        'execution_count': {'key': 'executionCount', 'type': 'float'},
        'metrics': {'key': 'metrics', 'type': '[QueryMetric]'},
    }

    def __init__(self, **kwargs):
        super(QueryInterval, self).__init__(**kwargs)
        self.interval_start_time = None
        self.execution_count = None
        self.metrics = None


class QueryMetric(Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the metric
    :vartype name: str
    :ivar display_name: The name of the metric for display in user interface
    :vartype display_name: str
    :ivar unit: The unit of measurement. Possible values include:
     'percentage', 'KB', 'microseconds'
    :vartype unit: str or ~azure.mgmt.synapse.models.QueryMetricUnit
    :ivar value: The measured value
    :vartype value: float
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'unit': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'QueryMetricUnit'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(QueryMetric, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.unit = None
        self.value = None


class QueryStatistic(Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar query_id: The id of the query
    :vartype query_id: str
    :ivar intervals: The list of query intervals.
    :vartype intervals: list[~azure.mgmt.synapse.models.QueryInterval]
    """

    _validation = {
        'query_id': {'readonly': True},
        'intervals': {'readonly': True},
    }

    _attribute_map = {
        'query_id': {'key': 'queryId', 'type': 'str'},
        'intervals': {'key': 'intervals', 'type': '[QueryInterval]'},
    }

    def __init__(self, **kwargs):
        super(QueryStatistic, self).__init__(**kwargs)
        self.query_id = None
        self.intervals = None


class ReplaceAllFirewallRulesOperationResponse(Model):
    """An existing operation for replacing the firewall rules.

    :param operation_id: The operation ID
    :type operation_id: str
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReplaceAllFirewallRulesOperationResponse, self).__init__(**kwargs)
        self.operation_id = kwargs.get('operation_id', None)


class ReplaceAllIpFirewallRulesRequest(Model):
    """Replace all IP firewall rules request.

    :param ip_firewall_rules: IP firewall rule properties
    :type ip_firewall_rules: dict[str,
     ~azure.mgmt.synapse.models.IpFirewallRuleProperties]
    """

    _attribute_map = {
        'ip_firewall_rules': {'key': 'ipFirewallRules', 'type': '{IpFirewallRuleProperties}'},
    }

    def __init__(self, **kwargs):
        super(ReplaceAllIpFirewallRulesRequest, self).__init__(**kwargs)
        self.ip_firewall_rules = kwargs.get('ip_firewall_rules', None)


class ReplicationLink(ProxyResource):
    """Represents a Sql pool replication link.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar location: Location of the workspace that contains this firewall
     rule.
    :vartype location: str
    :ivar is_termination_allowed: Legacy value indicating whether termination
     is allowed.  Currently always returns true.
    :vartype is_termination_allowed: bool
    :ivar replication_mode: Replication mode of this replication link.
    :vartype replication_mode: str
    :ivar partner_server: The name of the workspace hosting the partner Sql
     pool.
    :vartype partner_server: str
    :ivar partner_database: The name of the partner Sql pool.
    :vartype partner_database: str
    :ivar partner_location: The Azure Region of the partner Sql pool.
    :vartype partner_location: str
    :ivar role: The role of the Sql pool in the replication link. Possible
     values include: 'Primary', 'Secondary', 'NonReadableSecondary', 'Source',
     'Copy'
    :vartype role: str or ~azure.mgmt.synapse.models.ReplicationRole
    :ivar partner_role: The role of the partner Sql pool in the replication
     link. Possible values include: 'Primary', 'Secondary',
     'NonReadableSecondary', 'Source', 'Copy'
    :vartype partner_role: str or ~azure.mgmt.synapse.models.ReplicationRole
    :ivar start_time: The start time for the replication link.
    :vartype start_time: datetime
    :ivar percent_complete: The percentage of seeding complete for the
     replication link.
    :vartype percent_complete: int
    :ivar replication_state: The replication state for the replication link.
     Possible values include: 'PENDING', 'SEEDING', 'CATCH_UP', 'SUSPENDED'
    :vartype replication_state: str or
     ~azure.mgmt.synapse.models.ReplicationState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'is_termination_allowed': {'readonly': True},
        'replication_mode': {'readonly': True},
        'partner_server': {'readonly': True},
        'partner_database': {'readonly': True},
        'partner_location': {'readonly': True},
        'role': {'readonly': True},
        'partner_role': {'readonly': True},
        'start_time': {'readonly': True},
        'percent_complete': {'readonly': True},
        'replication_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'is_termination_allowed': {'key': 'properties.isTerminationAllowed', 'type': 'bool'},
        'replication_mode': {'key': 'properties.replicationMode', 'type': 'str'},
        'partner_server': {'key': 'properties.partnerServer', 'type': 'str'},
        'partner_database': {'key': 'properties.partnerDatabase', 'type': 'str'},
        'partner_location': {'key': 'properties.partnerLocation', 'type': 'str'},
        'role': {'key': 'properties.role', 'type': 'ReplicationRole'},
        'partner_role': {'key': 'properties.partnerRole', 'type': 'ReplicationRole'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'replication_state': {'key': 'properties.replicationState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReplicationLink, self).__init__(**kwargs)
        self.location = None
        self.is_termination_allowed = None
        self.replication_mode = None
        self.partner_server = None
        self.partner_database = None
        self.partner_location = None
        self.role = None
        self.partner_role = None
        self.start_time = None
        self.percent_complete = None
        self.replication_state = None


class ResourceMoveDefinition(Model):
    """Contains the information necessary to perform a resource move (rename).

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The target ID for the resource
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceMoveDefinition, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class RestorePoint(ProxyResource):
    """Database restore points.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar restore_point_type: The type of restore point. Possible values
     include: 'CONTINUOUS', 'DISCRETE'
    :vartype restore_point_type: str or
     ~azure.mgmt.synapse.models.RestorePointType
    :ivar earliest_restore_date: The earliest time to which this database can
     be restored
    :vartype earliest_restore_date: datetime
    :ivar restore_point_creation_date: The time the backup was taken
    :vartype restore_point_creation_date: datetime
    :ivar restore_point_label: The label of restore point for backup request
     by user
    :vartype restore_point_label: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'restore_point_type': {'readonly': True},
        'earliest_restore_date': {'readonly': True},
        'restore_point_creation_date': {'readonly': True},
        'restore_point_label': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'restore_point_type': {'key': 'properties.restorePointType', 'type': 'RestorePointType'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'restore_point_creation_date': {'key': 'properties.restorePointCreationDate', 'type': 'iso-8601'},
        'restore_point_label': {'key': 'properties.restorePointLabel', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RestorePoint, self).__init__(**kwargs)
        self.location = None
        self.restore_point_type = None
        self.earliest_restore_date = None
        self.restore_point_creation_date = None
        self.restore_point_label = None


class SensitivityLabel(ProxyResource):
    """A sensitivity label.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param label_name: The label name.
    :type label_name: str
    :param label_id: The label ID.
    :type label_id: str
    :param information_type: The information type.
    :type information_type: str
    :param information_type_id: The information type ID.
    :type information_type_id: str
    :ivar is_disabled: Is sensitivity recommendation disabled. Applicable for
     recommended sensitivity label only. Specifies whether the sensitivity
     recommendation on this column is disabled (dismissed) or not.
    :vartype is_disabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_disabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'label_name': {'key': 'properties.labelName', 'type': 'str'},
        'label_id': {'key': 'properties.labelId', 'type': 'str'},
        'information_type': {'key': 'properties.informationType', 'type': 'str'},
        'information_type_id': {'key': 'properties.informationTypeId', 'type': 'str'},
        'is_disabled': {'key': 'properties.isDisabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(SensitivityLabel, self).__init__(**kwargs)
        self.label_name = kwargs.get('label_name', None)
        self.label_id = kwargs.get('label_id', None)
        self.information_type = kwargs.get('information_type', None)
        self.information_type_id = kwargs.get('information_type_id', None)
        self.is_disabled = None


class Sku(Model):
    """Sku.

    SQL pool SKU.

    :param tier: The service tier
    :type tier: str
    :param name: The SKU name
    :type name: str
    """

    _attribute_map = {
        'tier': {'key': 'tier', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Sku, self).__init__(**kwargs)
        self.tier = kwargs.get('tier', None)
        self.name = kwargs.get('name', None)


class SqlPool(TrackedResource):
    """SQL pool.

    A SQL Analytics pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param sku: SQL pool SKU
    :type sku: ~azure.mgmt.synapse.models.Sku
    :param max_size_bytes: Maximum size in bytes
    :type max_size_bytes: long
    :param collation: Collation mode
    :type collation: str
    :param source_database_id: Source database to create from
    :type source_database_id: str
    :param recoverable_database_id: Backup database to restore from
    :type recoverable_database_id: str
    :param provisioning_state: Resource state
    :type provisioning_state: str
    :param status: Resource status
    :type status: str
    :param restore_point_in_time: Snapshot time to restore
    :type restore_point_in_time: datetime
    :param create_mode: What is this?
    :type create_mode: str
    :param creation_date: Date the SQL pool was created
    :type creation_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SqlPool, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.max_size_bytes = kwargs.get('max_size_bytes', None)
        self.collation = kwargs.get('collation', None)
        self.source_database_id = kwargs.get('source_database_id', None)
        self.recoverable_database_id = kwargs.get('recoverable_database_id', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.status = kwargs.get('status', None)
        self.restore_point_in_time = kwargs.get('restore_point_in_time', None)
        self.create_mode = kwargs.get('create_mode', None)
        self.creation_date = kwargs.get('creation_date', None)


class SqlPoolBlobAuditingPolicy(ProxyResource):
    """A Sql pool blob auditing policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :param state: Required. Specifies the state of the policy. If state is
     Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
     Possible values include: 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.synapse.models.BlobAuditingPolicyState
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled,
     storageEndpoint is required.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     auditing storage account. If state is Enabled and storageEndpoint is
     specified, storageAccountAccessKey is required.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the audit
     logs in the storage account.
    :type retention_days: int
    :param audit_actions_and_groups: Specifies the Actions-Groups and Actions
     to audit.
     The recommended set of action groups to use is the following combination -
     this will audit all the queries and stored procedures executed against the
     database, as well as successful and failed logins:
     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.
     This above combination is also the set that is configured by default when
     enabling auditing from the Azure portal.
     The supported action groups to audit are (note: choose only specific
     groups that cover your auditing needs. Using unnecessary groups could lead
     to very large quantities of audit records):
     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
     These are groups that cover all sql statements and stored procedures
     executed against the database, and should not be used in combination with
     other groups as this will result in duplicate audit logs.
     For more information, see [Database-Level Audit Action
     Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
     For Database auditing policy, specific Actions can also be specified (note
     that Actions cannot be specified for Server auditing policy). The
     supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES
     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}
     Note that <object> in the above format can refer to an object like a
     table, view, or stored procedure, or an entire database or schema. For the
     latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are
     used, respectively.
     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public
     For more information, see [Database-Level Audit
     Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
    :type audit_actions_and_groups: list[str]
    :param storage_account_subscription_id: Specifies the blob storage
     subscription Id.
    :type storage_account_subscription_id: str
    :param is_storage_secondary_key_in_use: Specifies whether
     storageAccountAccessKey value is the storage's secondary key.
    :type is_storage_secondary_key_in_use: bool
    :param is_azure_monitor_target_enabled: Specifies whether audit events are
     sent to Azure Monitor.
     In order to send the events to Azure Monitor, specify 'state' as 'Enabled'
     and 'isAzureMonitorTargetEnabled' as true.
     When using REST API to configure auditing, Diagnostic Settings with
     'SQLSecurityAuditEvents' diagnostic logs category on the database should
     be also created.
     Note that for server level audit you should use the 'master' database as
     {databaseName}.
     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
     For more information, see [Diagnostic Settings REST
     API](https://go.microsoft.com/fwlink/?linkid=2033207)
     or [Diagnostic Settings
     PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
    :type is_azure_monitor_target_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'BlobAuditingPolicyState'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'audit_actions_and_groups': {'key': 'properties.auditActionsAndGroups', 'type': '[str]'},
        'storage_account_subscription_id': {'key': 'properties.storageAccountSubscriptionId', 'type': 'str'},
        'is_storage_secondary_key_in_use': {'key': 'properties.isStorageSecondaryKeyInUse', 'type': 'bool'},
        'is_azure_monitor_target_enabled': {'key': 'properties.isAzureMonitorTargetEnabled', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolBlobAuditingPolicy, self).__init__(**kwargs)
        self.kind = None
        self.state = kwargs.get('state', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.audit_actions_and_groups = kwargs.get('audit_actions_and_groups', None)
        self.storage_account_subscription_id = kwargs.get('storage_account_subscription_id', None)
        self.is_storage_secondary_key_in_use = kwargs.get('is_storage_secondary_key_in_use', None)
        self.is_azure_monitor_target_enabled = kwargs.get('is_azure_monitor_target_enabled', None)


class SqlPoolColumn(ProxyResource):
    """A Sql pool column resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param column_type: The column data type. Possible values include:
     'image', 'text', 'uniqueidentifier', 'date', 'time', 'datetime2',
     'datetimeoffset', 'tinyint', 'smallint', 'int', 'smalldatetime', 'real',
     'money', 'datetime', 'float', 'sql_variant', 'ntext', 'bit', 'decimal',
     'numeric', 'smallmoney', 'bigint', 'hierarchyid', 'geometry', 'geography',
     'varbinary', 'varchar', 'binary', 'char', 'timestamp', 'nvarchar',
     'nchar', 'xml', 'sysname'
    :type column_type: str or ~azure.mgmt.synapse.models.ColumnDataType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'column_type': {'key': 'properties.columnType', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolColumn, self).__init__(**kwargs)
        self.column_type = kwargs.get('column_type', None)


class SqlPoolConnectionPolicy(ProxyResource):
    """A Sql pool connection policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :param security_enabled_access: The state of security access.
    :type security_enabled_access: str
    :param proxy_dns_name: The fully qualified host name of the auditing
     proxy.
    :type proxy_dns_name: str
    :param proxy_port: The port number of the auditing proxy.
    :type proxy_port: str
    :param visibility: The visibility of the auditing proxy.
    :type visibility: str
    :param use_server_default: Whether server default is enabled or disabled.
    :type use_server_default: str
    :param redirection_state: The state of proxy redirection.
    :type redirection_state: str
    :param state: The connection policy state.
    :type state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'security_enabled_access': {'key': 'properties.securityEnabledAccess', 'type': 'str'},
        'proxy_dns_name': {'key': 'properties.proxyDnsName', 'type': 'str'},
        'proxy_port': {'key': 'properties.proxyPort', 'type': 'str'},
        'visibility': {'key': 'properties.visibility', 'type': 'str'},
        'use_server_default': {'key': 'properties.useServerDefault', 'type': 'str'},
        'redirection_state': {'key': 'properties.redirectionState', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolConnectionPolicy, self).__init__(**kwargs)
        self.kind = None
        self.location = None
        self.security_enabled_access = kwargs.get('security_enabled_access', None)
        self.proxy_dns_name = kwargs.get('proxy_dns_name', None)
        self.proxy_port = kwargs.get('proxy_port', None)
        self.visibility = kwargs.get('visibility', None)
        self.use_server_default = kwargs.get('use_server_default', None)
        self.redirection_state = kwargs.get('redirection_state', None)
        self.state = kwargs.get('state', None)


class SqlPoolOperation(ProxyResource):
    """A Sql pool operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar database_name: The name of the Sql pool the operation is being
     performed on.
    :vartype database_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: datetime
    :ivar state: The operation state. Possible values include: 'Pending',
     'InProgress', 'Succeeded', 'Failed', 'CancelInProgress', 'Cancelled'
    :vartype state: str or ~azure.mgmt.synapse.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the
     operation.
    :vartype estimated_completion_time: datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'database_name': {'readonly': True},
        'operation': {'readonly': True},
        'operation_friendly_name': {'readonly': True},
        'percent_complete': {'readonly': True},
        'server_name': {'readonly': True},
        'start_time': {'readonly': True},
        'state': {'readonly': True},
        'error_code': {'readonly': True},
        'error_description': {'readonly': True},
        'error_severity': {'readonly': True},
        'is_user_error': {'readonly': True},
        'estimated_completion_time': {'readonly': True},
        'description': {'readonly': True},
        'is_cancellable': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'database_name': {'key': 'properties.databaseName', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'operation_friendly_name': {'key': 'properties.operationFriendlyName', 'type': 'str'},
        'percent_complete': {'key': 'properties.percentComplete', 'type': 'int'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'error_code': {'key': 'properties.errorCode', 'type': 'int'},
        'error_description': {'key': 'properties.errorDescription', 'type': 'str'},
        'error_severity': {'key': 'properties.errorSeverity', 'type': 'int'},
        'is_user_error': {'key': 'properties.isUserError', 'type': 'bool'},
        'estimated_completion_time': {'key': 'properties.estimatedCompletionTime', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'is_cancellable': {'key': 'properties.isCancellable', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolOperation, self).__init__(**kwargs)
        self.database_name = None
        self.operation = None
        self.operation_friendly_name = None
        self.percent_complete = None
        self.server_name = None
        self.start_time = None
        self.state = None
        self.error_code = None
        self.error_description = None
        self.error_severity = None
        self.is_user_error = None
        self.estimated_completion_time = None
        self.description = None
        self.is_cancellable = None


class SqlPoolPatchInfo(Model):
    """SQL pool patch info.

    A SQL Analytics pool patch info.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: The geo-location where the resource lives
    :type location: str
    :param sku: SQL pool SKU
    :type sku: ~azure.mgmt.synapse.models.Sku
    :param max_size_bytes: Maximum size in bytes
    :type max_size_bytes: long
    :param collation: Collation mode
    :type collation: str
    :param source_database_id: Source database to create from
    :type source_database_id: str
    :param recoverable_database_id: Backup database to restore from
    :type recoverable_database_id: str
    :param provisioning_state: Resource state
    :type provisioning_state: str
    :param status: Resource status
    :type status: str
    :param restore_point_in_time: Snapshot time to restore
    :type restore_point_in_time: datetime
    :param create_mode: What is this?
    :type create_mode: str
    :param creation_date: Date the SQL pool was created
    :type creation_date: datetime
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'max_size_bytes': {'key': 'properties.maxSizeBytes', 'type': 'long'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
        'source_database_id': {'key': 'properties.sourceDatabaseId', 'type': 'str'},
        'recoverable_database_id': {'key': 'properties.recoverableDatabaseId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolPatchInfo, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)
        self.sku = kwargs.get('sku', None)
        self.max_size_bytes = kwargs.get('max_size_bytes', None)
        self.collation = kwargs.get('collation', None)
        self.source_database_id = kwargs.get('source_database_id', None)
        self.recoverable_database_id = kwargs.get('recoverable_database_id', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.status = kwargs.get('status', None)
        self.restore_point_in_time = kwargs.get('restore_point_in_time', None)
        self.create_mode = kwargs.get('create_mode', None)
        self.creation_date = kwargs.get('creation_date', None)


class SqlPoolSchema(ProxyResource):
    """A Sql pool schema resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolSchema, self).__init__(**kwargs)


class SqlPoolSecurityAlertPolicy(ProxyResource):
    """A Sql pool security alert policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param state: Required. Specifies the state of the policy, whether it is
     enabled or disabled or a policy has not been applied yet on the specific
     Sql pool. Possible values include: 'New', 'Enabled', 'Disabled'
    :type state: str or ~azure.mgmt.synapse.models.SecurityAlertPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled.
     Allowed values are: Sql_Injection, Sql_Injection_Vulnerability,
     Access_Anomaly, Data_Exfiltration, Unsafe_Action
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which
     the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the
     account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all
     Threat Detection audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     Threat Detection audit storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat
     Detection audit logs.
    :type retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
        'creation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'SecurityAlertPolicyState'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.disabled_alerts = kwargs.get('disabled_alerts', None)
        self.email_addresses = kwargs.get('email_addresses', None)
        self.email_account_admins = kwargs.get('email_account_admins', None)
        self.storage_endpoint = kwargs.get('storage_endpoint', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.retention_days = kwargs.get('retention_days', None)
        self.creation_time = None


class SqlPoolTable(ProxyResource):
    """A Sql pool table resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolTable, self).__init__(**kwargs)


class SqlPoolUsage(Model):
    """The Sql pool usages.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the usage metric.
    :vartype name: str
    :ivar resource_name: The name of the resource.
    :vartype resource_name: str
    :ivar display_name: The usage metric display name.
    :vartype display_name: str
    :ivar current_value: The current value of the usage metric.
    :vartype current_value: float
    :ivar limit: The current limit of the usage metric.
    :vartype limit: float
    :ivar unit: The units of the usage metric.
    :vartype unit: str
    :ivar next_reset_time: The next reset time for the usage metric (ISO8601
     format).
    :vartype next_reset_time: datetime
    """

    _validation = {
        'name': {'readonly': True},
        'resource_name': {'readonly': True},
        'display_name': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'next_reset_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolUsage, self).__init__(**kwargs)
        self.name = None
        self.resource_name = None
        self.display_name = None
        self.current_value = None
        self.limit = None
        self.unit = None
        self.next_reset_time = None


class SqlPoolVulnerabilityAssessment(ProxyResource):
    """A Sql pool vulnerability assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param storage_container_path: A blob storage container path to hold the
     scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It
     is required if server level vulnerability assessment policy doesn't set
    :type storage_container_path: str
    :param storage_container_sas_key: A shared access signature (SAS Key) that
     has write access to the blob container specified in 'storageContainerPath'
     parameter. If 'storageAccountAccessKey' isn't specified,
     StorageContainerSasKey is required.
    :type storage_container_sas_key: str
    :param storage_account_access_key: Specifies the identifier key of the
     storage account for vulnerability assessment scan results. If
     'StorageContainerSasKey' isn't specified, storageAccountAccessKey is
     required.
    :type storage_account_access_key: str
    :param recurring_scans: The recurring scans settings
    :type recurring_scans:
     ~azure.mgmt.synapse.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'storage_container_sas_key': {'key': 'properties.storageContainerSasKey', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'recurring_scans': {'key': 'properties.recurringScans', 'type': 'VulnerabilityAssessmentRecurringScansProperties'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolVulnerabilityAssessment, self).__init__(**kwargs)
        self.storage_container_path = kwargs.get('storage_container_path', None)
        self.storage_container_sas_key = kwargs.get('storage_container_sas_key', None)
        self.storage_account_access_key = kwargs.get('storage_account_access_key', None)
        self.recurring_scans = kwargs.get('recurring_scans', None)


class SqlPoolVulnerabilityAssessmentRuleBaseline(ProxyResource):
    """A Sql pool vulnerability assessment rule baseline.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param baseline_results: Required. The rule baseline result
    :type baseline_results:
     list[~azure.mgmt.synapse.models.SqlPoolVulnerabilityAssessmentRuleBaselineItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'baseline_results': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'baseline_results': {'key': 'properties.baselineResults', 'type': '[SqlPoolVulnerabilityAssessmentRuleBaselineItem]'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolVulnerabilityAssessmentRuleBaseline, self).__init__(**kwargs)
        self.baseline_results = kwargs.get('baseline_results', None)


class SqlPoolVulnerabilityAssessmentRuleBaselineItem(Model):
    """Properties for an Sql pool vulnerability assessment rule baseline's result.

    All required parameters must be populated in order to send to Azure.

    :param result: Required. The rule baseline result
    :type result: list[str]
    """

    _validation = {
        'result': {'required': True},
    }

    _attribute_map = {
        'result': {'key': 'result', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolVulnerabilityAssessmentRuleBaselineItem, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)


class SqlPoolVulnerabilityAssessmentScansExport(ProxyResource):
    """A Sql pool Vulnerability Assessment scan export resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar exported_report_location: Location of the exported report (e.g.
     https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
    :vartype exported_report_location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'exported_report_location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'exported_report_location': {'key': 'properties.exportedReportLocation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SqlPoolVulnerabilityAssessmentScansExport, self).__init__(**kwargs)
        self.exported_report_location = None


class TopQueries(Model):
    """A database query.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar aggregation_function: The function that is used to aggregate each
     query's metrics. Possible values include: 'min', 'max', 'avg', 'sum'
    :vartype aggregation_function: str or
     ~azure.mgmt.synapse.models.QueryAggregationFunction
    :ivar execution_type: The execution type that is used to filter the query
     instances that are returned. Possible values include: 'any', 'regular',
     'irregular', 'aborted', 'exception'
    :vartype execution_type: str or
     ~azure.mgmt.synapse.models.QueryExecutionType
    :ivar interval_type: The duration of the interval (ISO8601 duration
     format).
    :vartype interval_type: str
    :ivar number_of_top_queries: The number of requested queries.
    :vartype number_of_top_queries: float
    :ivar observation_start_time: The start time for queries that are returned
     (ISO8601 format)
    :vartype observation_start_time: datetime
    :ivar observation_end_time: The end time for queries that are returned
     (ISO8601 format)
    :vartype observation_end_time: datetime
    :ivar observed_metric: The type of metric to use for ordering the top
     metrics. Possible values include: 'cpu', 'io', 'logio', 'duration',
     'executionCount'
    :vartype observed_metric: str or
     ~azure.mgmt.synapse.models.QueryObservedMetricType
    :ivar queries: The list of queries.
    :vartype queries: list[~azure.mgmt.synapse.models.QueryStatistic]
    """

    _validation = {
        'aggregation_function': {'readonly': True},
        'execution_type': {'readonly': True},
        'interval_type': {'readonly': True},
        'number_of_top_queries': {'readonly': True},
        'observation_start_time': {'readonly': True},
        'observation_end_time': {'readonly': True},
        'observed_metric': {'readonly': True},
        'queries': {'readonly': True},
    }

    _attribute_map = {
        'aggregation_function': {'key': 'aggregationFunction', 'type': 'QueryAggregationFunction'},
        'execution_type': {'key': 'executionType', 'type': 'QueryExecutionType'},
        'interval_type': {'key': 'intervalType', 'type': 'str'},
        'number_of_top_queries': {'key': 'numberOfTopQueries', 'type': 'float'},
        'observation_start_time': {'key': 'observationStartTime', 'type': 'iso-8601'},
        'observation_end_time': {'key': 'observationEndTime', 'type': 'iso-8601'},
        'observed_metric': {'key': 'observedMetric', 'type': 'QueryObservedMetricType'},
        'queries': {'key': 'queries', 'type': '[QueryStatistic]'},
    }

    def __init__(self, **kwargs):
        super(TopQueries, self).__init__(**kwargs)
        self.aggregation_function = None
        self.execution_type = None
        self.interval_type = None
        self.number_of_top_queries = None
        self.observation_start_time = None
        self.observation_end_time = None
        self.observed_metric = None
        self.queries = None


class TopQueriesListResult(Model):
    """Represents the response to a get top queries request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of top queries.
    :type value: list[~azure.mgmt.synapse.models.TopQueries]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TopQueries]'},
    }

    def __init__(self, **kwargs):
        super(TopQueriesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class TransparentDataEncryption(ProxyResource):
    """Represents a Sql pool transparent data encryption configuration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :param status: The status of the database transparent data encryption.
     Possible values include: 'Enabled', 'Disabled'
    :type status: str or
     ~azure.mgmt.synapse.models.TransparentDataEncryptionStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'TransparentDataEncryptionStatus'},
    }

    def __init__(self, **kwargs):
        super(TransparentDataEncryption, self).__init__(**kwargs)
        self.location = None
        self.status = kwargs.get('status', None)


class VirtualNetworkProfile(Model):
    """Virtual Network Profile.

    :param compute_subnet_id: Subnet ID used for computes in workspace
    :type compute_subnet_id: str
    """

    _attribute_map = {
        'compute_subnet_id': {'key': 'computeSubnetId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VirtualNetworkProfile, self).__init__(**kwargs)
        self.compute_subnet_id = kwargs.get('compute_subnet_id', None)


class VulnerabilityAssessmentRecurringScansProperties(Model):
    """Properties of a Vulnerability Assessment recurring scans.

    :param is_enabled: Recurring scans state.
    :type is_enabled: bool
    :param email_subscription_admins: Specifies that the schedule scan
     notification will be is sent to the subscription administrators. Default
     value: True .
    :type email_subscription_admins: bool
    :param emails: Specifies an array of e-mail addresses to which the scan
     notification is sent.
    :type emails: list[str]
    """

    _attribute_map = {
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'email_subscription_admins': {'key': 'emailSubscriptionAdmins', 'type': 'bool'},
        'emails': {'key': 'emails', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(VulnerabilityAssessmentRecurringScansProperties, self).__init__(**kwargs)
        self.is_enabled = kwargs.get('is_enabled', None)
        self.email_subscription_admins = kwargs.get('email_subscription_admins', True)
        self.emails = kwargs.get('emails', None)


class VulnerabilityAssessmentScanError(Model):
    """Properties of a vulnerability assessment scan error.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VulnerabilityAssessmentScanError, self).__init__(**kwargs)
        self.code = None
        self.message = None


class VulnerabilityAssessmentScanRecord(ProxyResource):
    """A vulnerability assessment scan record.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar scan_id: The scan ID.
    :vartype scan_id: str
    :ivar trigger_type: The scan trigger type. Possible values include:
     'OnDemand', 'Recurring'
    :vartype trigger_type: str or
     ~azure.mgmt.synapse.models.VulnerabilityAssessmentScanTriggerType
    :ivar state: The scan status. Possible values include: 'Passed', 'Failed',
     'FailedToRun', 'InProgress'
    :vartype state: str or
     ~azure.mgmt.synapse.models.VulnerabilityAssessmentScanState
    :ivar start_time: The scan start time (UTC).
    :vartype start_time: datetime
    :ivar end_time: The scan end time (UTC).
    :vartype end_time: datetime
    :ivar errors: The scan errors.
    :vartype errors:
     list[~azure.mgmt.synapse.models.VulnerabilityAssessmentScanError]
    :ivar storage_container_path: The scan results storage container path.
    :vartype storage_container_path: str
    :ivar number_of_failed_security_checks: The number of failed security
     checks.
    :vartype number_of_failed_security_checks: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'scan_id': {'readonly': True},
        'trigger_type': {'readonly': True},
        'state': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'errors': {'readonly': True},
        'storage_container_path': {'readonly': True},
        'number_of_failed_security_checks': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'scan_id': {'key': 'properties.scanId', 'type': 'str'},
        'trigger_type': {'key': 'properties.triggerType', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'errors': {'key': 'properties.errors', 'type': '[VulnerabilityAssessmentScanError]'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'number_of_failed_security_checks': {'key': 'properties.numberOfFailedSecurityChecks', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(VulnerabilityAssessmentScanRecord, self).__init__(**kwargs)
        self.scan_id = None
        self.trigger_type = None
        self.state = None
        self.start_time = None
        self.end_time = None
        self.errors = None
        self.storage_container_path = None
        self.number_of_failed_security_checks = None


class Workspace(TrackedResource):
    """A workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param default_data_lake_storage: Workspace default data lake storage
     account details
    :type default_data_lake_storage:
     ~azure.mgmt.synapse.models.DataLakeStorageAccountDetails
    :param sql_administrator_login_password: SQL administrator login password
    :type sql_administrator_login_password: str
    :ivar managed_resource_group_name: Workspace managed resource group
    :vartype managed_resource_group_name: str
    :ivar provisioning_state: Resource provisioning state
    :vartype provisioning_state: str
    :param sql_administrator_login: Login for workspace SQL active directory
     administrator
    :type sql_administrator_login: str
    :param virtual_network_profile: Virtual Network profile
    :type virtual_network_profile:
     ~azure.mgmt.synapse.models.VirtualNetworkProfile
    :param connectivity_endpoints: Connectivity endpoints
    :type connectivity_endpoints: dict[str, str]
    :param identity: Identity of the workspace
    :type identity: ~azure.mgmt.synapse.models.ManagedIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'managed_resource_group_name': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'default_data_lake_storage': {'key': 'properties.defaultDataLakeStorage', 'type': 'DataLakeStorageAccountDetails'},
        'sql_administrator_login_password': {'key': 'properties.sqlAdministratorLoginPassword', 'type': 'str'},
        'managed_resource_group_name': {'key': 'properties.managedResourceGroupName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sql_administrator_login': {'key': 'properties.sqlAdministratorLogin', 'type': 'str'},
        'virtual_network_profile': {'key': 'properties.virtualNetworkProfile', 'type': 'VirtualNetworkProfile'},
        'connectivity_endpoints': {'key': 'properties.connectivityEndpoints', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
    }

    def __init__(self, **kwargs):
        super(Workspace, self).__init__(**kwargs)
        self.default_data_lake_storage = kwargs.get('default_data_lake_storage', None)
        self.sql_administrator_login_password = kwargs.get('sql_administrator_login_password', None)
        self.managed_resource_group_name = None
        self.provisioning_state = None
        self.sql_administrator_login = kwargs.get('sql_administrator_login', None)
        self.virtual_network_profile = kwargs.get('virtual_network_profile', None)
        self.connectivity_endpoints = kwargs.get('connectivity_endpoints', None)
        self.identity = kwargs.get('identity', None)


class WorkspaceAadAdminInfo(ProxyResource):
    """Workspace active directory administrator.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tenant_id: Tenant ID of the workspace active directory
     administrator
    :type tenant_id: str
    :param login: Login of the workspace active directory administrator
    :type login: str
    :param administrator_type: Workspace active directory administrator type
    :type administrator_type: str
    :param sid: Object ID of the workspace active directory administrator
    :type sid: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'login': {'key': 'properties.login', 'type': 'str'},
        'administrator_type': {'key': 'properties.administratorType', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WorkspaceAadAdminInfo, self).__init__(**kwargs)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.login = kwargs.get('login', None)
        self.administrator_type = kwargs.get('administrator_type', None)
        self.sid = kwargs.get('sid', None)


class WorkspacePatchInfo(Model):
    """Workspace patch details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param identity: The identity of the workspace
    :type identity: ~azure.mgmt.synapse.models.ManagedIdentity
    :param sql_administrator_login_password: SQL administrator login password
    :type sql_administrator_login_password: str
    :ivar provisioning_state: Resource provisioning state
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedIdentity'},
        'sql_administrator_login_password': {'key': 'properties.sqlAdministratorLoginPassword', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(WorkspacePatchInfo, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.identity = kwargs.get('identity', None)
        self.sql_administrator_login_password = kwargs.get('sql_administrator_login_password', None)
        self.provisioning_state = None
