/*
 * Decompiled with CFR 0.152.
 */
package com.virtlink.commons.configuration2.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.virtlink.commons.configuration2.jackson.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileLocator;
import org.apache.commons.configuration2.io.FileLocatorAware;
import org.apache.commons.configuration2.io.InputStreamSupport;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeKeyResolver;

public abstract class JacksonConfiguration
extends BaseHierarchicalConfiguration
implements FileBasedConfiguration,
InputStreamSupport,
FileLocatorAware {
    private static final TypeReference<HashMap<String, Object>> HASH_MAP_TYPE_REFERENCE = new TypeReference<HashMap<String, Object>>(){};
    private final SimpleModule module;
    private final ObjectMapper mapper;
    @Nullable
    protected FileLocator locator = null;

    protected JacksonConfiguration(JsonFactory factory) {
        this(factory, null);
    }

    protected JacksonConfiguration(JsonFactory factory, HierarchicalConfiguration<ImmutableNode> config) {
        super(config);
        Preconditions.checkNotNull(factory);
        this.module = new SimpleModule();
        this.mapper = new ObjectMapper(factory);
        this.mapper.registerModule((Module)this.module);
    }

    public void read(InputStream inputStream) throws ConfigurationException, IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            this.read(reader);
        }
    }

    public void read(Reader reader) throws ConfigurationException, IOException {
        Preconditions.checkNotNull(reader);
        HashMap settings = (HashMap)this.mapper.readValue(reader, HASH_MAP_TYPE_REFERENCE);
        ImmutableNode rootNode = this.toNode(new ImmutableNode.Builder(), settings);
        this.getSubConfigurationParentModel().mergeRoot(rootNode, null, null, null, (NodeKeyResolver)this);
    }

    public void write(Writer writer) throws ConfigurationException, IOException {
        Preconditions.checkNotNull(writer);
        HashMap settings = (HashMap)this.fromNode(this.getModel().getInMemoryRepresentation());
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(writer, (Object)settings);
    }

    public void initFileLocator(@Nullable FileLocator locator) {
        this.locator = locator;
    }

    private ImmutableNode toNode(ImmutableNode.Builder builder, Object obj) {
        assert (!(obj instanceof List));
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return this.mapToNode(builder, map);
        }
        return this.valueToNode(builder, obj);
    }

    private ImmutableNode mapToNode(ImmutableNode.Builder builder, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                for (Object item : (List)value) {
                    this.addChildNode(builder, key, item);
                }
                continue;
            }
            this.addChildNode(builder, key, value);
        }
        return builder.create();
    }

    private void addChildNode(ImmutableNode.Builder builder, String name, Object value) {
        assert (!(value instanceof List));
        ImmutableNode.Builder childBuilder = new ImmutableNode.Builder();
        childBuilder.name(name);
        ImmutableNode childNode = this.toNode(childBuilder, value);
        builder.addChild(childNode);
    }

    private ImmutableNode valueToNode(ImmutableNode.Builder builder, Object value) {
        return builder.value(value).create();
    }

    private Object fromNode(ImmutableNode node) {
        if (!node.getChildren().isEmpty()) {
            Map<String, List<ImmutableNode>> children = this.getChildrenWithName(node);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map.Entry<String, List<ImmutableNode>> entry : children.entrySet()) {
                assert (!entry.getValue().isEmpty());
                if (entry.getValue().size() == 1) {
                    ImmutableNode child = entry.getValue().get(0);
                    Object childValue = this.fromNode(child);
                    map.put(entry.getKey(), childValue);
                    continue;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                for (ImmutableNode child : entry.getValue()) {
                    Object childValue = this.fromNode(child);
                    list.add(childValue);
                }
                map.put(entry.getKey(), list);
            }
            return map;
        }
        return node.getValue();
    }

    private Map<String, List<ImmutableNode>> getChildrenWithName(ImmutableNode node) {
        HashMap<String, List<ImmutableNode>> children = new HashMap<String, List<ImmutableNode>>();
        for (ImmutableNode child : node.getChildren()) {
            String name = child.getNodeName();
            if (!children.containsKey(name)) {
                children.put(name, new ArrayList());
            }
            ((List)children.get(name)).add(child);
        }
        return children;
    }
}

