/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pgx.config.internal.EdgeCombinationMethodDeserializer;
import oracle.pgx.config.internal.GraphWiseBaseConvLayerConfigDeserializer;
import oracle.pgx.config.internal.categorymapping.CategoryMappingConfig;
import oracle.pgx.config.mllib.EdgeWiseModelConfig;
import oracle.pgx.config.mllib.GraphWiseBaseConvLayerConfig;
import oracle.pgx.config.mllib.GraphWiseBaseModelConfig;
import oracle.pgx.config.mllib.GraphWiseDgiLayerConfig;
import oracle.pgx.config.mllib.edgecombination.EdgeCombinationMethod;
import oracle.pgx.config.mllib.inputconfig.InputPropertyConfig;

public class UnsupervisedEdgeWiseModelConfig
extends EdgeWiseModelConfig {
    public static final LossFunction DEFAULT_LOSS_FUNCTION = LossFunction.SIGMOID_CROSS_ENTROPY;
    public static final GraphWiseDgiLayerConfig DEFAULT_DGI_LAYER_CONFIG = new GraphWiseDgiLayerConfig();
    private LossFunction lossFunction = DEFAULT_LOSS_FUNCTION;
    private GraphWiseDgiLayerConfig dgiLayerConfig = DEFAULT_DGI_LAYER_CONFIG;

    public UnsupervisedEdgeWiseModelConfig() {
    }

    @JsonCreator
    public UnsupervisedEdgeWiseModelConfig(@JsonProperty(required=true, value="batchSize") int batchSize, @JsonProperty(required=true, value="numEpochs") int numEpochs, @JsonProperty(required=true, value="learningRate") double learningRate, @JsonProperty(required=false, value="weightDecay") double weightDecay, @JsonProperty(required=true, value="embeddingDim") int embeddingDim, @JsonProperty(required=false, value="edgeEmbeddingDim") Integer edgeEmbeddingDim, @JsonProperty(required=true, value="seed") Integer seed, @JsonDeserialize(contentUsing=GraphWiseBaseConvLayerConfigDeserializer.class) @JsonProperty(required=true, value="convLayerConfigs") GraphWiseBaseConvLayerConfig[] convLayerConfigs, @JsonProperty(required=true, value="standardize") boolean standardize, @JsonProperty(required=true, value="shuffle") boolean shuffle, @JsonProperty(required=true, value="vertexInputPropertyNames") List<String> vertexInputPropertyNames, @JsonProperty(required=false, value="edgeInputPropertyNames") List<String> edgeInputPropertyNames, @JsonProperty(required=false, value="vertexInputPropertyConfigs") Map<String, InputPropertyConfig> vertexInputPropertyConfigs, @JsonProperty(required=false, value="edgeInputPropertyConfigs") Map<String, InputPropertyConfig> edgeInputPropertyConfigs, @JsonProperty(required=false, value="categoryMappingConfig") CategoryMappingConfig categoryMappingConfig, @JsonProperty(required=false, value="targetEdgeLabelSets") List<Set<String>> targetEdgeLabelSets, @JsonProperty(required=true, value="fitted") boolean fitted, @JsonProperty(required=true, value="trainingLoss") double trainingLoss, @JsonProperty(required=true, value="inputFeatureDim") int inputFeatureDim, @JsonProperty(required=false, value="edgeInputFeatureDim") int edgeInputFeatureDim, @JsonProperty(required=false, value="lossFunction") LossFunction lossFunction, @JsonProperty(required=true, value="normalize") boolean normalize, @JsonProperty(required=true, value="backend") GraphWiseBaseModelConfig.Backend backend, @JsonDeserialize(using=EdgeCombinationMethodDeserializer.class) @JsonProperty(required=true, value="edgeCombinationMethod") EdgeCombinationMethod edgeCombinationMethod, @JsonProperty(required=false, value="variant") EdgeWiseModelConfig.EdgeWiseConvModelVariant variant, @JsonProperty(required=true, value="dgiLayerConfig") GraphWiseDgiLayerConfig dgiLayerConfig) {
        super(batchSize, numEpochs, learningRate, weightDecay, embeddingDim, seed, convLayerConfigs, standardize, normalize, shuffle, vertexInputPropertyNames, edgeInputPropertyNames, vertexInputPropertyConfigs, edgeInputPropertyConfigs, categoryMappingConfig, fitted, trainingLoss, inputFeatureDim, edgeInputFeatureDim, targetEdgeLabelSets, backend, edgeEmbeddingDim, variant, edgeCombinationMethod);
        this.lossFunction = lossFunction;
        this.dgiLayerConfig = dgiLayerConfig;
    }

    public UnsupervisedEdgeWiseModelConfig(UnsupervisedEdgeWiseModelConfig source) {
        super(source);
        this.setLossFunction(source.getLossFunction());
        this.setDgiLayerConfig(source.getDgiLayerConfig());
    }

    public UnsupervisedEdgeWiseModelConfig(UnsupervisedEdgeWiseModelConfig source, CategoryMappingConfig categoryMappingConfig) {
        this(source);
        this.categoryMappingConfig = categoryMappingConfig;
    }

    public GraphWiseDgiLayerConfig getDgiLayerConfig() {
        return this.dgiLayerConfig;
    }

    public final void setDgiLayerConfig(GraphWiseDgiLayerConfig dgiLayerConfig) {
        this.dgiLayerConfig = dgiLayerConfig;
    }

    public LossFunction getLossFunction() {
        return this.lossFunction;
    }

    public final void setLossFunction(LossFunction lossFunction) {
        this.lossFunction = lossFunction;
    }

    public static enum LossFunction {
        SIGMOID_CROSS_ENTROPY;

    }
}

