/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.mllib.loss.DevNetLoss;
import oracle.pgx.config.mllib.loss.LossFunction;
import oracle.pgx.config.mllib.loss.MSELoss;
import oracle.pgx.config.mllib.loss.SigmoidCrossEntropyLoss;
import oracle.pgx.config.mllib.loss.SoftmaxCrossEntropyLoss;

public class LossFunctionDeserializer
extends JsonDeserializer<LossFunction> {
    private static LossFunction getLossFunction(JsonNode jsonNode) throws IOException {
        JsonNode lossTypeNode = jsonNode.get("lossType");
        LossFunction.LossType lossType = ConfigJsonUtil.fromJsonNode(lossTypeNode, LossFunction.LossType.class);
        switch (lossType) {
            case SIGMOID_CROSS_ENTROPY: {
                return new SigmoidCrossEntropyLoss();
            }
            case SOFTMAX_CROSS_ENTROPY: {
                return new SoftmaxCrossEntropyLoss();
            }
            case DEVNET: {
                return ConfigJsonUtil.fromJsonNode(jsonNode, DevNetLoss.class);
            }
            case MSE: {
                return new MSELoss();
            }
        }
        throw new IllegalEnumConstantException((Enum)lossType);
    }

    public LossFunction deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
        return LossFunctionDeserializer.getLossFunction(jsonNode);
    }
}

