/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.LabelMaps;
import oracle.pgx.config.mllib.SupervisedGraphWiseModelConfig;

public class LabelMapsDeserializer
extends JsonDeserializer<LabelMaps> {
    public LabelMaps deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        LabelMaps labelMaps = new LabelMaps();
        if (!node.get("labelType").isNull()) {
            MapType mapType;
            PropertyType propertyType = ConfigJsonUtil.readValue(ConfigJsonUtil.getValues(node, "labelType"), PropertyType.class);
            if (!SupervisedGraphWiseModelConfig.SUPPORTED_LABEL_TYPES.contains(propertyType)) {
                throw new IllegalStateException(ErrorMessages.getMessage((String)"INVALID_TARGET_PROPERTY_TYPE_LOADED", (Object[])new Object[]{node.toString()}));
            }
            labelMaps.setLabelType(propertyType);
            if (!node.get("classWeights").isNull()) {
                mapType = ConfigJsonUtil.getTypeFactory().constructMapType(HashMap.class, propertyType.getTypeClass(), Float.class);
                Map classWeights = (Map)ConfigJsonUtil.readValue(ConfigJsonUtil.getValues(node, "classWeights"), (JavaType)mapType);
                labelMaps.setClassWeights(classWeights);
            }
            if (!node.get("classMap").isNull()) {
                mapType = ConfigJsonUtil.getTypeFactory().constructMapType(HashMap.class, propertyType.getTypeClass(), Integer.class);
                Map classMap = (Map)ConfigJsonUtil.readValue(ConfigJsonUtil.getValues(node, "classMap"), (JavaType)mapType);
                labelMaps.setClassMap(classMap);
            }
        }
        return labelMaps;
    }
}

