/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractRuntimeConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.EnterpriseSchedulerFlagsConfig;
import oracle.pgx.config.FrontierTypeStrategy;
import oracle.pgx.config.GraphValidationLevel;
import oracle.pgx.config.MemoryAllocationStrategy;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;
import oracle.pgx.config.RandomGeneratorStrategy;
import oracle.pgx.config.ReachabilityIndexCreationMode;
import oracle.pgx.config.SchedulerStrategy;
import oracle.pgx.config.StringPoolingStrategy;

public class RuntimeConfig
extends AbstractRuntimeConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static RuntimeConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return RuntimeConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static RuntimeConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return RuntimeConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static RuntimeConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new RuntimeConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static RuntimeConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new RuntimeConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static RuntimeConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new RuntimeConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected RuntimeConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    @Override
    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @Override
    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    public Integer getNumSpinLocks() {
        return (Integer)this.values.get(Field.NUM_SPIN_LOCKS);
    }

    public Boolean isExplicitSpinLocks() {
        return (Boolean)this.values.get(Field.EXPLICIT_SPIN_LOCKS);
    }

    @Override
    public SchedulerStrategy getScheduler() {
        return (SchedulerStrategy)this.values.get(Field.SCHEDULER);
    }

    public Integer getTaskLength() {
        return (Integer)this.values.get(Field.TASK_LENGTH);
    }

    public Integer getSmallTaskLength() {
        return (Integer)this.values.get(Field.SMALL_TASK_LENGTH);
    }

    public FrontierTypeStrategy getMsBfsFrontierTypeStrategy() {
        return (FrontierTypeStrategy)((Object)this.values.get(Field.MS_BFS_FRONTIER_TYPE_STRATEGY));
    }

    public Integer getBfsThresholdSingleThreaded() {
        return (Integer)this.values.get(Field.BFS_THRESHOLD_SINGLE_THREADED);
    }

    public Integer getBfsThresholdReadBased() {
        return (Integer)this.values.get(Field.BFS_THRESHOLD_READ_BASED);
    }

    public Integer getBfsIterateQueTaskSize() {
        return (Integer)this.values.get(Field.BFS_ITERATE_QUE_TASK_SIZE);
    }

    public Double getBfsThresholdParentReadBased() {
        return (Double)this.values.get(Field.BFS_THRESHOLD_PARENT_READ_BASED);
    }

    public Integer getDfsThresholdLarge() {
        return (Integer)this.values.get(Field.DFS_THRESHOLD_LARGE);
    }

    public Integer getCniStopRecursionDefault() {
        return (Integer)this.values.get(Field.CNI_STOP_RECURSION_DEFAULT);
    }

    public Integer getCniSmallDefault() {
        return (Integer)this.values.get(Field.CNI_SMALL_DEFAULT);
    }

    public Integer getCniDiffFactorDefault() {
        return (Integer)this.values.get(Field.CNI_DIFF_FACTOR_DEFAULT);
    }

    public Integer getLargeArrayThreshold() {
        return (Integer)this.values.get(Field.LARGE_ARRAY_THRESHOLD);
    }

    public Integer getMaxOffHeapSize() {
        return (Integer)this.values.get(Field.MAX_OFF_HEAP_SIZE);
    }

    public String getCharacterSet() {
        return (String)this.values.get(Field.CHARACTER_SET);
    }

    public Integer getParallelism() {
        return (Integer)this.values.get(Field.PARALLELISM);
    }

    public RandomGeneratorStrategy getRandomGeneratorStrategy() {
        return (RandomGeneratorStrategy)((Object)this.values.get(Field.RANDOM_GENERATOR_STRATEGY));
    }

    public Long getRandomSeed() {
        return (Long)this.values.get(Field.RANDOM_SEED);
    }

    public Integer getPatternMatchingSupernodeCacheThreshold() {
        return (Integer)this.values.get(Field.PATTERN_MATCHING_SUPERNODE_CACHE_THRESHOLD);
    }

    public ReachabilityIndexCreationMode getUseIndexForReachabilityQueries() {
        return (ReachabilityIndexCreationMode)((Object)this.values.get(Field.USE_INDEX_FOR_REACHABILITY_QUERIES));
    }

    public Integer getRevisitThreshold() {
        return (Integer)this.values.get(Field.REVISIT_THRESHOLD);
    }

    public EnterpriseSchedulerFlagsConfig getEnterpriseSchedulerFlags() {
        return (EnterpriseSchedulerFlagsConfig)this.values.get(Field.ENTERPRISE_SCHEDULER_FLAGS);
    }

    @Override
    public MemoryAllocationStrategy getMemoryAllocator() {
        return (MemoryAllocationStrategy)((Object)this.values.get(Field.MEMORY_ALLOCATOR));
    }

    public Integer getMaxDistinctStringsPerPool() {
        return (Integer)this.values.get(Field.MAX_DISTINCT_STRINGS_PER_POOL);
    }

    @Override
    public StringPoolingStrategy getStringPoolingStrategy() {
        return (StringPoolingStrategy)((Object)this.values.get(Field.STRING_POOLING_STRATEGY));
    }

    public Boolean useMemoryMapperForStoringPgb() {
        return (Boolean)this.values.get(Field.USE_MEMORY_MAPPER_FOR_STORING_PGB);
    }

    public Boolean useMemoryMapperForReadingPgb() {
        return (Boolean)this.values.get(Field.USE_MEMORY_MAPPER_FOR_READING_PGB);
    }

    public Double getPoolingFactor() {
        return (Double)this.values.get(Field.POOLING_FACTOR);
    }

    public GraphValidationLevel getGraphValidationLevel() {
        return (GraphValidationLevel)((Object)this.values.get(Field.GRAPH_VALIDATION_LEVEL));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuntimeConfig other = (RuntimeConfig)obj;
        if (!Objects.equals(this.getNumSpinLocks(), other.getNumSpinLocks())) {
            return false;
        }
        if (!Objects.equals(this.isExplicitSpinLocks(), other.isExplicitSpinLocks())) {
            return false;
        }
        if (!Objects.equals(this.getScheduler(), other.getScheduler())) {
            return false;
        }
        if (!Objects.equals(this.getTaskLength(), other.getTaskLength())) {
            return false;
        }
        if (!Objects.equals(this.getSmallTaskLength(), other.getSmallTaskLength())) {
            return false;
        }
        if (!Objects.equals((Object)this.getMsBfsFrontierTypeStrategy(), (Object)other.getMsBfsFrontierTypeStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getBfsThresholdSingleThreaded(), other.getBfsThresholdSingleThreaded())) {
            return false;
        }
        if (!Objects.equals(this.getBfsThresholdReadBased(), other.getBfsThresholdReadBased())) {
            return false;
        }
        if (!Objects.equals(this.getBfsIterateQueTaskSize(), other.getBfsIterateQueTaskSize())) {
            return false;
        }
        if (!Objects.equals(this.getBfsThresholdParentReadBased(), other.getBfsThresholdParentReadBased())) {
            return false;
        }
        if (!Objects.equals(this.getDfsThresholdLarge(), other.getDfsThresholdLarge())) {
            return false;
        }
        if (!Objects.equals(this.getCniStopRecursionDefault(), other.getCniStopRecursionDefault())) {
            return false;
        }
        if (!Objects.equals(this.getCniSmallDefault(), other.getCniSmallDefault())) {
            return false;
        }
        if (!Objects.equals(this.getCniDiffFactorDefault(), other.getCniDiffFactorDefault())) {
            return false;
        }
        if (!Objects.equals(this.getLargeArrayThreshold(), other.getLargeArrayThreshold())) {
            return false;
        }
        if (!Objects.equals(this.getMaxOffHeapSize(), other.getMaxOffHeapSize())) {
            return false;
        }
        if (!Objects.equals(this.getCharacterSet(), other.getCharacterSet())) {
            return false;
        }
        if (!Objects.equals(this.getParallelism(), other.getParallelism())) {
            return false;
        }
        if (!Objects.equals((Object)this.getRandomGeneratorStrategy(), (Object)other.getRandomGeneratorStrategy())) {
            return false;
        }
        if (!Objects.equals(this.getRandomSeed(), other.getRandomSeed())) {
            return false;
        }
        if (!Objects.equals(this.getPatternMatchingSupernodeCacheThreshold(), other.getPatternMatchingSupernodeCacheThreshold())) {
            return false;
        }
        if (!Objects.equals((Object)this.getUseIndexForReachabilityQueries(), (Object)other.getUseIndexForReachabilityQueries())) {
            return false;
        }
        if (!Objects.equals(this.getRevisitThreshold(), other.getRevisitThreshold())) {
            return false;
        }
        if (!Objects.equals(this.getEnterpriseSchedulerFlags(), other.getEnterpriseSchedulerFlags())) {
            return false;
        }
        if (!Objects.equals((Object)this.getMemoryAllocator(), (Object)other.getMemoryAllocator())) {
            return false;
        }
        if (!Objects.equals(this.getMaxDistinctStringsPerPool(), other.getMaxDistinctStringsPerPool())) {
            return false;
        }
        if (!Objects.equals((Object)this.getStringPoolingStrategy(), (Object)other.getStringPoolingStrategy())) {
            return false;
        }
        if (!Objects.equals(this.useMemoryMapperForStoringPgb(), other.useMemoryMapperForStoringPgb())) {
            return false;
        }
        if (!Objects.equals(this.useMemoryMapperForReadingPgb(), other.useMemoryMapperForReadingPgb())) {
            return false;
        }
        if (!Objects.equals(this.getPoolingFactor(), other.getPoolingFactor())) {
            return false;
        }
        return Objects.equals((Object)this.getGraphValidationLevel(), (Object)other.getGraphValidationLevel());
    }

    public static enum Field implements ConfigField
    {
        NUM_SPIN_LOCKS(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1024, false, false, false, false),
        EXPLICIT_SPIN_LOCKS(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        SCHEDULER(Collections.emptyList(), Collections.emptyList(), SchedulerStrategy.class, false, SchedulerStrategy.ENTERPRISE_SCHEDULER, false, false, false, false),
        TASK_LENGTH(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 4096, false, false, false, false),
        SMALL_TASK_LENGTH(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 128, false, false, false, false),
        MS_BFS_FRONTIER_TYPE_STRATEGY(Collections.emptyList(), Collections.emptyList(), FrontierTypeStrategy.class, false, (Object)((Object)FrontierTypeStrategy.AUTO_GROW), false, false, false, false),
        BFS_THRESHOLD_SINGLE_THREADED(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 128, false, false, false, false),
        BFS_THRESHOLD_READ_BASED(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1024, false, false, false, false),
        BFS_ITERATE_QUE_TASK_SIZE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 128, false, false, false, false),
        BFS_THRESHOLD_PARENT_READ_BASED(Collections.emptyList(), Collections.emptyList(), Double.class, false, 0.05, false, false, false, false),
        DFS_THRESHOLD_LARGE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 4096, false, false, false, false),
        CNI_STOP_RECURSION_DEFAULT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 96, false, false, false, false),
        CNI_SMALL_DEFAULT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 128, false, false, false, false),
        CNI_DIFF_FACTOR_DEFAULT(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 8, false, false, false, false),
        LARGE_ARRAY_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 0x7FFFFFFC, false, false, false, false),
        MAX_OFF_HEAP_SIZE(Collections.emptyList(), Collections.emptyList(), Integer.class, false, "<available-physical-memory>", false, false, false, false),
        CHARACTER_SET(Collections.emptyList(), Collections.emptyList(), String.class, false, "UTF-8", false, false, false, false),
        PARALLELISM(Collections.emptyList(), Collections.emptyList(), Integer.class, false, "<no-of-CPUs>", false, false, false, false),
        RANDOM_GENERATOR_STRATEGY(Collections.emptyList(), Collections.emptyList(), RandomGeneratorStrategy.class, false, (Object)((Object)RandomGeneratorStrategy.NON_DETERMINISTIC), false, false, false, false),
        RANDOM_SEED(Collections.emptyList(), Collections.emptyList(), Long.class, false, -24466691093057031L, false, false, false, false),
        PATTERN_MATCHING_SUPERNODE_CACHE_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 1000, false, false, false, false),
        USE_INDEX_FOR_REACHABILITY_QUERIES(Collections.emptyList(), Collections.emptyList(), ReachabilityIndexCreationMode.class, false, (Object)((Object)ReachabilityIndexCreationMode.AUTO), false, false, false, false),
        REVISIT_THRESHOLD(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 4096, false, false, false, false),
        ENTERPRISE_SCHEDULER_FLAGS(Collections.emptyList(), Collections.emptyList(), EnterpriseSchedulerFlagsConfig.class, false, Collections.emptyMap(), false, false, false, false),
        MEMORY_ALLOCATOR(Collections.emptyList(), Collections.emptyList(), MemoryAllocationStrategy.class, false, (Object)((Object)MemoryAllocationStrategy.BASIC_ALLOCATOR), false, false, false, false),
        MAX_DISTINCT_STRINGS_PER_POOL(Collections.emptyList(), Collections.emptyList(), Integer.class, false, 65536, false, false, false, false),
        STRING_POOLING_STRATEGY(Collections.emptyList(), Collections.emptyList(), StringPoolingStrategy.class, false, (Object)((Object)StringPoolingStrategy.ON_HEAP), false, false, false, false),
        USE_MEMORY_MAPPER_FOR_STORING_PGB(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        USE_MEMORY_MAPPER_FOR_READING_PGB(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        POOLING_FACTOR(Collections.emptyList(), Collections.emptyList(), Double.class, false, 0.25, false, false, false, false),
        GRAPH_VALIDATION_LEVEL(Collections.emptyList(), Collections.emptyList(), GraphValidationLevel.class, false, (Object)((Object)GraphValidationLevel.LOW), false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("runtime.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

