/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.pgx.config.AbstractEntityProviderConfigBuilder;
import oracle.pgx.config.AbstractGraphConfigBuilder;
import oracle.pgx.config.AbstractGraphConfigFactory;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfig;
import oracle.pgx.config.FileGraphConfig;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.PartitionedGraphConfigFactory;
import oracle.pgx.config.PreparedQueryConfig;
import oracle.pgx.config.SourceType;
import oracle.pgx.config.internal.ConvertibleToEntityProviderConfigBuilder;

public final class PartitionedGraphConfigBuilder
extends AbstractGraphConfigBuilder<PartitionedGraphConfigBuilder, PartitionedGraphConfig> {
    private final List<Map<String, Object>> vertexTables = new LinkedList<Map<String, Object>>();
    private final List<Map<String, Object>> edgeTables = new LinkedList<Map<String, Object>>();

    public PartitionedGraphConfigBuilder() {
        this.values.put(PartitionedGraphConfig.Field.VERTEX_PROVIDERS.toKey(), this.vertexTables);
        this.values.put(PartitionedGraphConfig.Field.EDGE_PROVIDERS.toKey(), this.edgeTables);
        this.values.remove(FileGraphConfig.Field.VERTEX_PROPS.toKey());
        this.values.remove(FileGraphConfig.Field.EDGE_PROPS.toKey());
        this.values.remove(FileGraphConfig.Field.FORMAT.toKey());
    }

    @Override
    protected AbstractGraphConfigFactory<PartitionedGraphConfig> getFactory() {
        return new PartitionedGraphConfigFactory(true, true);
    }

    @Override
    public PartitionedGraphConfigBuilder copyFrom(PartitionedGraphConfig graphConfig) {
        super.copyFrom(graphConfig);
        this.values.remove(FileGraphConfig.Field.VERTEX_PROPS.toKey());
        this.values.remove(FileGraphConfig.Field.EDGE_PROPS.toKey());
        this.values.remove(FileGraphConfig.Field.FORMAT.toKey());
        this.setName(graphConfig.getName());
        this.setPgViewName(graphConfig.getPgViewName());
        this.setQueries(graphConfig.getQueries());
        this.setSourceName(graphConfig.getSourceName());
        this.setSourceType(graphConfig.getSourceType());
        this.setVertexProviders(graphConfig.getVertexProviders());
        this.setEdgeProviders(graphConfig.getEdgeProviders());
        this.setJdbcUrl(graphConfig.getJdbcUrl());
        this.setUsername(graphConfig.getUsername());
        this.setPassword((String)graphConfig.getValues().get(PartitionedGraphConfig.Field.PASSWORD));
        this.setMaxPrefetchedRows(graphConfig.getMaxPrefetchedRows());
        this.setNumConnections(graphConfig.getNumConnections());
        this.setDataSourceId(graphConfig.getDataSourceId());
        this.setSchema(graphConfig.getSchema());
        this.setArrayCompactionThreshold(graphConfig.getArrayCompactionThreshold());
        this.setEsUrl(graphConfig.getEsUrl());
        this.setEsIndexName(graphConfig.getEsIndexName());
        this.setProxyUrl(graphConfig.getProxyUrl());
        this.setScrollTime(graphConfig.getScrollTime());
        this.setMaxBatchSize(graphConfig.getMaxBatchSize());
        return this;
    }

    public PartitionedGraphConfigBuilder setEsUrl(String esUrl) {
        this.values.put(PartitionedGraphConfig.Field.ES_URL.toKey(), esUrl);
        return this;
    }

    public PartitionedGraphConfigBuilder setEsIndexName(String esIndexName) {
        this.values.put(PartitionedGraphConfig.Field.ES_INDEX_NAME.toKey(), esIndexName);
        return this;
    }

    public PartitionedGraphConfigBuilder setProxyUrl(String proxyUrl) {
        this.values.put(PartitionedGraphConfig.Field.PROXY_URL.toKey(), proxyUrl);
        return this;
    }

    public PartitionedGraphConfigBuilder setScrollTime(String scrollTime) {
        this.values.put(PartitionedGraphConfig.Field.SCROLL_TIME.toKey(), scrollTime);
        return this;
    }

    public PartitionedGraphConfigBuilder setMaxBatchSize(int maxBatchSize) {
        this.values.put(PartitionedGraphConfig.Field.MAX_BATCH_SIZE.toKey(), maxBatchSize);
        return this;
    }

    public PartitionedGraphConfigBuilder setJdbcUrl(String jdbcUrl) {
        this.values.put(PartitionedGraphConfig.Field.JDBC_URL.toKey(), jdbcUrl);
        return this;
    }

    public PartitionedGraphConfigBuilder setUsername(String username) {
        this.values.put(PartitionedGraphConfig.Field.USERNAME.toKey(), username);
        return this;
    }

    public PartitionedGraphConfigBuilder setMaxPrefetchedRows(int maxPrefetchedRows) {
        this.values.put(PartitionedGraphConfig.Field.MAX_PREFETCHED_ROWS.toKey(), maxPrefetchedRows);
        return this;
    }

    public PartitionedGraphConfigBuilder setNumConnections(int numConnections) {
        this.values.put(PartitionedGraphConfig.Field.NUM_CONNECTIONS.toKey(), numConnections);
        return this;
    }

    public PartitionedGraphConfigBuilder setDataSourceId(String dataSourceId) {
        this.values.put(PartitionedGraphConfig.Field.DATA_SOURCE_ID.toKey(), dataSourceId);
        return this;
    }

    public PartitionedGraphConfigBuilder setSchema(String schema) {
        this.values.put(PartitionedGraphConfig.Field.SCHEMA.toKey(), schema);
        return this;
    }

    public PartitionedGraphConfigBuilder addVertexProvider(AbstractEntityProviderConfigBuilder providerBuilder) {
        this.vertexTables.add(providerBuilder.values);
        return this;
    }

    public PartitionedGraphConfigBuilder addVertexProvider(EntityProviderConfig provider) {
        return this.addVertexProvider(provider.toEntityProviderConfigBuilder());
    }

    public PartitionedGraphConfigBuilder setVertexProviders(Iterable<? extends ConvertibleToEntityProviderConfigBuilder> providers) {
        this.vertexTables.clear();
        for (ConvertibleToEntityProviderConfigBuilder convertibleToEntityProviderConfigBuilder : providers) {
            this.addVertexProvider(convertibleToEntityProviderConfigBuilder.toEntityProviderConfigBuilder());
        }
        return this;
    }

    public PartitionedGraphConfigBuilder setVertexProviders(ConvertibleToEntityProviderConfigBuilder ... providers) {
        this.vertexTables.clear();
        for (ConvertibleToEntityProviderConfigBuilder provider : providers) {
            this.addVertexProvider(provider.toEntityProviderConfigBuilder());
        }
        return this;
    }

    public PartitionedGraphConfigBuilder removeVertexProvider(String name) {
        this.vertexTables.removeIf(provider -> provider.get(FileEntityProviderConfig.Field.NAME.toKey()).equals(name));
        return (PartitionedGraphConfigBuilder)this.getThis();
    }

    public PartitionedGraphConfigBuilder clearVertexProviders() {
        this.vertexTables.clear();
        return this;
    }

    public PartitionedGraphConfigBuilder addEdgeProvider(AbstractEntityProviderConfigBuilder providerBuilder) {
        this.edgeTables.add(providerBuilder.values);
        return this;
    }

    public PartitionedGraphConfigBuilder addEdgeProvider(EntityProviderConfig provider) {
        return this.addEdgeProvider(provider.toEntityProviderConfigBuilder());
    }

    public PartitionedGraphConfigBuilder setEdgeProviders(Iterable<? extends ConvertibleToEntityProviderConfigBuilder> providers) {
        this.edgeTables.clear();
        for (ConvertibleToEntityProviderConfigBuilder convertibleToEntityProviderConfigBuilder : providers) {
            this.addEdgeProvider(convertibleToEntityProviderConfigBuilder.toEntityProviderConfigBuilder());
        }
        return this;
    }

    public PartitionedGraphConfigBuilder setEdgeProviders(ConvertibleToEntityProviderConfigBuilder ... providers) {
        this.edgeTables.clear();
        for (ConvertibleToEntityProviderConfigBuilder provider : providers) {
            this.addEdgeProvider(provider.toEntityProviderConfigBuilder());
        }
        return this;
    }

    public PartitionedGraphConfigBuilder removeEdgeProvider(String name) {
        this.edgeTables.removeIf(provider -> provider.get(FileEntityProviderConfig.Field.NAME.toKey()).equals(name));
        return (PartitionedGraphConfigBuilder)this.getThis();
    }

    public PartitionedGraphConfigBuilder clearEdgeProviders() {
        this.edgeTables.clear();
        return this;
    }

    public PartitionedGraphConfigBuilder setName(String name) {
        this.values.put(PartitionedGraphConfig.Field.NAME.toKey(), name);
        return this;
    }

    @Deprecated
    public PartitionedGraphConfigBuilder setPgViewName(String name) {
        this.values.put(PartitionedGraphConfig.Field.PG_VIEW_NAME.toKey(), name);
        return this;
    }

    public PartitionedGraphConfigBuilder setQueries(List<String> queries) {
        this.values.put(PartitionedGraphConfig.Field.QUERIES.toKey(), queries != null ? new ArrayList<String>(queries) : null);
        return this;
    }

    public PartitionedGraphConfigBuilder setPreparedQueries(List<PreparedQueryConfig> preparedQueries) {
        this.values.put(PartitionedGraphConfig.Field.PREPARED_QUERIES.toKey(), preparedQueries != null ? new ArrayList<PreparedQueryConfig>(preparedQueries) : null);
        return this;
    }

    @Override
    public PartitionedGraphConfigBuilder setArrayCompactionThreshold(Double arrayCompactionThreshold) {
        this.values.put(PartitionedGraphConfig.Field.ARRAY_COMPACTION_THRESHOLD.toKey(), arrayCompactionThreshold);
        return this;
    }

    public PartitionedGraphConfigBuilder setSourceType(SourceType sourceType) {
        this.values.put(PartitionedGraphConfig.Field.SOURCE_TYPE.toKey(), sourceType);
        return this;
    }

    public PartitionedGraphConfigBuilder setSourceName(String sourceName) {
        this.values.put(PartitionedGraphConfig.Field.SOURCE_NAME.toKey(), sourceName);
        return this;
    }
}

