/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.AbstractDataMemoryLimitsConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;

public class DataMemoryLimitsConfig
extends AbstractDataMemoryLimitsConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static DataMemoryLimitsConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return DataMemoryLimitsConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static DataMemoryLimitsConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return DataMemoryLimitsConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static DataMemoryLimitsConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new DataMemoryLimitsConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static DataMemoryLimitsConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new DataMemoryLimitsConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static DataMemoryLimitsConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new DataMemoryLimitsConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected DataMemoryLimitsConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    @Override
    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    @Override
    public String getMaxTotalDataMemorySize() {
        return (String)this.values.get(Field.MAX_TOTAL_DATA_MEMORY_SIZE);
    }

    @Override
    public Double getMaxTotalDataMemoryRatio() {
        return (Double)this.values.get(Field.MAX_TOTAL_DATA_MEMORY_RATIO);
    }

    @Override
    public String getMaxTotalPrivateDataMemorySize() {
        return (String)this.values.get(Field.MAX_TOTAL_PRIVATE_DATA_MEMORY_SIZE);
    }

    @Override
    public Double getMaxTotalPrivateDataMemoryRatio() {
        return (Double)this.values.get(Field.MAX_TOTAL_PRIVATE_DATA_MEMORY_RATIO);
    }

    @Override
    public String getMaxTotalSharedDataMemorySize() {
        return (String)this.values.get(Field.MAX_TOTAL_SHARED_DATA_MEMORY_SIZE);
    }

    @Override
    public Double getMaxTotalSharedDataMemoryRatio() {
        return (Double)this.values.get(Field.MAX_TOTAL_SHARED_DATA_MEMORY_RATIO);
    }

    @Override
    public String getMaxPerUserDataMemorySize() {
        return (String)this.values.get(Field.MAX_PER_USER_DATA_MEMORY_SIZE);
    }

    @Override
    public Double getMaxPerUserDataMemoryRatio() {
        return (Double)this.values.get(Field.MAX_PER_USER_DATA_MEMORY_RATIO);
    }

    @Override
    public String getMaxPerSessionDataMemorySize() {
        return (String)this.values.get(Field.MAX_PER_SESSION_DATA_MEMORY_SIZE);
    }

    @Override
    public Double getMaxPerSessionDataMemoryRatio() {
        return (Double)this.values.get(Field.MAX_PER_SESSION_DATA_MEMORY_RATIO);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataMemoryLimitsConfig other = (DataMemoryLimitsConfig)obj;
        if (!Objects.equals(this.getMaxTotalDataMemorySize(), other.getMaxTotalDataMemorySize())) {
            return false;
        }
        if (!Objects.equals(this.getMaxTotalDataMemoryRatio(), other.getMaxTotalDataMemoryRatio())) {
            return false;
        }
        if (!Objects.equals(this.getMaxTotalPrivateDataMemorySize(), other.getMaxTotalPrivateDataMemorySize())) {
            return false;
        }
        if (!Objects.equals(this.getMaxTotalPrivateDataMemoryRatio(), other.getMaxTotalPrivateDataMemoryRatio())) {
            return false;
        }
        if (!Objects.equals(this.getMaxTotalSharedDataMemorySize(), other.getMaxTotalSharedDataMemorySize())) {
            return false;
        }
        if (!Objects.equals(this.getMaxTotalSharedDataMemoryRatio(), other.getMaxTotalSharedDataMemoryRatio())) {
            return false;
        }
        if (!Objects.equals(this.getMaxPerUserDataMemorySize(), other.getMaxPerUserDataMemorySize())) {
            return false;
        }
        if (!Objects.equals(this.getMaxPerUserDataMemoryRatio(), other.getMaxPerUserDataMemoryRatio())) {
            return false;
        }
        if (!Objects.equals(this.getMaxPerSessionDataMemorySize(), other.getMaxPerSessionDataMemorySize())) {
            return false;
        }
        return Objects.equals(this.getMaxPerSessionDataMemoryRatio(), other.getMaxPerSessionDataMemoryRatio());
    }

    public static enum Field implements ConfigField
    {
        MAX_TOTAL_DATA_MEMORY_SIZE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        MAX_TOTAL_DATA_MEMORY_RATIO(Collections.emptyList(), Collections.emptyList(), Double.class, false, 0.9, false, false, false, false),
        MAX_TOTAL_PRIVATE_DATA_MEMORY_SIZE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        MAX_TOTAL_PRIVATE_DATA_MEMORY_RATIO(Collections.emptyList(), Collections.emptyList(), Double.class, false, 1.0, false, false, false, false),
        MAX_TOTAL_SHARED_DATA_MEMORY_SIZE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        MAX_TOTAL_SHARED_DATA_MEMORY_RATIO(Collections.emptyList(), Collections.emptyList(), Double.class, false, 1.0, false, false, false, false),
        MAX_PER_USER_DATA_MEMORY_SIZE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        MAX_PER_USER_DATA_MEMORY_RATIO(Collections.emptyList(), Collections.emptyList(), Double.class, false, 1.0, false, false, false, false),
        MAX_PER_SESSION_DATA_MEMORY_SIZE(Collections.emptyList(), Collections.emptyList(), String.class, false, null, false, false, false, false),
        MAX_PER_SESSION_DATA_MEMORY_RATIO(Collections.emptyList(), Collections.emptyList(), Double.class, false, 1.0, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("data.memory.limits.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

