/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.Objects;
import oracle.pgx.common.util.Constants;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractPgGraphConfig;
import oracle.pgx.config.DbConnectionConfig;
import oracle.pgx.config.GraphLoadingConfig;
import oracle.pgx.config.PgRdbmsGraphConfig;
import oracle.pgx.config.PgRdbmsGraphConfigBuilder;

abstract class AbstractPgRdbmsGraphConfig
extends AbstractPgGraphConfig
implements DbConnectionConfig {
    AbstractPgRdbmsGraphConfig() {
    }

    @Override
    public PgRdbmsGraphConfigBuilder toGraphConfigBuilder() {
        return new PgRdbmsGraphConfigBuilder().copyFrom((PgRdbmsGraphConfig)this);
    }

    private String getPassword() {
        Object pwd = ((PgRdbmsGraphConfig)this).getValues().get(PgRdbmsGraphConfig.Field.PASSWORD);
        return (String)pwd;
    }

    @Override
    public final String getSchema() {
        return this.getOwner();
    }

    @Override
    protected void validate() {
        super.validate();
        this.validateJdbcUrl();
        this.validateSecurityPolicy();
        this.validateViewNames();
        this.validateAutoRefreshWithCredentials();
    }

    private void validateJdbcUrl() {
        if (this.getJdbcUrl() == null) {
            return;
        }
        if (this.getDataSourceId() != null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"DATA_SOURCE_ID_CANNOT_BE_COMBINED_WITH_JDBC", (Object[])new Object[0]));
        }
        if (this.getPassword() == null && this.getKeystoreAlias() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"KEYSTORE_OR_PWD_REQUIRED", (Object[])new Object[0]));
        }
        if (!this.getJdbcUrl().toLowerCase().startsWith("jdbc:oracle:thin:")) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_JDBC_URI", (Object[])new Object[]{this.getJdbcUrl()}));
        }
    }

    private void validateSecurityPolicy() {
        if (this.getLabel() != null && this.getSecurityPolicy() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"LABEL_BUT_NO_POLICY", (Object[])new Object[0]));
        }
        if (this.getRowLabel() != null && this.getSecurityPolicy() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"ROW_LABEL_BUT_NO_POLICY", (Object[])new Object[0]));
        }
        if (this.getSecurityPolicy() != null && this.getRowLabel() == null && this.getLabel() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"SECURITY_POLICY_BUT_NO_LABEL", (Object[])new Object[0]));
        }
    }

    private void validateViewNames() {
        if (this.getVerticesViewName() == null && this.getEdgesViewName() != null || this.getVerticesViewName() != null && this.getEdgesViewName() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"BOTH_VIEW_SHOULD_BE_SPECIFIED", (Object[])new Object[0]));
        }
        if (this.getVerticesViewName() != null && !this.isValidVertexViewName()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_NAME_OF_VERTEX_VIEW", (Object[])new Object[0]));
        }
        if (this.getEdgesViewName() != null && !this.isValidEdgeViewName()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_NAME_OF_EDGE_VIEW", (Object[])new Object[0]));
        }
    }

    private void validateAutoRefreshWithCredentials() {
        if (this.getLoadingOptions().isAutoRefresh().booleanValue() && this.getJdbcUrl() == null && this.getDataSourceId() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CANNOT_AUTO_REFRESH_WITHOUT_DB_CREDENTIALS", (Object[])new Object[0]));
        }
    }

    abstract String getVerticesViewName();

    abstract String getEdgesViewName();

    @Override
    protected void validateAutoRefreshParameters(GraphLoadingConfig loadingConfig) {
        if (loadingConfig.getFetchIntervalSec() < 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NEGATIVE_INTERVAL", (Object[])new Object[]{GraphLoadingConfig.Field.FETCH_INTERVAL_SEC.toKey()}));
        }
        if (loadingConfig.getUpdateIntervalSec() < -1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NEGATIVE_INTERVAL", (Object[])new Object[]{GraphLoadingConfig.Field.UPDATE_INTERVAL_SEC.toKey()}));
        }
        if (loadingConfig.getUpdateIntervalSec() == -1 && loadingConfig.getUpdateThreshold() == -1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"AT_LEAST_ONE_NEEDS_TO_BE_SET", (Object[])new Object[]{GraphLoadingConfig.Field.UPDATE_INTERVAL_SEC, GraphLoadingConfig.Field.UPDATE_THRESHOLD}));
        }
        if (loadingConfig.getUpdateIntervalSec() != -1 && loadingConfig.getUpdateIntervalSec() < loadingConfig.getFetchIntervalSec()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UPDATE_INTERVAL_SMALLER_THAN_FETCH_INTERVAL", (Object[])new Object[0]));
        }
        if (!this.isLoadVertexKeys()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NODE_KEY_MAPPING_NEEDED_FOR_DELTA_UPDATE", (Object[])new Object[]{GraphLoadingConfig.Field.CREATE_VERTEX_ID_MAPPING, GraphLoadingConfig.Field.CREATE_VERTEX_ID_INDEX}));
        }
        if (!this.isLoadEdgeKeys()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EDGE_KEY_MAPPING_NEEDED_FOR_DELTA_UPDATE", (Object[])new Object[]{GraphLoadingConfig.Field.CREATE_EDGE_ID_MAPPING, GraphLoadingConfig.Field.CREATE_EDGE_ID_INDEX}));
        }
        if (loadingConfig.getFilter() != null && !loadingConfig.getFilter().isEmpty()) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"DELTA_UPDATE_INCOMPATIBLE_WITH_SUBGRAPH_LOADING", (Object[])new Object[]{GraphLoadingConfig.Field.AUTO_REFRESH, GraphLoadingConfig.Field.FILTER}));
        }
    }

    abstract String getLabel();

    abstract String getSecurityPolicy();

    abstract String getOwner();

    abstract String getRowLabel();

    boolean isValidVertexViewName() {
        return Constants.ID_SANITIZATION_REGEX_PATTERN.matcher(this.getVerticesViewName()).matches();
    }

    boolean isValidEdgeViewName() {
        return Constants.ID_SANITIZATION_REGEX_PATTERN.matcher(this.getEdgesViewName()).matches();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPgRdbmsGraphConfig that = (AbstractPgRdbmsGraphConfig)o;
        if (!super.equals(that)) {
            return false;
        }
        if (!Objects.equals(this.getDataSourceId(), that.getDataSourceId())) {
            return false;
        }
        if (!Objects.equals(this.getUsername(), that.getUsername())) {
            return false;
        }
        if (!Objects.equals(this.getKeystoreAlias(), that.getKeystoreAlias())) {
            return false;
        }
        if (!Objects.equals(this.getLabel(), that.getLabel())) {
            return false;
        }
        if (!Objects.equals(this.getSecurityPolicy(), that.getSecurityPolicy())) {
            return false;
        }
        if (!Objects.equals(this.getOwner(), that.getOwner())) {
            return false;
        }
        return Objects.equals(this.getRowLabel(), that.getRowLabel());
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        if (this.getDataSourceId() != null) {
            code += this.getDataSourceId().hashCode();
        }
        if (this.getUsername() != null) {
            code += this.getUsername().hashCode();
        }
        if (this.getKeystoreAlias() != null) {
            code += this.getKeystoreAlias().hashCode();
        }
        if (this.getLabel() != null) {
            code += this.getLabel().hashCode();
        }
        if (this.getSecurityPolicy() != null) {
            code += this.getSecurityPolicy().hashCode();
        }
        if (this.getOwner() != null) {
            code += this.getOwner().hashCode();
        }
        if (this.getRowLabel() != null) {
            code += this.getRowLabel().hashCode();
        }
        return code;
    }
}

