/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfig;
import oracle.pgx.config.GraphErrorHandlingConfig;
import oracle.pgx.config.GraphPropertyConfig;
import oracle.pgx.config.OnMismatch;
import oracle.pgx.config.OnMissingVertex;
import oracle.pgx.config.ProviderLoadingConfig;
import oracle.pgx.config.StringPoolingStrategy;
import oracle.pgx.config.internal.ConfigUtils;
import oracle.pgx.config.internal.ConvertibleToEntityProviderConfigBuilder;

public abstract class AbstractEntityProviderConfigBuilder<T extends AbstractEntityProviderConfigBuilder<T, GTC>, GTC extends EntityProviderConfig>
implements ConvertibleToEntityProviderConfigBuilder {
    protected final Map<String, Object> values;
    protected final Map<String, Object> loadingValues;
    private final List<Map<String, Object>> properties;
    private final Map<String, Object> errorHandlingValues;
    private final Map<String, String> attributes;
    private IdType sourceVertexKeyType = IdType.LONG;
    private IdType destinationVertexKeyType = IdType.LONG;

    public AbstractEntityProviderConfigBuilder() {
        this.values = new HashMap<String, Object>();
        this.properties = new LinkedList<Map<String, Object>>();
        this.loadingValues = new HashMap<String, Object>();
        this.errorHandlingValues = new HashMap<String, Object>();
        this.attributes = new HashMap<String, String>();
        this.values.put(FileEntityProviderConfig.Field.PROPS.toKey(), this.properties);
        this.values.put(FileEntityProviderConfig.Field.LOADING.toKey(), this.loadingValues);
        this.values.put(FileEntityProviderConfig.Field.ERROR_HANDLING.toKey(), this.errorHandlingValues);
        this.values.put(FileEntityProviderConfig.Field.ATTRIBUTES.toKey(), this.attributes);
    }

    protected abstract GTC parseTableConfig(InputStream var1) throws IOException;

    protected T getThis() {
        return (T)this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final GTC build() {
        this.addDefaultIdTypeIfMissing(this.values);
        this.addDefaultCreateIndexMappingIfMissing(this.values);
        try (ByteArrayInputStream is = new ByteArrayInputStream(ConfigJsonUtil.writeValueAsBytes(this.values));){
            GTC config = this.parseTableConfig(is);
            ((EntityProviderConfig)config).setSourceVertexKeyType(this.sourceVertexKeyType);
            ((EntityProviderConfig)config).setDestinationVertexKeyType(this.destinationVertexKeyType);
            GTC GTC = config;
            return GTC;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    protected abstract void addDefaultIdTypeIfMissing(Map<String, Object> var1);

    protected abstract void addDefaultCreateIndexMappingIfMissing(Map<String, Object> var1);

    protected final boolean hasValue(ConfigField field, Function<String, Object> getter) {
        return Stream.concat(Stream.of(field.toKey()), field.getKeyAliases().stream()).map(getter).filter(Objects::nonNull).findFirst().isPresent();
    }

    public T copyFrom(GTC providerConfig) {
        return this.copyBaseFrom((EntityProviderConfig)providerConfig);
    }

    public final T copyBaseFrom(EntityProviderConfig providerConfig) {
        if (!this.values.containsKey(FileEntityProviderConfig.Field.FORMAT.toKey())) {
            this.values.put(FileEntityProviderConfig.Field.FORMAT.toKey(), providerConfig.getFormat());
        }
        this.setSourceVertexProvider(providerConfig.getSourceVertexProvider());
        this.setDestinationVertexProvider(providerConfig.getDestinationVertexProvider());
        this.setSourceVertexKeyType(providerConfig.getSourceVertexKeyType());
        this.setDestinationVertexKeyType(providerConfig.getDestinationVertexKeyType());
        this.setLabel(providerConfig.getLabel());
        this.setName(providerConfig.getName());
        this.setKeyType(providerConfig.getKeyType());
        this.setHasKeys(providerConfig.hasKeys());
        this.setKeystoreAlias(providerConfig.getKeystoreAlias());
        this.setLocalDateFormat(providerConfig.getLocalDateFormat());
        this.setTimeFormat(providerConfig.getTimeFormat());
        this.setTimestampFormat(providerConfig.getTimestampFormat());
        this.setTimeWithTimezoneFormat(providerConfig.getTimeWithTimezoneFormat());
        this.setTimestampWithTimezoneFormat(providerConfig.getTimestampWithTimezoneFormat());
        providerConfig.getLoading().getValuesWithoutDefaults().forEach((key, value) -> this.loadingValues.put(key.toKey(), value));
        providerConfig.getErrorHandling().getValuesWithoutDefaults().forEach((key, value) -> this.errorHandlingValues.put(key.toKey(), value));
        providerConfig.getProps().forEach(propConfig -> this.addVectorProperty(propConfig.getName(), propConfig.getType(), propConfig.getDimension(), propConfig.getDefault(), propConfig.getColumn(), propConfig.getField(), (Object)propConfig.getAggregate(), propConfig.getGroupKey(), propConfig.isDropAfterLoading()));
        providerConfig.getAttributes().forEach((key, value) -> this.addAttribute(String.valueOf(key), String.valueOf(value)));
        return this.getThis();
    }

    public void setSourceVertexKeyType(IdType vertexIdType) {
        this.sourceVertexKeyType = vertexIdType;
    }

    public void setDestinationVertexKeyType(IdType vertexIdType) {
        this.destinationVertexKeyType = vertexIdType;
    }

    public T addVectorProperty(String name, PropertyType type, int dimension, Object defaultVal, Object column) {
        ConfigUtils.validateVectorPropertyType(type, dimension);
        HashMap<String, Object> propertyValues = new HashMap<String, Object>();
        propertyValues.put(GraphPropertyConfig.Field.NAME.toKey(), name);
        propertyValues.put(GraphPropertyConfig.Field.TYPE.toKey(), type.toString());
        propertyValues.put(GraphPropertyConfig.Field.DEFAULT.toKey(), defaultVal);
        propertyValues.put(GraphPropertyConfig.Field.DIMENSION.toKey(), dimension);
        propertyValues.put(GraphPropertyConfig.Field.COLUMN.toKey(), column);
        this.properties.add(propertyValues);
        return this.getThis();
    }

    public T addVectorProperty(String name, PropertyType type, int dimension, Object defaultVal, Object column, Object field, Object aggregate, Object groupKey, Object dropAfterLoading) {
        ConfigUtils.validateVectorPropertyType(type, dimension);
        HashMap<String, Object> propertyValues = new HashMap<String, Object>();
        propertyValues.put(GraphPropertyConfig.Field.NAME.toKey(), name);
        propertyValues.put(GraphPropertyConfig.Field.TYPE.toKey(), type.toString());
        propertyValues.put(GraphPropertyConfig.Field.DEFAULT.toKey(), defaultVal);
        propertyValues.put(GraphPropertyConfig.Field.DIMENSION.toKey(), dimension);
        propertyValues.put(GraphPropertyConfig.Field.COLUMN.toKey(), column);
        propertyValues.put(GraphPropertyConfig.Field.FIELD.toKey(), field);
        propertyValues.put(GraphPropertyConfig.Field.AGGREGATE.toKey(), aggregate);
        propertyValues.put(GraphPropertyConfig.Field.GROUP_KEY.toKey(), groupKey);
        propertyValues.put(GraphPropertyConfig.Field.DROP_AFTER_LOADING.toKey(), dropAfterLoading);
        this.properties.add(propertyValues);
        return this.getThis();
    }

    public T addStringProperty(String name, Object defaultVal, int dimension, Object column, StringPoolingStrategy stringPoolingStrategy, Integer maxDistinctStringPerPool) {
        ConfigUtils.validateVectorPropertyType(PropertyType.STRING, dimension);
        HashMap<String, Object> propertyValues = new HashMap<String, Object>();
        propertyValues.put(GraphPropertyConfig.Field.NAME.toKey(), name);
        propertyValues.put(GraphPropertyConfig.Field.TYPE.toKey(), PropertyType.STRING.toString());
        propertyValues.put(GraphPropertyConfig.Field.DEFAULT.toKey(), defaultVal);
        propertyValues.put(GraphPropertyConfig.Field.DIMENSION.toKey(), dimension);
        propertyValues.put(GraphPropertyConfig.Field.COLUMN.toKey(), column);
        propertyValues.put(GraphPropertyConfig.Field.STRING_POOLING_STRATEGY.toKey(), (Object)stringPoolingStrategy);
        propertyValues.put(GraphPropertyConfig.Field.MAX_DISTINCT_STRINGS_PER_POOL.toKey(), maxDistinctStringPerPool);
        this.properties.add(propertyValues);
        return this.getThis();
    }

    public T addVectorProperty(String name, PropertyType type, int dimension, Object defaultVal) {
        return this.addVectorProperty(name, type, dimension, defaultVal, null);
    }

    public T addVectorProperty(String name, PropertyType type, int dimension) {
        return this.addVectorProperty(name, type, dimension, null);
    }

    public T addProperty(String name, PropertyType type, Object defaultVal, Object column) {
        return this.addVectorProperty(name, type, 0, defaultVal, column);
    }

    public T addStringProperty(String name, Object defaultVal, StringPoolingStrategy stringPoolingStrategy, Integer maxDistinctStringPerPool) {
        return this.addStringProperty(name, defaultVal, 0, null, stringPoolingStrategy, maxDistinctStringPerPool);
    }

    public T addProperty(String name, PropertyType type, Object defaultVal) {
        return this.addVectorProperty(name, type, 0, defaultVal);
    }

    public T addProperty(String name, PropertyType type) {
        return this.addProperty(name, type, null);
    }

    public T removeProperty(String name) {
        this.properties.removeIf(prop -> prop.get(GraphPropertyConfig.Field.NAME.toKey()).equals(name));
        return this.getThis();
    }

    public T clearProperties() {
        this.properties.clear();
        return this.getThis();
    }

    public T setLabel(String label) {
        this.values.put(FileEntityProviderConfig.Field.LABEL.toKey(), label);
        return this.getThis();
    }

    public T setName(String name) {
        this.values.put(FileEntityProviderConfig.Field.NAME.toKey(), name);
        return this.getThis();
    }

    public T setSourceVertexProvider(String name) {
        this.values.put(FileEntityProviderConfig.Field.SOURCE_VERTEX_PROVIDER.toKey(), name);
        return this.getThis();
    }

    public T setDestinationVertexProvider(String name) {
        this.values.put(FileEntityProviderConfig.Field.DESTINATION_VERTEX_PROVIDER.toKey(), name);
        return this.getThis();
    }

    public T setKeyType(IdType keyType) {
        this.values.put(FileEntityProviderConfig.Field.KEY_TYPE.toKey(), keyType.toString());
        return this.getThis();
    }

    public T setHasKeys(boolean hasKeys) {
        this.values.put(FileEntityProviderConfig.Field.HAS_KEYS.toKey(), hasKeys);
        return this.getThis();
    }

    public T addAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this.getThis();
    }

    public T setPassword(String password) {
        this.values.put(FileEntityProviderConfig.Field.PASSWORD.toKey(), password);
        return this.getThis();
    }

    public T setKeystoreAlias(String keystoreAlias) {
        this.values.put(FileEntityProviderConfig.Field.KEYSTORE_ALIAS.toKey(), keystoreAlias);
        return this.getThis();
    }

    public T setLocalDateFormat(List<String> localDateFormatList) {
        this.values.put(FileEntityProviderConfig.Field.LOCAL_DATE_FORMAT.toKey(), localDateFormatList);
        return this.getThis();
    }

    public T setTimeFormat(List<String> timeFormatList) {
        this.values.put(FileEntityProviderConfig.Field.TIME_FORMAT.toKey(), timeFormatList);
        return this.getThis();
    }

    public T setTimestampFormat(List<String> timestampFormatList) {
        this.values.put(FileEntityProviderConfig.Field.TIMESTAMP_FORMAT.toKey(), timestampFormatList);
        return this.getThis();
    }

    public T setTimeWithTimezoneFormat(List<String> timeWithTimezoneFormatList) {
        this.values.put(FileEntityProviderConfig.Field.TIME_WITH_TIMEZONE_FORMAT.toKey(), timeWithTimezoneFormatList);
        return this.getThis();
    }

    public T setTimestampWithTimezoneFormat(List<String> timestampWithTimezoneFormatList) {
        this.values.put(FileEntityProviderConfig.Field.TIMESTAMP_WITH_TIMEZONE_FORMAT.toKey(), timestampWithTimezoneFormatList);
        return this.getThis();
    }

    public T setStrictMode(boolean strictMode) {
        this.loadingValues.put(ProviderLoadingConfig.Field.STRICT_MODE.toKey(), strictMode);
        return this.getThis();
    }

    public T createKeyMapping(boolean flag) {
        this.loadingValues.put(ProviderLoadingConfig.Field.CREATE_KEY_MAPPING.toKey(), flag);
        return this.getThis();
    }

    public T enableVertexIdDuplicateCheck(boolean checkVertexIdDuplicates) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ENABLE_VERTEX_ID_DUPLICATE_CHECK.toKey(), checkVertexIdDuplicates);
        return this.getThis();
    }

    public T enableEdgeIdDuplicateCheck(boolean checkEdgeIdDuplicates) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ENABLE_EDGE_ID_DUPLICATE_CHECK.toKey(), checkEdgeIdDuplicates);
        return this.getThis();
    }

    public T setErrorHandlingOnDuplicateEntityId(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_DUPLICATE_ENTITY_ID.toKey(), action.toKey());
        return this.getThis();
    }

    public T setErrorHandlingOnMissedPropKey(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_MISSED_PROP_KEY.toKey(), action.toKey());
        return this.getThis();
    }

    public T setErrorHandlingOnPropConversion(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_PROP_CONVERSION.toKey(), action.toKey());
        return this.getThis();
    }

    public T setErrorHandlingOnTypeMismatch(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_TYPE_MISMATCH.toKey(), action.toKey());
        return this.getThis();
    }

    public T setErrorHandlingOnMissingVertex(OnMissingVertex action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_MISSING_VERTEX.toKey(), (Object)action);
        return this.getThis();
    }

    public T setErrorHandlingOnVectorLengthMismatch(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_VECTOR_LENGTH_MISMATCH.toKey(), (Object)action);
        return this.getThis();
    }

    public T setErrorHandlingOnParsingIssue(OnMismatch action) {
        this.errorHandlingValues.put(GraphErrorHandlingConfig.Field.ON_PARSING_ISSUE.toKey(), (Object)action);
        return this.getThis();
    }

    public T redactPassword() {
        if (this.values.get(FileEntityProviderConfig.Field.PASSWORD.toKey()) != null) {
            this.setPassword("*******");
        }
        return this.getThis();
    }
}

