/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.net.ssl.SSLContext;
import oracle.jdbc.AccessToken;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.HIGH_AVAILABILITY, Feature.CONN_POOL})
public class OracleDataSource
implements oracle.jdbc.datasource.OracleDataSource,
Serializable,
Referenceable {
    static final long serialVersionUID = 3349652938965166731L;
    protected static final String DEFAULT_SERVICE_NAME = "SYS$USERS";
    protected PrintWriter logWriter = null;
    protected int loginTimeout = 0;
    protected String databaseName = null;
    protected String serviceName = null;
    protected String dataSourceName = "OracleDataSource";
    protected String description = null;
    protected String networkProtocol = "tcp";
    protected int portNumber = 0;
    protected String user = null;
    protected OpaqueString password = null;
    protected String serverName = null;
    protected String url = null;
    protected String driverType = null;
    protected String tnsEntry = null;
    protected int maxStatements = 0;
    protected boolean implicitCachingEnabled = false;
    protected boolean explicitCachingEnabled = false;
    protected boolean maxStatementsSet = false;
    protected boolean implicitCachingEnabledSet = false;
    protected boolean explicitCachingEnabledSet = false;
    protected transient OracleImplicitConnectionCache odsCache = null;
    protected transient OracleConnectionCacheManager cacheManager = null;
    protected String connCacheName = null;
    protected Properties connCacheProperties = null;
    protected Properties connectionProperties = null;
    protected boolean connCachingEnabled = false;
    protected boolean fastConnFailover = false;
    protected String onsConfigStr = null;
    public boolean isOracleDataSource = true;
    private String roleName = null;
    private static final boolean fastConnectionFailoverSysProperty = "true".equalsIgnoreCase(OracleDriver.getSystemPropertyFastConnectionFailover("false"));
    private boolean urlExplicit = false;
    private boolean useDefaultConnection = false;
    protected transient OracleDriver driver = new OracleDriver();
    private SSLContext sslContext;
    protected static final String ENABLE_AC_SUPPORT_PROPERTY = "oracle.jdbc.enableACSupport";
    private Supplier<? extends AccessToken> tokenSupplier;
    private static final String spawnNewThreadToCancelProperty = "oracle.jdbc.spawnNewThreadToCancel";
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public OracleDataSource() throws SQLException {
        this.setConnectionProperty(ENABLE_AC_SUPPORT_PROPERTY, "false");
        this.processFastConnectionFailoverSysProperty();
    }

    void processFastConnectionFailoverSysProperty() {
        if (this.isOracleDataSource && fastConnectionFailoverSysProperty) {
            this.connCachingEnabled = true;
            if (this.cacheManager == null) {
                try {
                    this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                }
                catch (SQLException sQLException) {
                }
            }
            this.fastConnFailover = true;
            this.setSpawnNewThreadToCancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        String string = null;
        OpaqueString opaqueString = null;
        Object object = this;
        synchronized (object) {
            string = this.user;
            opaqueString = this.password;
        }
        object = null;
        if (opaqueString != null) {
            object = opaqueString.get();
        }
        return this.getConnection(string, (String)object);
    }

    @Override
    public Connection getConnection(String string, @Blind String string2) throws SQLException {
        Connection connection = null;
        connection = this.connCachingEnabled ? this.getConnection(string, string2, null) : this.getConnection(this.createConnectionBuilder().user(string).password(string2));
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        Connection connection = null;
        Properties properties = null;
        OracleDataSource oracleDataSource = this;
        synchronized (oracleDataSource) {
            String string;
            if (oracleConnectionBuilderImpl.getGSSCredential() != null && (oracleConnectionBuilderImpl.getUser() != null || oracleConnectionBuilderImpl.getPassword() != null)) {
                throw (SQLException)DatabaseError.createSqlException(68, "GSSCredential and user/password cannot both be set in a connection builder.").fillInStackTrace();
            }
            this.makeURL();
            Properties properties2 = properties = this.connectionProperties == null ? new Properties() : (Properties)this.connectionProperties.clone();
            if (this.url != null) {
                properties.setProperty("connection_url", this.url);
            }
            if (oracleConnectionBuilderImpl.getUser() != null && oracleConnectionBuilderImpl.getPassword() != null) {
                properties.setProperty("user", oracleConnectionBuilderImpl.getUser());
                properties.setProperty("password", oracleConnectionBuilderImpl.getPassword());
            }
            if (this.loginTimeout != 0) {
                properties.setProperty("LoginTimeout", "" + this.loginTimeout);
            }
            if (this.maxStatementsSet) {
                properties.setProperty("stmt_cache_size", "" + this.maxStatements);
            }
            if (oracleConnectionBuilderImpl.getInstanceName() != null) {
                properties.setProperty("oracle.jdbc.targetInstanceName", oracleConnectionBuilderImpl.getInstanceName());
            }
            if (oracleConnectionBuilderImpl.getServiceName() != null && !oracleConnectionBuilderImpl.getServiceName().equalsIgnoreCase(DEFAULT_SERVICE_NAME)) {
                properties.setProperty("oracle.jdbc.targetServiceName", oracleConnectionBuilderImpl.getServiceName());
            }
            if (oracleConnectionBuilderImpl.getShardingKey() != null) {
                string = oracleConnectionBuilderImpl.getShardingKey().encodeKeyinB64Format();
                properties.setProperty("oracle.jdbc.targetShardingKey", string);
            }
            if (oracleConnectionBuilderImpl.getSuperShardingKey() != null) {
                string = oracleConnectionBuilderImpl.getSuperShardingKey().encodeKeyinB64Format();
                properties.setProperty("oracle.jdbc.targetSuperShardingKey", string);
            }
        }
        this.applyDataSourcePropertiesToBuilder(oracleConnectionBuilderImpl);
        connection = this.getPhysicalConnection(properties, oracleConnectionBuilderImpl.getGSSCredential(), oracleConnectionBuilderImpl.getSSLContext(), oracleConnectionBuilderImpl.getTokenSupplier());
        if (connection == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        return connection;
    }

    private void applyDataSourcePropertiesToBuilder(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        if (oracleConnectionBuilderImpl == null) {
            return;
        }
        if (this.sslContext != null && oracleConnectionBuilderImpl.getSSLContext() == null) {
            oracleConnectionBuilderImpl.sslContext(this.sslContext);
        }
        this.configureTokenSupplier(oracleConnectionBuilderImpl);
    }

    private void configureTokenSupplier(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        Supplier<? extends AccessToken> supplier = this.tokenSupplier;
        if (supplier == null) {
            return;
        }
        if (this.isUserOrPasswordConfigured()) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "DataSource configured with a token supplying function is also configured with a user name or password").fillInStackTrace();
        }
        if (oracleConnectionBuilderImpl == null || oracleConnectionBuilderImpl.getTokenSupplier() != null || oracleConnectionBuilderImpl.getUser() != null || oracleConnectionBuilderImpl.getPassword() != null) {
            return;
        }
        oracleConnectionBuilderImpl.setTokenSupplier(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserOrPasswordConfigured() {
        OracleDataSource oracleDataSource = this;
        synchronized (oracleDataSource) {
            return this.user != null || this.password != null && !this.password.isNull() || this.connectionProperties != null && (this.connectionProperties.containsKey("user") || this.connectionProperties.containsKey("oracle.jdbc.user") || this.connectionProperties.containsKey("password") || this.connectionProperties.containsKey("oracle.jdbc.password"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getPhysicalConnection(Properties properties, GSSCredential gSSCredential, SSLContext sSLContext, Supplier<? extends AccessToken> supplier) throws SQLException {
        Connection connection = null;
        Properties properties2 = properties;
        String string = properties.getProperty("connection_url");
        String string2 = properties.getProperty("user");
        String string3 = properties2.getProperty("password");
        String string4 = properties2.getProperty("oracle.jdbc.targetInstanceName");
        String string5 = properties2.getProperty("oracle.jdbc.targetServiceName");
        String string6 = properties2.getProperty("oracle.jdbc.targetShardingKey");
        String string7 = properties2.getProperty("oracle.jdbc.targetSuperShardingKey");
        String string8 = null;
        boolean bl = false;
        OracleDataSource oracleDataSource = this;
        synchronized (oracleDataSource) {
            String string9;
            if (this.connectionProperties != null) {
                properties2 = (Properties)this.connectionProperties.clone();
                if (string2 != null) {
                    properties2.put("user", string2);
                }
                if (string3 != null) {
                    properties2.put("password", string3);
                }
                if (string4 != null) {
                    properties2.put("oracle.jdbc.targetInstanceName", string4);
                }
                if (string5 != null) {
                    properties2.put("oracle.jdbc.targetServiceName", string5);
                }
                if (string6 != null) {
                    properties2.put("oracle.jdbc.targetShardingKey", string6);
                }
                if (string7 != null) {
                    properties2.put("oracle.jdbc.targetSuperShardingKey", string7);
                }
            }
            if (gSSCredential == null) {
                if (string2 == null && this.user != null) {
                    properties2.put("user", this.user);
                }
                if (string3 == null && this.password != null && this.password.get() != null) {
                    properties2.put("password", this.password.get());
                }
            }
            if (string == null) {
                string = this.url;
            }
            if ((string9 = properties.getProperty("LoginTimeout")) != null) {
                properties2.put("oracle.net.CONNECT_TIMEOUT", "" + Integer.parseInt(string9) * 1000);
            }
            bl = this.useDefaultConnection;
            if (this.driver == null) {
                this.driver = new OracleDriver();
            }
        }
        connection = bl ? this.driver.defaultConnection() : this.driver.connect(string, properties2, gSSCredential, sSLContext != null ? sSLContext : this.sslContext, supplier != null ? supplier : this.tokenSupplier);
        if (connection == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        string8 = properties.getProperty("stmt_cache_size");
        int n2 = 0;
        if (string8 != null) {
            n2 = Integer.parseInt(string8);
            ((OracleConnection)connection).setStatementCacheSize(n2);
        }
        boolean bl2 = false;
        string8 = properties.getProperty("ExplicitStatementCachingEnabled");
        if (string8 != null) {
            bl2 = string8.equals("true");
            ((OracleConnection)connection).setExplicitCachingEnabled(bl2);
        } else if (this.explicitCachingEnabled) {
            ((OracleConnection)connection).setExplicitCachingEnabled(true);
        }
        boolean bl3 = false;
        string8 = properties.getProperty("ImplicitStatementCachingEnabled");
        if (string8 != null) {
            bl3 = string8.equals("true");
            ((OracleConnection)connection).setImplicitCachingEnabled(bl3);
        } else if (this.implicitCachingEnabled) {
            ((OracleConnection)connection).setImplicitCachingEnabled(true);
        }
        if (n2 > 0 && !bl2 && !bl3) {
            ((OracleConnection)connection).setImplicitCachingEnabled(true);
            ((OracleConnection)connection).setExplicitCachingEnabled(true);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(Properties properties) throws SQLException {
        String string = null;
        OpaqueString opaqueString = null;
        Object object = this;
        synchronized (object) {
            if (!this.connCachingEnabled) {
                throw (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
            }
            string = this.user;
            opaqueString = this.password;
        }
        object = null;
        if (opaqueString != null) {
            object = opaqueString.get();
        }
        Connection connection = this.getConnection(string, (String)object, properties);
        return connection;
    }

    public Connection getConnection(String string, @Blind String string2, Properties properties) throws SQLException {
        if (!this.connCachingEnabled) {
            throw (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
        }
        if (this.odsCache == null) {
            this.cacheInitialize();
        }
        Connection connection = this.odsCache.getConnection(string, string2, properties);
        return connection;
    }

    private synchronized void cacheInitialize() throws SQLException {
        if (this.odsCache == null) {
            if (this.connCacheName != null) {
                this.cacheManager.createCache(this.connCacheName, this, this.connCacheProperties);
            } else {
                this.connCacheName = this.cacheManager.createCache(this, this.connCacheProperties);
            }
        }
    }

    public synchronized void close() throws SQLException {
        if (this.connCachingEnabled && this.odsCache != null) {
            this.cacheManager.removeCache(this.odsCache.cacheName, 0L);
            this.odsCache = null;
        }
    }

    public synchronized void setConnectionCachingEnabled(boolean bl) throws SQLException {
        if (this.isOracleDataSource) {
            if (bl) {
                this.connCachingEnabled = true;
                if (this.cacheManager == null) {
                    this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                }
            } else if (this.odsCache == null) {
                this.connCachingEnabled = false;
                this.fastConnFailover = false;
                this.setSpawnNewThreadToCancel(false);
                this.connCacheName = null;
                this.connCacheProperties = null;
            }
        } else {
            throw (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
        }
    }

    public boolean getConnectionCachingEnabled() throws SQLException {
        return this.connCachingEnabled;
    }

    public synchronized void setConnectionCacheName(String string) throws SQLException {
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(138).fillInStackTrace();
        }
        this.connCacheName = string;
    }

    public String getConnectionCacheName() throws SQLException {
        if (this.connCachingEnabled && this.odsCache != null) {
            return this.odsCache.cacheName;
        }
        return this.connCacheName;
    }

    public synchronized void setConnectionCacheProperties(Properties properties) throws SQLException {
        this.connCacheProperties = properties;
    }

    public Properties getConnectionCacheProperties() throws SQLException {
        if (this.connCachingEnabled && this.odsCache != null) {
            return this.odsCache.getConnectionCacheProperties();
        }
        return this.connCacheProperties;
    }

    public synchronized void setFastConnectionFailoverEnabled(boolean bl) throws SQLException {
        if (!this.fastConnFailover) {
            this.fastConnFailover = bl;
            this.setSpawnNewThreadToCancel(bl);
        } else if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(255).fillInStackTrace();
        }
    }

    public boolean getFastConnectionFailoverEnabled() throws SQLException {
        return this.fastConnFailover;
    }

    public String getONSConfiguration() throws SQLException {
        return this.onsConfigStr;
    }

    public synchronized void setONSConfiguration(String string) throws SQLException {
        this.onsConfigStr = string;
    }

    @Override
    public synchronized int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public synchronized void setLoginTimeout(int n2) {
        this.loginTimeout = n2;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    @Override
    public synchronized PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public synchronized void setTNSEntryName(String string) {
        this.tnsEntry = string;
    }

    public synchronized String getTNSEntryName() {
        return this.tnsEntry;
    }

    @Override
    public synchronized void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    @Override
    public synchronized String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public synchronized String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public synchronized void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public synchronized void setServiceName(String string) {
        this.serviceName = string;
    }

    public synchronized String getServiceName() {
        return this.serviceName;
    }

    @Override
    public synchronized void setServerName(String string) {
        this.serverName = string;
    }

    @Override
    public synchronized String getServerName() {
        return this.serverName;
    }

    @Override
    public synchronized void setURL(String string) {
        this.url = string;
        if (this.url != null) {
            this.urlExplicit = true;
        }
        if (this.connCachingEnabled && this.odsCache != null && this.odsCache.connectionPoolDS != null) {
            this.odsCache.connectionPoolDS.url = string;
        }
    }

    @Override
    public synchronized String getURL() throws SQLException {
        if (!this.urlExplicit) {
            this.makeURL();
        }
        return this.url;
    }

    @Override
    public synchronized void setUser(String string) {
        this.user = string;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    private synchronized void setPassword(OpaqueString opaqueString) {
        this.password = opaqueString;
    }

    @Override
    public synchronized void setPassword(@Blind String string) {
        this.setPassword(OpaqueString.newOpaqueString(string));
    }

    @Blind
    protected String getPassword() {
        return this.password != null ? this.password.get() : null;
    }

    @Override
    public synchronized String getDescription() {
        return this.description;
    }

    @Override
    public synchronized void setDescription(String string) {
        this.description = string;
    }

    public synchronized String getDriverType() {
        return this.driverType;
    }

    public synchronized void setDriverType(String string) {
        this.driverType = string;
    }

    @Override
    public synchronized String getNetworkProtocol() {
        return this.networkProtocol;
    }

    @Override
    public synchronized void setNetworkProtocol(String string) throws SQLException {
        this.networkProtocol = string;
    }

    @Override
    public synchronized void setPortNumber(int n2) {
        this.portNumber = n2;
    }

    @Override
    public synchronized int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        this.addRefProperties(reference);
        return reference;
    }

    protected void addRefProperties(Reference reference) {
        if (this.url != null) {
            reference.add(new StringRefAddr("url", this.url));
        }
        if (this.user != null) {
            reference.add(new StringRefAddr("userName", this.user));
        }
        if (this.password != null && !this.password.isNull()) {
            reference.add(new StringRefAddr("passWord", this.password.get()));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description));
        }
        if (this.driverType != null) {
            reference.add(new StringRefAddr("driverType", this.driverType));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.serviceName != null) {
            reference.add(new StringRefAddr("serviceName", this.serviceName));
        }
        if (this.networkProtocol != null) {
            reference.add(new StringRefAddr("networkProtocol", this.networkProtocol));
        }
        if (this.portNumber != 0) {
            reference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        }
        if (this.tnsEntry != null) {
            reference.add(new StringRefAddr("tnsentryname", this.tnsEntry));
        }
        if (this.maxStatementsSet) {
            reference.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
        }
        if (this.implicitCachingEnabledSet) {
            reference.add(new StringRefAddr("implicitCachingEnabled", this.implicitCachingEnabled ? "true" : "false"));
        }
        if (this.explicitCachingEnabledSet) {
            reference.add(new StringRefAddr("explicitCachingEnabled", this.explicitCachingEnabled ? "true" : "false"));
        }
        if (this.connCachingEnabled) {
            reference.add(new StringRefAddr("connectionCachingEnabled", "true"));
        }
        if (this.connCacheName != null) {
            reference.add(new StringRefAddr("connectionCacheName", this.connCacheName));
        }
        if (this.connCacheProperties != null) {
            reference.add(new StringRefAddr("connectionCacheProperties", this.connCacheProperties.toString()));
        }
        if (this.fastConnFailover) {
            reference.add(new StringRefAddr("fastConnectionFailoverEnabled", "true"));
        }
        if (this.onsConfigStr != null) {
            reference.add(new StringRefAddr("onsConfigStr", this.onsConfigStr));
        }
    }

    void makeURL() throws SQLException {
        if (this.urlExplicit) {
            return;
        }
        if (this.driverType == null || !this.driverType.equals("oci8") && !this.driverType.equals("oci") && !this.driverType.equals("thin") && !this.driverType.equals("kprb")) {
            throw (SQLException)DatabaseError.createSqlException(67, "OracleDataSource.makeURL").fillInStackTrace();
        }
        if (this.driverType.equals("kprb")) {
            this.useDefaultConnection = true;
            this.url = "jdbc:oracle:kprb:@";
            return;
        }
        if ((this.driverType.equals("oci8") || this.driverType.equals("oci")) && this.networkProtocol != null && this.networkProtocol.equals("ipc")) {
            this.url = "jdbc:oracle:oci:@";
            return;
        }
        if (this.tnsEntry != null) {
            this.url = "jdbc:oracle:" + this.driverType + ":@" + this.tnsEntry;
            return;
        }
        if (this.serviceName != null) {
            this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")))";
        } else {
            this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SID=" + this.databaseName + ")))";
            DatabaseError.addSqlWarning(null, new SQLWarning("URL with SID jdbc:subprotocol:@host:port:sid will be deprecated in 10i\nPlease use URL with SERVICE_NAME as jdbc:subprotocol:@//host:port/service_name"));
            if (this.fastConnFailover) {
                throw (SQLException)DatabaseError.createSqlException(67, "OracleDataSource.makeURL").fillInStackTrace();
            }
        }
    }

    protected void trace(String string) {
        if (this.logWriter != null) {
        }
    }

    protected void copy(OracleDataSource oracleDataSource) throws SQLException {
        oracleDataSource.setUser(this.user);
        oracleDataSource.setPassword(this.password);
        oracleDataSource.setTNSEntryName(this.tnsEntry);
        this.makeURL();
        oracleDataSource.setURL(this.url);
        if (this.loginTimeout > 0) {
            oracleDataSource.setLoginTimeout(this.loginTimeout);
        }
        oracleDataSource.connectionProperties = this.connectionProperties;
    }

    @Override
    public void setMaxStatements(int n2) throws SQLException {
        if (n2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        this.maxStatementsSet = true;
        this.maxStatements = n2;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.maxStatements;
    }

    @Override
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        this.implicitCachingEnabledSet = true;
        this.implicitCachingEnabled = bl;
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.implicitCachingEnabled;
    }

    @Override
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        this.explicitCachingEnabledSet = true;
        this.explicitCachingEnabled = bl;
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.explicitCachingEnabled;
    }

    @Override
    public void setConnectionProperties(Properties properties) throws SQLException {
        this.connectionProperties = properties == null ? properties : (Properties)properties.clone();
        this.setSpawnNewThreadToCancel(this.fastConnFailover);
    }

    protected String getConnectionProperty(String string) throws SQLException {
        return this.connectionProperties == null ? null : this.connectionProperties.getProperty(string);
    }

    protected void setConnectionProperty(String string, String string2) throws SQLException {
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException();
        }
        if (this.connectionProperties == null) {
            this.connectionProperties = new Properties();
        }
        this.connectionProperties.setProperty(string, string2);
    }

    @Override
    public void setRoleName(String string) throws SQLException {
        this.roleName = string;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public Properties getConnectionProperties() throws SQLException {
        return OracleDataSource.filterConnectionProperties(this.connectionProperties);
    }

    public static final Properties filterConnectionProperties(Properties properties) {
        Properties properties2 = null;
        if (properties != null) {
            properties2 = (Properties)properties.clone();
            Enumeration<?> enumeration = properties2.propertyNames();
            Object var3_3 = null;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null || !string.matches(".*[P,p][A,a][S,s][S,s][W,w][O,o][R,r][D,d].*")) continue;
                properties2.remove(string);
            }
            properties.remove(spawnNewThreadToCancelProperty);
        }
        return properties2;
    }

    private void setSpawnNewThreadToCancel(boolean bl) {
        if (bl) {
            if (this.connectionProperties == null) {
                this.connectionProperties = new Properties();
            }
            this.connectionProperties.setProperty(spawnNewThreadToCancelProperty, "true");
        } else if (this.connectionProperties != null) {
            this.connectionProperties.remove(spawnNewThreadToCancelProperty);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        objectInputStream.defaultReadObject();
        if (this.connCachingEnabled) {
            this.setConnectionCachingEnabled(this.connCachingEnabled);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("oracle");
    }

    @Override
    public final synchronized void setSSLContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public OracleConnectionBuilderImpl createConnectionBuilder() {
        return new OracleConnectionBuilderImpl(){

            @Override
            public OracleConnection build() throws SQLException {
                this.verifyBuildConfiguration();
                return (OracleConnection)OracleDataSource.this.getConnection(this);
            }
        };
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    @Override
    public final void setTokenSupplier(Supplier<? extends AccessToken> supplier) {
        this.tokenSupplier = Objects.requireNonNull(supplier, "tokenSuplier is null");
    }
}

