/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.PgqlResult;
import oracle.pgql.lang.completion.ClauseOrAggregate;
import oracle.pgql.lang.completion.Function;
import oracle.pgql.lang.completion.Keyword;
import oracle.pgql.lang.editor.completion.PgqlCompletion;
import oracle.pgql.lang.editor.completion.PgqlCompletionContext;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.QueryVertex;
import oracle.pgql.lang.ir.VertexPairConnection;
import org.apache.commons.lang3.StringUtils;
import org.metaborg.core.completion.ICompletion;

public class PgqlCompletionGenerator {
    private static final String FROM = "FROM";
    private static final String MATCH = "MATCH";
    public static final PgqlCompletion MATCH_CLAUSE_COMPLETION = PgqlCompletionGenerator.completion("MATCH (n)", "match clause");
    private static final String VERTEX = "(n)";
    private static final String EDGE_VERTEX = "-[e]-> (m)";
    private static final String REV_EDGE_VERTEX = "<-[e]- (m)";
    private static final String PATH_VERTEX = "-/:lbl*/-> (m)";
    private static final String REV_PATH_VERTEX = "<-/:lbl*/- (m)";
    public static final PgqlCompletion EMPTY_STRING_COMPLETION = PgqlCompletionGenerator.completion("SELECT n.prop\n  FROM g\n MATCH (n)", "query");
    public static final PgqlCompletion VERTEX_COMPLETION = PgqlCompletionGenerator.completion("(n)", "vertex");
    public static final PgqlCompletion SPACE_VERTEX_COMPLETION = PgqlCompletionGenerator.completion(" (n)", "vertex");
    public static final PgqlCompletion COMMA_VERTEX_COMPLETION = PgqlCompletionGenerator.completion(", (n)", "vertex");
    public static final PgqlCompletion[] RELATION_VERTEX_COMPLETIONS = new PgqlCompletion[]{PgqlCompletionGenerator.completion("-[e]-> (m)", "edge and vertex"), PgqlCompletionGenerator.completion("-/:lbl*/-> (m)", "path and vertex"), PgqlCompletionGenerator.completion("<-[e]- (m)", "edge and vertex"), PgqlCompletionGenerator.completion("<-/:lbl*/- (m)", "path and vertex")};
    public static final PgqlCompletion[] SPACE_RELATION_VERTEX_COMPLETIONS = new PgqlCompletion[]{PgqlCompletionGenerator.completion(" -[e]-> (m)", "edge and vertex"), PgqlCompletionGenerator.completion(" -/:lbl*/-> (m)", "path and vertex"), PgqlCompletionGenerator.completion(" <-[e]- (m)", "edge and vertex"), PgqlCompletionGenerator.completion(" <-/:lbl*/- (m)", "path and vertex")};
    private static final String IDENTIFIER = "[A-Za-z][A-Za-z0-9_]*";
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
    private static final Pattern IDENTIFIER_AT_END_PATTERN = Pattern.compile("[A-Za-z][A-Za-z0-9_]*$");
    private static final Map<ClauseOrAggregate, List<Keyword>> allowedClauseKeywords = PgqlCompletionGenerator.initAllowedClauseKeywords();

    public static List<PgqlCompletion> generate(PgqlResult pgqlResult, Iterable<ICompletion> spoofaxCompletions, String queryString, int cursor, PgqlCompletionContext ctx) throws PgqlException {
        int lastIndexOfFrom;
        ArrayList<PgqlCompletion> result = new ArrayList<PgqlCompletion>();
        if (queryString.trim().isEmpty()) {
            result.add(EMPTY_STRING_COMPLETION);
            return result;
        }
        String stringBeforeCursor = queryString.substring(0, cursor);
        String trimmedStringBeforeCursor = stringBeforeCursor.trim().toUpperCase();
        String stringAfterCursor = queryString.substring(cursor);
        String trimmedStringAfterCursor = stringAfterCursor.trim().toUpperCase();
        ClauseOrAggregate currentClause = PgqlCompletionGenerator.getCurrentClauseOrAggregate(trimmedStringBeforeCursor);
        List<PgqlCompletion> incompleteKeywords = PgqlCompletionGenerator.getIncompleteKeywords(stringBeforeCursor.trim(), trimmedStringAfterCursor, currentClause);
        if (!incompleteKeywords.isEmpty()) {
            result.addAll(incompleteKeywords);
            return result;
        }
        if (pgqlResult == null) {
            if (queryString.toUpperCase().trim().endsWith(MATCH)) {
                if (queryString.endsWith(" ")) {
                    return Collections.singletonList(VERTEX_COMPLETION);
                }
                return Collections.singletonList(SPACE_VERTEX_COMPLETION);
            }
            return Collections.emptyList();
        }
        String graphName = null;
        if (pgqlResult.getGraphQuery() != null) {
            graphName = pgqlResult.getGraphQuery().getInputGraphName();
        }
        if (graphName == null && (lastIndexOfFrom = queryString.toUpperCase().lastIndexOf(FROM)) != -1) {
            String stringAfterFrom = queryString.substring(lastIndexOfFrom + FROM.length());
            graphName = PgqlCompletionGenerator.parseIdentifierAtBeginning(stringAfterFrom);
        }
        if (queryString.charAt(cursor - 1) == ':') {
            return PgqlCompletionGenerator.generateLabelSuggestions(graphName, queryString, cursor, ctx);
        }
        if (queryString.charAt(cursor - 1) == '.') {
            return PgqlCompletionGenerator.generatePropertySuggestions(graphName, pgqlResult, queryString, cursor, ctx);
        }
        List<PgqlCompletion> variableProposals = PgqlCompletionGenerator.getVariableProposals(pgqlResult);
        boolean proposeExpressions = false;
        boolean proposeAggregations = false;
        if (currentClause == null) {
            return result;
        }
        switch (currentClause) {
            case SELECT: 
            case ORDER_BY: {
                proposeExpressions = true;
                proposeAggregations = true;
                break;
            }
            case FROM: {
                if (trimmedStringBeforeCursor.endsWith(FROM)) {
                    return PgqlCompletionGenerator.generateInputGraphCompletions(ctx);
                }
                return Collections.singletonList(MATCH_CLAUSE_COMPLETION);
            }
            case MATCH: {
                if (trimmedStringBeforeCursor.endsWith(",")) {
                    if (stringBeforeCursor.endsWith(" ")) {
                        return Collections.singletonList(VERTEX_COMPLETION);
                    }
                    return Collections.singletonList(SPACE_VERTEX_COMPLETION);
                }
                if (!trimmedStringBeforeCursor.endsWith(")")) break;
                ArrayList<PgqlCompletion> completions = new ArrayList<PgqlCompletion>();
                if (stringBeforeCursor.endsWith(" ")) {
                    completions.addAll(Arrays.asList(RELATION_VERTEX_COMPLETIONS));
                } else {
                    completions.addAll(Arrays.asList(SPACE_RELATION_VERTEX_COMPLETIONS));
                }
                completions.add(COMMA_VERTEX_COMPLETION);
                return completions;
            }
            case WHERE: 
            case GROUP_BY: 
            case COUNT: 
            case LISTAGG: 
            case MIN: 
            case MAX: 
            case AVG: 
            case SUM: {
                proposeExpressions = true;
                break;
            }
        }
        if (proposeExpressions) {
            result.addAll(variableProposals);
            result.addAll(PgqlCompletionGenerator.functions());
        }
        if (proposeAggregations) {
            result.addAll(PgqlCompletionGenerator.aggregations());
        }
        if (proposeExpressions) {
            result.addAll(PgqlCompletionGenerator.otherExpressions());
        }
        return result;
    }

    private static List<PgqlCompletion> generateInputGraphCompletions(PgqlCompletionContext ctx) {
        ArrayList<PgqlCompletion> completions = new ArrayList<PgqlCompletion>();
        for (String graphName : ctx.getGraphNames()) {
            completions.add(PgqlCompletionGenerator.completion(graphName, "graph name"));
        }
        return completions;
    }

    private static List<PgqlCompletion> getVariableProposals(PgqlResult pgqlResult) throws PgqlException {
        ArrayList<PgqlCompletion> variables = new ArrayList<PgqlCompletion>();
        GraphQuery graphQuery = pgqlResult.getGraphQuery();
        if (graphQuery == null) {
            return variables;
        }
        GraphPattern graphPattern = graphQuery.getGraphPattern();
        if (graphPattern == null) {
            return variables;
        }
        for (QueryVertex vertex : graphPattern.getVertices()) {
            if (vertex.getName().contains("<<vertex-without-brackets>>") || vertex.isAnonymous()) continue;
            variables.add(new PgqlCompletion(vertex.getName(), "vertex"));
        }
        for (VertexPairConnection connection : graphPattern.getConnections()) {
            if (connection.isAnonymous()) continue;
            variables.add(new PgqlCompletion(connection.getName(), connection.getVariableType().toString().toLowerCase()));
        }
        return variables;
    }

    private static List<PgqlCompletion> generatePropertySuggestions(String graphName, PgqlResult pgqlResult, String queryString, int cursor, PgqlCompletionContext ctx) throws PgqlException {
        String variableName = PgqlCompletionGenerator.parseIdentifierAtEnd(queryString, cursor - 1);
        if (variableName == null) {
            return Collections.emptyList();
        }
        GraphPattern graphPattern = pgqlResult.getGraphQuery().getGraphPattern();
        if (graphPattern == null) {
            return Collections.emptyList();
        }
        Set vertices = graphPattern.getVertices();
        boolean isVertexVariable = vertices.stream().map(QueryVariable::getName).anyMatch(variableName::equals);
        if (isVertexVariable) {
            return ctx.getVertexProperties(graphName).stream().map(prop -> new PgqlCompletion(prop, "vertex property")).collect(Collectors.toList());
        }
        Set edges = graphPattern.getConnections();
        boolean isEdgeVariable = edges.stream().filter(n -> n.getVariableType() == QueryVariable.VariableType.EDGE).map(QueryVariable::getName).anyMatch(variableName::equals);
        if (isEdgeVariable) {
            return ctx.getEdgeProperties(graphName).stream().map(prop -> new PgqlCompletion(prop, "edge property")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<PgqlCompletion> generateLabelSuggestions(String graphName, String queryString, int cursor, PgqlCompletionContext ctx) {
        String queryUpToCursor = queryString.substring(0, cursor - 2);
        if (queryUpToCursor.lastIndexOf(40) > queryUpToCursor.lastIndexOf(91)) {
            return ctx.getVertexLabels(graphName).stream().map(lbl -> new PgqlCompletion(lbl, "vertex label")).collect(Collectors.toList());
        }
        return ctx.getEdgeLabels(graphName).stream().map(lbl -> new PgqlCompletion(lbl, "edge label")).collect(Collectors.toList());
    }

    private static ClauseOrAggregate getCurrentClauseOrAggregate(String trimmedQuery) {
        ClauseOrAggregate result = null;
        int index = -1;
        for (ClauseOrAggregate c : ClauseOrAggregate.values()) {
            int newIndex = trimmedQuery.lastIndexOf(c.toString().replace("_", " "));
            if (newIndex <= index) continue;
            result = c;
            index = newIndex;
        }
        return result;
    }

    private static final Map<ClauseOrAggregate, List<Keyword>> initAllowedClauseKeywords() {
        ArrayList<ClauseOrAggregate> aggregates = new ArrayList<ClauseOrAggregate>();
        aggregates.add(ClauseOrAggregate.COUNT);
        aggregates.add(ClauseOrAggregate.LISTAGG);
        aggregates.add(ClauseOrAggregate.MIN);
        aggregates.add(ClauseOrAggregate.MAX);
        aggregates.add(ClauseOrAggregate.AVG);
        aggregates.add(ClauseOrAggregate.SUM);
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Function f : Function.values()) {
            functions.add(f);
        }
        HashMap<ClauseOrAggregate, List<Keyword>> allowedKeywords = new HashMap<ClauseOrAggregate, List<Keyword>>();
        for (ClauseOrAggregate c : aggregates) {
            allowedKeywords.put(c, Collections.emptyList());
        }
        ArrayList<ClauseOrAggregate> nullList = new ArrayList<ClauseOrAggregate>();
        nullList.add(ClauseOrAggregate.SELECT);
        allowedKeywords.put(null, nullList);
        ArrayList<Enum> selectList = new ArrayList<Enum>();
        selectList.addAll(aggregates);
        selectList.addAll(functions);
        selectList.add(ClauseOrAggregate.FROM);
        selectList.add(ClauseOrAggregate.MATCH);
        allowedKeywords.put(ClauseOrAggregate.SELECT, selectList);
        ArrayList<ClauseOrAggregate> fromList = new ArrayList<ClauseOrAggregate>();
        fromList.add(ClauseOrAggregate.MATCH);
        allowedKeywords.put(ClauseOrAggregate.FROM, fromList);
        ArrayList<ClauseOrAggregate> matchList = new ArrayList<ClauseOrAggregate>();
        matchList.add(ClauseOrAggregate.WHERE);
        matchList.add(ClauseOrAggregate.GROUP_BY);
        matchList.add(ClauseOrAggregate.HAVING);
        matchList.add(ClauseOrAggregate.ORDER_BY);
        matchList.add(ClauseOrAggregate.LIMIT);
        matchList.add(ClauseOrAggregate.OFFSET);
        allowedKeywords.put(ClauseOrAggregate.MATCH, matchList);
        ArrayList<Enum> whereList = new ArrayList<Enum>();
        whereList.addAll(aggregates);
        whereList.addAll(functions);
        whereList.add(ClauseOrAggregate.GROUP_BY);
        whereList.add(ClauseOrAggregate.HAVING);
        whereList.add(ClauseOrAggregate.ORDER_BY);
        whereList.add(ClauseOrAggregate.LIMIT);
        whereList.add(ClauseOrAggregate.OFFSET);
        allowedKeywords.put(ClauseOrAggregate.WHERE, whereList);
        ArrayList<ClauseOrAggregate> groupByList = new ArrayList<ClauseOrAggregate>();
        groupByList.add(ClauseOrAggregate.HAVING);
        groupByList.add(ClauseOrAggregate.ORDER_BY);
        groupByList.add(ClauseOrAggregate.LIMIT);
        groupByList.add(ClauseOrAggregate.OFFSET);
        allowedKeywords.put(ClauseOrAggregate.GROUP_BY, groupByList);
        ArrayList<Enum> havingList = new ArrayList<Enum>();
        havingList.addAll(aggregates);
        havingList.addAll(functions);
        havingList.add(ClauseOrAggregate.ORDER_BY);
        havingList.add(ClauseOrAggregate.LIMIT);
        havingList.add(ClauseOrAggregate.OFFSET);
        allowedKeywords.put(ClauseOrAggregate.HAVING, havingList);
        ArrayList<Enum> orderByList = new ArrayList<Enum>();
        orderByList.addAll(aggregates);
        orderByList.addAll(functions);
        orderByList.add(ClauseOrAggregate.LIMIT);
        orderByList.add(ClauseOrAggregate.OFFSET);
        allowedKeywords.put(ClauseOrAggregate.ORDER_BY, orderByList);
        ArrayList<ClauseOrAggregate> limitList = new ArrayList<ClauseOrAggregate>();
        limitList.add(ClauseOrAggregate.OFFSET);
        allowedKeywords.put(ClauseOrAggregate.LIMIT, limitList);
        ArrayList<ClauseOrAggregate> offsetList = new ArrayList<ClauseOrAggregate>();
        offsetList.add(ClauseOrAggregate.LIMIT);
        allowedKeywords.put(ClauseOrAggregate.OFFSET, offsetList);
        return allowedKeywords;
    }

    private static PgqlCompletion getKeywordCompletion(String beforeQuery, String afterQuery, Keyword keyword) {
        int idx;
        int partsIdx;
        String keywordExpression = keyword.getStringExpression();
        if (afterQuery.contains(keywordExpression)) {
            return null;
        }
        String[] keywordParts = StringUtils.split((String)keywordExpression);
        String[] words = StringUtils.split((String)beforeQuery.toUpperCase());
        int idxLastWord = words.length - 1;
        boolean isKeyword = false;
        for (partsIdx = keywordParts.length - 1; partsIdx >= 0 && !isKeyword; --partsIdx) {
            String currentPart = keywordParts[partsIdx];
            isKeyword = currentPart.startsWith(words[idxLastWord]);
            for (idx = 1; isKeyword && idx <= partsIdx; ++idx) {
                isKeyword = keywordParts[partsIdx - idx].equals(words[idxLastWord - idx]);
            }
        }
        if (!isKeyword) {
            return null;
        }
        String completion = keywordParts[partsIdx + 1].substring(words[idxLastWord].length());
        for (idx = partsIdx + 2; idx < keywordParts.length; ++idx) {
            completion = completion + " " + keywordParts[idx];
        }
        if (!Character.isUpperCase(beforeQuery.charAt(beforeQuery.length() - 1))) {
            completion = completion.toLowerCase();
        }
        return keyword.getCompletion(completion);
    }

    private static List<PgqlCompletion> getIncompleteKeywords(String beforeQuery, String afterQuery, ClauseOrAggregate currentClause) {
        ArrayList<PgqlCompletion> keywords = new ArrayList<PgqlCompletion>();
        for (Keyword allowedKeyword : allowedClauseKeywords.get(currentClause)) {
            PgqlCompletion completion = PgqlCompletionGenerator.getKeywordCompletion(beforeQuery, afterQuery, allowedKeyword);
            if (completion == null) continue;
            keywords.add(completion);
        }
        return keywords;
    }

    private static String parseIdentifierAtBeginning(String s) {
        return PgqlCompletionGenerator.matchPattern(s, IDENTIFIER_PATTERN);
    }

    private static String parseIdentifierAtEnd(String queryString, int positionLastCharacter) {
        String s = queryString.substring(0, positionLastCharacter);
        return PgqlCompletionGenerator.matchPattern(s, IDENTIFIER_AT_END_PATTERN);
    }

    private static String matchPattern(String s, Pattern pattern) {
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static PgqlCompletion completion(String value, String meta) {
        return new PgqlCompletion(value, meta);
    }

    public static List<PgqlCompletion> completions(PgqlCompletion ... completions) {
        return new ArrayList<PgqlCompletion>(Arrays.asList(completions));
    }

    public static List<PgqlCompletion> functions() {
        ArrayList<PgqlCompletion> functions = new ArrayList<PgqlCompletion>();
        for (Function f : Function.values()) {
            functions.add(f.getCompletion());
        }
        return functions;
    }

    public static List<PgqlCompletion> aggregations() {
        return PgqlCompletionGenerator.completions(PgqlCompletionGenerator.completion("COUNT(*)", "count the number of matches"), ClauseOrAggregate.COUNT.getCompletion(), ClauseOrAggregate.LISTAGG.getCompletion(), ClauseOrAggregate.MIN.getCompletion(), ClauseOrAggregate.MAX.getCompletion(), ClauseOrAggregate.AVG.getCompletion(), ClauseOrAggregate.SUM.getCompletion());
    }

    public static List<PgqlCompletion> otherExpressions() {
        return PgqlCompletionGenerator.completions(PgqlCompletionGenerator.completion("true", "boolean literal"), PgqlCompletionGenerator.completion("false", "boolean literal"), PgqlCompletionGenerator.completion("DATE '2017-01-01'", "date literal"), PgqlCompletionGenerator.completion("TIME '20:15:00'", "time literal"), PgqlCompletionGenerator.completion("TIMESTAMP '2017-01-01 20:15:00'", "timestamp literal"), PgqlCompletionGenerator.completion("CAST(exp AS type)", "cast"), PgqlCompletionGenerator.completion("exp IS NULL", "is null"), PgqlCompletionGenerator.completion("exp IS NOT NULL", "is not null"), PgqlCompletionGenerator.completion("exp AND exp", "conjunction"), PgqlCompletionGenerator.completion("exp OR exp", "disjuncion"), PgqlCompletionGenerator.completion("NOT exp", "negation"), PgqlCompletionGenerator.completion("exp * exp", "multiplication"), PgqlCompletionGenerator.completion("exp + exp", "addition"), PgqlCompletionGenerator.completion("exp / exp", "division"), PgqlCompletionGenerator.completion("exp % exp", "modulo"), PgqlCompletionGenerator.completion("exp - exp", "subtraction"), PgqlCompletionGenerator.completion("exp = exp", "equals"), PgqlCompletionGenerator.completion("exp > exp", "greater than"), PgqlCompletionGenerator.completion("exp < exp", "less than"), PgqlCompletionGenerator.completion("exp >= exp", "greater than equals"), PgqlCompletionGenerator.completion("exp <= exp", "less than equals"), PgqlCompletionGenerator.completion("exp <> exp", "not equals"));
    }
}

