/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang;

import java.util.ArrayList;
import oracle.pgql.lang.CommonTranslationUtil;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.TranslationContext;
import oracle.pgql.lang.ddl.CallStatement;
import oracle.pgql.lang.ir.PgqlStatement;
import oracle.pgql.lang.ir.QueryExpression;
import org.spoofax.interpreter.terms.IStrategoTerm;

public class TranslateCallStatement {
    private static final int POS_PACKAGE_NAME = 0;
    private static final int POS_ROUTINE_NAME = 1;
    private static final int POS_PACKAGE_NAME_SCHEMA_PART = 0;
    private static final int POS_PACKAGE_NAME_PACKAGE_PART = 1;
    private static final int POS_ARGUMENT_LIST = 2;

    protected static PgqlStatement translateCallStatement(IStrategoTerm ast) throws PgqlException {
        String schemaName = null;
        String packageName = null;
        IStrategoTerm optionalPackageDeclT = ast.getSubterm(0);
        if (CommonTranslationUtil.isSome(optionalPackageDeclT)) {
            IStrategoTerm packageDeclT = CommonTranslationUtil.getSomeValue(optionalPackageDeclT);
            IStrategoTerm schemaT = packageDeclT.getSubterm(0);
            if (CommonTranslationUtil.isSome(schemaT)) {
                schemaName = CommonTranslationUtil.getString(schemaT);
            }
            packageName = CommonTranslationUtil.getString(packageDeclT.getSubterm(1));
        }
        String routineName = CommonTranslationUtil.getString(ast.getSubterm(1));
        IStrategoTerm argumentListT = ast.getSubterm(2);
        ArrayList<QueryExpression> argumentList = new ArrayList<QueryExpression>(argumentListT.getSubtermCount());
        TranslationContext ctx = new TranslationContext();
        for (IStrategoTerm argumentT : argumentListT.getSubterms()) {
            argumentList.add(CommonTranslationUtil.translateExp(argumentT, ctx));
        }
        return new CallStatement(schemaName, packageName, routineName, argumentList);
    }
}

