/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang;

import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.PgqlVersion;

public class CheckInvalidJavaComment {
    public static void checkInvalidJavaComment(String queryString, PgqlVersion pgqlVersion) throws PgqlException {
        if (pgqlVersion != PgqlVersion.V_1_0 && pgqlVersion != PgqlVersion.V_1_1_OR_V_1_2) {
            char[] chars = queryString.toCharArray();
            int i = 0;
            block0: while (i < chars.length) {
                if (CheckInvalidJavaComment.isDoubleQuote(chars, i)) {
                    ++i;
                    while (i < chars.length) {
                        if (CheckInvalidJavaComment.isEscapedDoubleQuote(chars, i)) {
                            i += 2;
                            continue;
                        }
                        if (CheckInvalidJavaComment.isDoubleQuote(chars, i)) {
                            ++i;
                            continue block0;
                        }
                        ++i;
                    }
                    continue;
                }
                if (CheckInvalidJavaComment.isSingleQuote(chars, i)) {
                    ++i;
                    while (i < chars.length) {
                        if (CheckInvalidJavaComment.isEscapedSingleQuote(chars, i)) {
                            i += 2;
                            continue;
                        }
                        if (CheckInvalidJavaComment.isSingleQuote(chars, i)) {
                            ++i;
                            continue block0;
                        }
                        ++i;
                    }
                    continue;
                }
                if (CheckInvalidJavaComment.isMultiLineCommentStart(chars, i)) {
                    i += 2;
                    while (i < chars.length) {
                        if (CheckInvalidJavaComment.isMultiLineCommentEnd(chars, i)) {
                            i += 2;
                            continue block0;
                        }
                        ++i;
                    }
                    continue;
                }
                if (CheckInvalidJavaComment.isSingleLineCommentStart(chars, i)) {
                    throw new PgqlException("Use /* .. */ instead of // .. to introduce a comment");
                }
                ++i;
            }
        }
    }

    private static boolean isDoubleQuote(char[] chars, int index) {
        return CheckInvalidJavaComment.isCharAtIndex(chars, index, '\"');
    }

    private static boolean isEscapedDoubleQuote(char[] chars, int index) {
        return CheckInvalidJavaComment.areCharsAtIndex(chars, index, '\"', '\"');
    }

    private static boolean isSingleQuote(char[] chars, int index) {
        return CheckInvalidJavaComment.isCharAtIndex(chars, index, '\'');
    }

    private static boolean isEscapedSingleQuote(char[] chars, int index) {
        return CheckInvalidJavaComment.areCharsAtIndex(chars, index, '\'', '\'');
    }

    private static boolean isMultiLineCommentStart(char[] chars, int index) {
        return CheckInvalidJavaComment.areCharsAtIndex(chars, index, '/', '*');
    }

    private static boolean isMultiLineCommentEnd(char[] chars, int index) {
        return CheckInvalidJavaComment.areCharsAtIndex(chars, index, '*', '/');
    }

    private static boolean isSingleLineCommentStart(char[] chars, int index) {
        return CheckInvalidJavaComment.areCharsAtIndex(chars, index, '/', '/');
    }

    private static boolean isCharAtIndex(char[] chars, int index, char c) {
        if (index >= chars.length) {
            return false;
        }
        return chars[index] == c;
    }

    private static boolean areCharsAtIndex(char[] chars, int index, char c1, char c2) {
        if (index + 1 >= chars.length) {
            return false;
        }
        return chars[index] == c1 && chars[index + 1] == c2;
    }
}

