/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.driver;

import java.util.Map;
import java.util.Properties;
import oracle.pgx.api.Pgx;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.config.ClientConfig;
import oracle.pgx.graphviz.driver.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PgxServerInstanceProvider {
    default public ServerInstance connect(Map<String, Object> properties) {
        Logger log = LoggerFactory.getLogger(PgxServerInstanceProvider.class);
        ClientConfig clientConfig = ClientConfig.parse((Properties)Util.createPropertiesFromMap(properties), (boolean)true);
        String baseUrl = clientConfig.getBaseUrl();
        if (baseUrl != null && (baseUrl.equalsIgnoreCase("null") || baseUrl.equalsIgnoreCase("local") || baseUrl.equalsIgnoreCase("embedded"))) {
            log.info("base url set to {} - will use embedded mode", (Object)baseUrl);
            clientConfig.getValues().put(ClientConfig.Field.BASE_URL, Pgx.EMBEDDED_URL);
        }
        return Pgx.getInstance((ClientConfig)clientConfig);
    }

    default public void reset(Map<String, Object> properties) {
    }
}

