/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.vfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import oracle.pgx.common.AbstractPlugin;
import oracle.pgx.common.UserContext;
import oracle.pgx.vfs.CommonsVfsVirtualFile;
import oracle.pgx.vfs.VirtualFile;
import oracle.pgx.vfs.VirtualFileProvider;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.DefaultFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.bzip2.Bzip2FileProvider;
import org.apache.commons.vfs2.provider.ftps.FtpsFileProvider;
import org.apache.commons.vfs2.provider.gzip.GzipFileProvider;
import org.apache.commons.vfs2.provider.jar.JarFileProvider;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;
import org.apache.commons.vfs2.provider.tar.Tbz2FileProvider;
import org.apache.commons.vfs2.provider.tar.TgzFileProvider;
import org.apache.commons.vfs2.provider.temp.TemporaryFileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsVfsProvider
extends AbstractPlugin
implements VirtualFileProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CommonsVfsProvider.class);
    public static final String FTPS_SCHEME = "ftps";
    public static final String FILE_SCHEME = "file";
    public static final String TMP_SCHEME = "tmp";
    public static final String RAM_SCHEME = "ram";
    public static final String ZIP_SCHEME = "zip";
    public static final String JAR_SCHEME = "jar";
    public static final String TAR_SCHEME = "tar";
    public static final String TGZ_SCHEME = "tgz";
    public static final String TBZ2_SCHEME = "tbz2";
    public static final String GZ_SCHEME = "gz";
    public static final String BZ2_SCHEME = "bz2";
    public static final DefaultFileSystemManager FSM = CommonsVfsProvider.getFileSystemManager();
    private static final Set<String> SCHEMES_NOT_REQUIRING_WHITE_LISTING = Collections.singleton("ftps");

    private static DefaultFileSystemManager getFileSystemManager() {
        try {
            DefaultFileSystemManager manager = new DefaultFileSystemManager();
            manager.setFilesCache((FilesCache)new DefaultFilesCache());
            manager.setCacheStrategy(CacheStrategy.ON_RESOLVE);
            DefaultLocalFileProvider provider = new DefaultLocalFileProvider();
            manager.addProvider(FILE_SCHEME, (FileProvider)provider);
            manager.setDefaultProvider((FileProvider)provider);
            manager.addProvider(TMP_SCHEME, (FileProvider)new TemporaryFileProvider());
            manager.addProvider(RAM_SCHEME, (FileProvider)new RamFileProvider());
            manager.addProvider(ZIP_SCHEME, (FileProvider)new ZipFileProvider());
            manager.addProvider(JAR_SCHEME, (FileProvider)new JarFileProvider());
            manager.addProvider(TAR_SCHEME, (FileProvider)new TarFileProvider());
            manager.addProvider(TGZ_SCHEME, (FileProvider)new TgzFileProvider());
            manager.addProvider(TBZ2_SCHEME, (FileProvider)new Tbz2FileProvider());
            manager.addProvider(GZ_SCHEME, (FileProvider)new GzipFileProvider());
            manager.addProvider(BZ2_SCHEME, (FileProvider)new Bzip2FileProvider());
            manager.addProvider(FTPS_SCHEME, (FileProvider)new FtpsFileProvider());
            manager.setBaseFile(manager.resolveFile(System.getProperty("user.dir")));
            manager.init();
            return manager;
        }
        catch (FileSystemException e) {
            throw new IllegalStateException("could not initialize commons-vfs file system manager", e);
        }
    }

    @Override
    public boolean schemePerformsNetworkCommunications(String scheme) {
        return Objects.equals(FTPS_SCHEME, scheme);
    }

    @Override
    public boolean schemeRequiresDirectoryWhiteListing(String scheme) {
        return !SCHEMES_NOT_REQUIRING_WHITE_LISTING.contains(scheme);
    }

    @Override
    public boolean schemePerformsInsecureRemoteLoading(String scheme) {
        return Objects.equals(FTPS_SCHEME, scheme);
    }

    @Override
    public List<String> getSchemes() {
        return Arrays.asList(FSM.getSchemes());
    }

    @Override
    public VirtualFile resolve(String path, Map<String, String> attributes, UserContext userContext) throws IOException {
        if (LOG.isWarnEnabled() && attributes != null && !attributes.isEmpty()) {
            LOG.warn("ignoring unsupported attributes: {}", attributes);
        }
        LOG.debug("resolve {}", (Object)path);
        return new CommonsVfsVirtualFile(FSM.resolveFile(path));
    }

    @Override
    public VirtualFile resolve(String parent, String relative, UserContext userContext) throws IOException {
        LOG.debug("resolve {}", (Object)parent);
        FileObject parentFileObject = FSM.resolveFile(parent);
        return new CommonsVfsVirtualFile(FSM.resolveFile(parentFileObject, relative));
    }
}

