/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.vfs;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.vfs.VirtualFile;

public abstract class AbstractUriVirtualFile
implements VirtualFile {
    protected final URI uri;

    private static URI toUri(String path) throws IOException {
        try {
            return new URI(path);
        }
        catch (URISyntaxException e) {
            throw new IOException(ErrorMessages.getMessage("INVALID_URI_SYNTAX", path), e);
        }
    }

    AbstractUriVirtualFile(String path) throws IOException {
        this.uri = AbstractUriVirtualFile.toUri(path);
    }

    AbstractUriVirtualFile(String parent, String relative) throws IOException {
        this.uri = AbstractUriVirtualFile.toUri(parent).resolve(relative);
    }

    protected abstract RuntimeException readOnlyException();

    @Override
    public String getParent() throws IOException {
        URI resolved = this.uri.getPath().endsWith("/") ? this.uri.resolve("..") : this.uri.resolve(".");
        return resolved.toString();
    }

    @Override
    public String getPath() throws IOException {
        return this.uri.toString();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw this.readOnlyException();
    }

    @Override
    public void createFile() throws IOException {
        throw this.readOnlyException();
    }
}

