/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

class SemanticVersion {
    private final int major;
    private final int minor;
    private final int patch;

    static SemanticVersion tryParse(String version) {
        if (version == null || !version.matches("^[0-9]+(\\.[0-9]+){2}$")) {
            return null;
        }
        String[] split = version.split("\\.");
        return new SemanticVersion(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
    }

    SemanticVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    int getMajorVersion() {
        return this.major;
    }

    int getMinorVersion() {
        return this.minor;
    }

    int getPatchVersion() {
        return this.patch;
    }
}

