/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.ServiceLoader;
import oracle.pgx.common.Plugin;
import oracle.pgx.common.util.Versions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plugins {
    private static final Logger LOG = LoggerFactory.getLogger(Plugins.class);

    public static synchronized <P extends Plugin> ServiceLoader<P> loadPlugins(Class<P> pluginClass, String expectedVersion, OnVersionMismatch<P> onVersionMismatch, boolean checkPluginVersion) {
        LOG.debug("loading implementations of plugin {}", pluginClass);
        ServiceLoader<Plugin> plugins = ServiceLoader.load(pluginClass);
        for (Plugin plugin : plugins) {
            LOG.debug("checking if plugin {} is compatible", (Object)plugin);
            if (Versions.isCompatible(plugin.getVersion(), expectedVersion, checkPluginVersion)) continue;
            onVersionMismatch.apply(plugin);
        }
        return plugins;
    }

    public static <P extends Plugin> ServiceLoader<P> loadPlugins(Class<P> pluginClass) {
        return Plugins.loadPlugins(pluginClass, null, ignore -> {}, false);
    }

    public static interface OnVersionMismatch<P extends Plugin> {
        public void apply(P var1);
    }
}

