/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.types;

import java.util.Map;
import oracle.pgx.common.types.Type;
import oracle.pgx.common.util.ErrorMessages;

public class Types {
    static <T extends Type> T getByTypeClass(T[] types, Class<?> typeClass) {
        for (T t : types) {
            if (t.getTypeClass() != typeClass) continue;
            return t;
        }
        throw new IllegalArgumentException("type class " + typeClass + " not found");
    }

    public static <T extends Enum<T>> T parse(Class<T> enumType, String input, Map<String, T> aliases) {
        Enum type;
        assert (enumType != null);
        if (input == null) {
            return null;
        }
        input = input.toUpperCase().trim();
        if (aliases != null && (type = (Enum)aliases.get(input)) != null) {
            return (T)type;
        }
        try {
            return Enum.valueOf(enumType, input);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("INVALID_TYPE", enumType.getCanonicalName()));
        }
    }
}

