/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pgx.common.auth.PgxRole;
import oracle.pgx.common.auth.PgxUser;

public interface UserContext {
    public static final UserContext SYSTEM_USER_CONTEXT = () -> new PgxUser(null);
    public static final UserContext UNAUTHENTICATED_USER_CONTEXT = () -> PgxUser.UNAUTHENTICATED_USER;

    public PgxUser getUser();

    default public String getUserName() {
        PgxUser user = this.getUser();
        if (user == null) {
            return null;
        }
        return user.getName();
    }

    default public Set<String> getRolesNames() {
        PgxUser user = this.getUser();
        if (user == null) {
            return Collections.emptySet();
        }
        return user.getRoles().stream().map(PgxRole::getName).collect(Collectors.toSet());
    }
}

