/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.net.URI;
import java.util.Map;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;
import oracle.pgx.common.types.OracleMediaType;

public class RequestProperties {
    private final OracleMediaType mediaType;
    private final Link.Method method;
    private final Map<LinkRel, URI> links;
    private Boolean isAction;
    private Boolean isProxyRequest = false;
    private boolean isPrimitiveRequest = false;

    public RequestProperties(OracleMediaType mediaType, String method, Map<LinkRel, URI> links) {
        this.mediaType = mediaType;
        this.method = Link.Method.valueOf(method);
        this.links = links;
        this.isAction = false;
    }

    public RequestProperties(OracleMediaType mediaType, String method, Map<LinkRel, URI> links, boolean isAction) {
        this.mediaType = mediaType;
        this.method = Link.Method.valueOf(method);
        this.links = links;
        this.isAction = isAction;
    }

    public Boolean isAction() {
        return this.isAction;
    }

    public OracleMediaType getMediaType() {
        return this.mediaType;
    }

    public Link.Method getMethod() {
        return this.method;
    }

    public Map<LinkRel, URI> getLinks() {
        return this.links;
    }

    public Boolean isProxyRequest() {
        return this.isProxyRequest;
    }

    public void setProxyRequest(Boolean proxyRequest) {
        this.isProxyRequest = proxyRequest;
    }

    public boolean isPrimitiveRequest() {
        return this.isPrimitiveRequest;
    }

    public void setPrimitiveRequest(boolean primitiveRequest) {
        this.isPrimitiveRequest = primitiveRequest;
    }

    public void setAction(Boolean action) {
        this.isAction = action;
    }
}

