/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.util.Collections;
import java.util.EnumSet;

public class IllegalEnumConstantException
extends IllegalArgumentException {
    private final Enum<?> enumConstant;
    private final EnumSet allowedEnumConstants;

    public IllegalEnumConstantException(Enum<?> enumConstant) {
        this(enumConstant, new Enum[0]);
    }

    private IllegalEnumConstantException(Enum<?> enumConstant, Enum ... allowedEnumConstants) {
        this.enumConstant = enumConstant;
        if (allowedEnumConstants.length > 0) {
            this.allowedEnumConstants = EnumSet.noneOf(enumConstant.getClass());
            Collections.addAll(this.allowedEnumConstants, allowedEnumConstants);
        } else {
            this.allowedEnumConstants = EnumSet.noneOf(enumConstant.getClass());
        }
    }

    @SafeVarargs
    public static <T extends Enum<T>> IllegalEnumConstantException create(T enumConstant, T ... allowedEnumConstants) {
        return new IllegalEnumConstantException(enumConstant, (Enum[])allowedEnumConstants);
    }

    @Override
    public String getMessage() {
        String expectedString = this.allowedEnumConstants.isEmpty() ? "" : " Expected one of: " + this.allowedEnumConstants;
        return "Unexpected enum constant: " + this.enumConstant + expectedString;
    }
}

