/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.TableExpressionType;
import oracle.pgql.lang.ir.VertexPairConnection;

class SubqueryInfo {
    public Map<String, Pair<Boolean, QueryVariable>> parentVariables;
    public Map<String, Pair<Boolean, QueryVariable>> variables;
    public Map<String, Pair<Boolean, QueryVariable>> selectAliases;
    public Map<String, Pair<Boolean, QueryVariable>> parentGroupByVariables;
    public Map<String, Pair<Boolean, QueryVariable>> groupByVariables;
    public Set<VertexPairConnection> parentConnections;
    public Set<VertexPairConnection> connections;
    public boolean forParentWhere;
    public Map<QueryVariable, String> parentConf;
    public List<Constraints> extraConstraints;
    public boolean insideAggregate;

    public SubqueryInfo(Map<String, Pair<Boolean, QueryVariable>> parentVariables, Map<String, Pair<Boolean, QueryVariable>> parentGroupByVariables, Set<VertexPairConnection> parentConnections, boolean forParentWhere, Map<QueryVariable, String> parentConf, boolean insideAggregate) {
        this.parentVariables = parentVariables;
        this.parentGroupByVariables = parentGroupByVariables;
        this.parentConnections = parentConnections;
        this.forParentWhere = forParentWhere;
        this.parentConf = parentConf;
        this.extraConstraints = null;
        this.insideAggregate = insideAggregate;
        this.variables = new HashMap<String, Pair<Boolean, QueryVariable>>();
        this.selectAliases = new HashMap<String, Pair<Boolean, QueryVariable>>();
        this.groupByVariables = null;
        this.connections = new HashSet<VertexPairConnection>();
    }

    public boolean isGroupByVariable(String variable) {
        if (this.groupByVariables == null) {
            return false;
        }
        return this.groupByVariables.containsKey(variable);
    }

    public static class GPConstraints
    implements Constraints {
        public Set<QueryExpression> extraConstraints;

        public GPConstraints(Set<QueryExpression> extraConstraints) {
            this.extraConstraints = extraConstraints;
        }

        @Override
        public TableExpressionType getConstraintsType() {
            return TableExpressionType.GRAPH_PATTERN;
        }
    }

    public static class DTConstraints
    implements Constraints {
        public List<Constraints> extraConstraints;

        public DTConstraints(List<Constraints> extraConstraints) {
            this.extraConstraints = extraConstraints;
        }

        @Override
        public TableExpressionType getConstraintsType() {
            return TableExpressionType.DERIVED_TABLE;
        }
    }

    public static interface Constraints {
        public TableExpressionType getConstraintsType();
    }
}

