/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.sqlpgq;

import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.sqlpgq.EdgeTable;
import oracle.pg.rdbms.sqlpgq.SqlPgqMetadata;
import oracle.pg.rdbms.sqlpgq.SqlPgqProperty;
import oracle.pg.rdbms.sqlpgq.VertexTable;
import oracle.pgql.lang.ir.PgqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SqlPgqQueryGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SqlPgqQueryGenerator.class);

    SqlPgqQueryGenerator() {
    }

    public static String generateCreateViewStatement(SqlPgqMetadata metadata) {
        StringBuilder sb = new StringBuilder();
        return sb.append("CREATE VIEW ").append(PgqlUtils.printIdentifier((String)metadata.getViewName())).append(" AS ").append(metadata.getOriginalQuery()).toString();
    }

    public static String generateCreateMaterializedView(SqlPgqMetadata metadata) {
        StringBuilder sb = new StringBuilder();
        return sb.append("CREATE MATERIALIZED VIEW ").append(PgqlUtils.printIdentifier((String)metadata.getMaterializedViewName())).append(" AS ").append("SELECT * FROM ").append(PgqlUtils.printIdentifier((String)metadata.getViewName())).toString();
    }

    public static String generateSelectQueryAgainstOriginalResultSet(SqlPgqMetadata metadata) {
        StringBuilder sb = new StringBuilder();
        return sb.append("SELECT * FROM ").append(PgqlUtils.printIdentifier((String)metadata.getMaterializedViewName())).append(" FETCH FIRST ROW ONLY ").toString();
    }

    public static String generateCheckIfMaterializedViewExists(SqlPgqMetadata metadata) {
        return String.format("SELECT COUNT(*) FROM ALL_OBJECTS WHERE OBJECT_TYPE = 'MATERIALIZED VIEW' AND OBJECT_NAME = '%s'", PgqlUtils.printIdentifier((String)metadata.getMaterializedViewName()));
    }

    public static String generateCountQuery(SqlPgqMetadata metadata) {
        return "SELECT COUNT(*) FROM " + PgqlUtils.printIdentifier((String)metadata.getMaterializedViewName());
    }

    public static String dropView(SqlPgqMetadata metadata) {
        return "DROP VIEW " + PgqlUtils.printIdentifier((String)metadata.getViewName());
    }

    public static String dropMaterializedView(SqlPgqMetadata metadata) {
        return "DROP MATERIALIZED VIEW " + PgqlUtils.printIdentifier((String)metadata.getMaterializedViewName());
    }

    private static void addVertexPropertiesAndLabelToQuery(String vertexName, String materializedViewName, StringBuilder sb, Set<SqlPgqProperty> propertiesPerTableName, Set<String> allVertexProperties, Set<String> columnIds, String label) {
        for (String property : allVertexProperties) {
            LOG.debug("Vertex query generation, property {}", (Object)property);
            SqlPgqProperty sqlPgqProperty = propertiesPerTableName.stream().filter(p -> p.getPropertyName().equals(property)).findAny().orElse(null);
            if (sqlPgqProperty != null) {
                sb.append(sqlPgqProperty.toString()).append(", ");
                continue;
            }
            if (columnIds.contains(property)) {
                sb.append(" x.").append(PgqlUtils.printIdentifier((String)property)).append(", ");
                continue;
            }
            sb.append(" NULL AS ").append(PgqlUtils.printIdentifier((String)property)).append(",");
        }
        sb.append(" '").append(PgqlUtils.printIdentifier((String)label)).append("' AS label");
    }

    private static void addVertexFromClauseToQuery(StringBuilder sb, Set<String> columnIds, String materializedViewName, String vertexName, String tableName, String tableAlias) {
        sb.append(" FROM ").append(PgqlUtils.printIdentifier((String)materializedViewName)).append(", ").append(PgqlUtils.printIdentifier((String)tableName)).append(" x WHERE TO_CHAR(JSON_VALUE(").append(PgqlUtils.printIdentifier((String)materializedViewName)).append(".").append(PgqlUtils.printIdentifier((String)vertexName)).append(", '$.ELEM_TABLE')) = '").append(tableAlias).append("' ");
        boolean firstColumn = true;
        for (String columnId : columnIds) {
            if (firstColumn) {
                sb.append(" AND ");
                firstColumn = false;
            } else {
                sb.append(" OR ");
            }
            sb.append(" TO_CHAR(x.").append(PgqlUtils.printIdentifier((String)columnId)).append(") = TO_CHAR(JSON_VALUE(").append(PgqlUtils.printIdentifier((String)materializedViewName)).append(".").append(PgqlUtils.printIdentifier((String)vertexName)).append(", '$.KEY_VALUE.").append(PgqlUtils.printIdentifier((String)columnId)).append("')) ");
        }
    }

    private static void addEdgePropertiesAndLabelToQuery(String edgeName, String materializedViewName, StringBuilder sb, Set<String> propertiesPerTableName, Set<String> allVertexProperties, String label) {
        sb.append(PgqlUtils.printIdentifier((String)materializedViewName)).append(".").append(PgqlUtils.printIdentifier((String)edgeName)).append(" ");
        for (String property : allVertexProperties) {
            LOG.debug("Edge query generation, property {}", (Object)property);
            if (propertiesPerTableName.contains(property)) {
                sb.append(", x.").append(PgqlUtils.printIdentifier((String)property));
                continue;
            }
            sb.append(", NULL AS ").append(PgqlUtils.printIdentifier((String)property));
        }
        sb.append(", '").append(PgqlUtils.printIdentifier((String)label)).append("' AS label");
    }

    public static String generateVertexQuery(String vertexName, SqlPgqMetadata metadata) {
        LOG.debug("Query generation for vertex name {}", (Object)vertexName);
        String materializedViewName = metadata.getMaterializedViewName();
        StringBuilder vertexQuery = new StringBuilder("SELECT /*+ NO_JSON_TABLE_TRANSFORM */ * FROM ( SELECT ");
        Set<String> allVertexProperties = metadata.getAllVertexProperties();
        Map<String, VertexTable> vertexTables = metadata.getVertexTables();
        int index = 0;
        int size = vertexTables.size();
        for (Map.Entry<String, VertexTable> entry : vertexTables.entrySet()) {
            Set<String> ids = entry.getValue().getColumnIds();
            String tableName = entry.getKey();
            String tableAlias = entry.getValue().getTableAlias();
            String labelName = entry.getValue().getLabelName();
            LOG.debug("Vertex query generation, label {}", (Object)labelName);
            Set<String> columnIds = entry.getValue().getColumnIds();
            Set<SqlPgqProperty> propertiesPerTableName = entry.getValue().getProperties();
            SqlPgqQueryGenerator.addVertexPropertiesAndLabelToQuery(vertexName, materializedViewName, vertexQuery, propertiesPerTableName, allVertexProperties, ids, labelName);
            vertexQuery.append(", '").append(labelName).append("(");
            int i = 0;
            for (String columnId : columnIds) {
                vertexQuery.append(columnId).append("(' || TO_CHAR(").append("x.").append(columnId).append(") || ')");
                if (++i == columnIds.size()) continue;
                vertexQuery.append(",");
            }
            vertexQuery.append(")' AS ").append(PgqlUtils.printIdentifier((String)vertexName));
            SqlPgqQueryGenerator.addVertexFromClauseToQuery(vertexQuery, ids, materializedViewName, vertexName, tableName, tableAlias);
            if (++index == size) continue;
            vertexQuery.append("UNION ALL SELECT ");
        }
        return vertexQuery.append(")").toString();
    }

    public static String generateEdgeQuery(String edgeName, SqlPgqMetadata metadata) {
        LOG.debug("Query generation for edge name {}", (Object)edgeName);
        Set<String> allEdgeProperties = metadata.getAllEdgeProperties();
        String materializedViewName = metadata.getMaterializedViewName();
        Map<String, EdgeTable> edgeTables = metadata.getEdgeTables();
        Map<String, VertexTable> vertexTables = metadata.getVertexTables();
        StringBuilder edgeQuery = new StringBuilder("SELECT /*+ NO_JSON_TABLE_TRANSFORM */ * FROM ( SELECT ");
        int index = 0;
        int size = edgeTables.size();
        for (Map.Entry<String, EdgeTable> entry : edgeTables.entrySet()) {
            Set<String> propertiesPerTableName = entry.getValue().getProperties();
            VertexTable sourceVertexTable = vertexTables.get(entry.getValue().getVertexSourceTable());
            VertexTable destinationVertexTable = vertexTables.get(entry.getValue().getVertexDestinationTable());
            Set<String> sourceVertexColumnIds = sourceVertexTable.getColumnIds();
            Set<String> destinationVertexColumnIds = destinationVertexTable.getColumnIds();
            SqlPgqQueryGenerator.addEdgePropertiesAndLabelToQuery(edgeName, materializedViewName, edgeQuery, propertiesPerTableName, allEdgeProperties, entry.getValue().getLabelName());
            edgeQuery.append(", '").append(sourceVertexTable.getLabelName()).append("(");
            int i = 0;
            LOG.debug("adding source columns");
            for (String columnId : sourceVertexColumnIds) {
                LOG.debug("{}", (Object)columnId);
                edgeQuery.append(columnId).append("(' || TO_CHAR(").append("src.").append(columnId).append(") || ')");
                if (++i == sourceVertexColumnIds.size()) continue;
                edgeQuery.append(",");
            }
            edgeQuery.append(")' AS srcid");
            edgeQuery.append(", '").append(destinationVertexTable.getLabelName()).append("(");
            i = 0;
            for (String columnId : destinationVertexColumnIds) {
                edgeQuery.append(columnId).append("(' || TO_CHAR(").append("dst.").append(columnId).append(") || ')");
                if (++i == destinationVertexColumnIds.size()) continue;
                edgeQuery.append(",");
            }
            edgeQuery.append(")' AS dstid");
            edgeQuery.append(" FROM ").append(PgqlUtils.printIdentifier((String)materializedViewName)).append(", ").append(PgqlUtils.printIdentifier((String)entry.getValue().getTableName())).append(" x, ").append(PgqlUtils.printIdentifier((String)entry.getValue().getVertexSourceTable())).append(" src, ").append(PgqlUtils.printIdentifier((String)entry.getValue().getVertexDestinationTable())).append(" dst WHERE TO_CHAR(JSON_VALUE(").append(PgqlUtils.printIdentifier((String)materializedViewName)).append(".").append(PgqlUtils.printIdentifier((String)edgeName)).append(", '$.ELEM_TABLE')) = '").append(entry.getKey()).append("'");
            boolean firstColumn = true;
            for (String columnId : entry.getValue().getColumnIds()) {
                if (firstColumn) {
                    edgeQuery.append(" AND ");
                    firstColumn = false;
                } else {
                    edgeQuery.append(" OR ");
                }
                edgeQuery.append(" TO_CHAR(x.").append(PgqlUtils.printIdentifier((String)columnId)).append(") = TO_CHAR(JSON_VALUE(").append(PgqlUtils.printIdentifier((String)materializedViewName)).append(".").append(PgqlUtils.printIdentifier((String)edgeName)).append(", '$.KEY_VALUE.").append(PgqlUtils.printIdentifier((String)columnId)).append("'))");
            }
            edgeQuery.append(" AND TO_CHAR(x.").append(PgqlUtils.printIdentifier((String)entry.getValue().getEdgeColumnNameSource())).append(") = TO_CHAR(src.").append(PgqlUtils.printIdentifier((String)entry.getValue().getVertexSourceId())).append(") AND TO_CHAR(x.").append(PgqlUtils.printIdentifier((String)entry.getValue().getEdgeColumnNameDestination())).append(") = TO_CHAR(dst.").append(PgqlUtils.printIdentifier((String)entry.getValue().getVertexDestinationId())).append(")");
            if (++index == size) continue;
            edgeQuery.append(" UNION ALL SELECT ");
        }
        return edgeQuery.append(")").toString();
    }
}

