/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.net.URI;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import javax.ws.rs.core.Response;
import oracle.graphviz.pgql.AbstractPgqlDriver;
import oracle.pg.rdbms.RdbmsLoginHelper;
import oracle.ucp.UniversalConnectionPoolException;

public abstract class RdbmsDriver
extends AbstractPgqlDriver {
    private static final String JDBC_URL = "graphviz.driver.rdbms.jdbc_url";
    public static final String CONNECTION_POOL_ID = "connection-pool-id";
    public static final String USERNAME_ATTRIBUTE = "username";
    public static final String DATASOURCE_ATTRIBUTE = "datasource";
    public static final String DYNAMIC_SAMPLING_ATTRIBUTE = "dynamic-sampling";
    public static final String TIME_OUT_ATTRIBUTE = "timeout";
    public static final String KERBEROS_TICKET_PATH = "kerberos-ticket-path";
    public static final String DRIVER_SESSION_ATTRIBUTE = "driver-session-id";
    private final RdbmsLoginHelper loginHelper;

    public RdbmsDriver(Map<String, Object> properties) {
        super(properties);
        this.loginHelper = new RdbmsLoginHelper(properties);
    }

    public Response login(HttpServletRequest request, Map<String, Object> staticProperties, String username, String password, String sessionId) throws LoginException {
        DataSource dataSource = null;
        Map<String, Object> properties = staticProperties;
        String poolName = null;
        String ticketPath = null;
        String jdbcUrl = (String)properties.get(JDBC_URL);
        try (Connection conn = this.loginHelper.connect(jdbcUrl, username, password, properties);){
            dataSource = this.loginHelper.createDataSource(jdbcUrl, username, password, properties);
            poolName = (String)properties.get(CONNECTION_POOL_ID);
            ticketPath = (String)properties.get(KERBEROS_TICKET_PATH);
            properties.put(DATASOURCE_ATTRIBUTE, dataSource);
        }
        catch (SQLException ex) {
            LOG.error("Login failed for username: {}, exception message = {}", (Object)username, (Object)ex.getMessage());
            String errorMessage = this.loginHelper.manageSqlException(ex.getErrorCode());
            throw new LoginException(errorMessage);
        }
        catch (UniversalConnectionPoolException ex) {
            LOG.error("Login failed for username: {}, exception message = {}", (Object)username, (Object)ex.getMessage());
            String errorMessage = this.loginHelper.manageSqlException(ex.getErrorCode());
            throw new LoginException(errorMessage);
        }
        catch (IllegalArgumentException ex) {
            LOG.error("Login failed for username: {}, exception message = {}", (Object)username, (Object)ex.getMessage());
            throw new LoginException(ex.getMessage());
        }
        String rdbmsId = this.createSession(RdbmsDriver.class.getName(), properties);
        HttpSession session = request.getSession();
        session.setAttribute(USERNAME_ATTRIBUTE, (Object)username);
        session.setAttribute(DATASOURCE_ATTRIBUTE, (Object)dataSource);
        session.setAttribute(DRIVER_SESSION_ATTRIBUTE, (Object)rdbmsId);
        session.setAttribute(CONNECTION_POOL_ID, (Object)poolName);
        session.setAttribute("provided-externally", (Object)false);
        if (ticketPath != null) {
            session.setAttribute(KERBEROS_TICKET_PATH, (Object)ticketPath);
        }
        String queryParams = request.getQueryString();
        String url = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/" + request.getContextPath();
        if (queryParams != null) {
            url = url + "?" + queryParams;
        }
        return Response.seeOther((URI)URI.create(url)).build();
    }

    private String getSessionId(Connection conn) throws SQLException {
        String sessionId = null;
        try (PreparedStatement ps = conn.prepareStatement("select sys_context('userenv', 'sid') from dual");
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                sessionId = rs.getString(1);
            }
        }
        return sessionId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createSession(String source, Map<String, Object> properties) {
        try {
            DataSource ods = (DataSource)properties.get(DATASOURCE_ATTRIBUTE);
            try (Connection conn = ods.getConnection();){
                String sessionId = this.getSessionId(conn);
                LOG.debug("create session: returning JDBC session ID = {}", (Object)sessionId);
                String string = sessionId;
                return string;
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("createSession failed", e);
        }
    }

    public String getVersion(Map<String, Object> properties) throws SQLException {
        DataSource ods = (DataSource)properties.get(DATASOURCE_ATTRIBUTE);
        try (Connection conn = ods.getConnection();){
            DatabaseMetaData metaData = conn.getMetaData();
            String string = String.valueOf(metaData.getDatabaseMajorVersion() + "." + metaData.getDatabaseMinorVersion());
            return string;
        }
    }

    public void destroySession(String id, Map<String, Object> properties) throws LoginException, SQLException {
        this.loginHelper.removeExistingConnectionPool(properties);
    }
}

