/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library.watcher;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.pgx.graphviz.library.watcher.DelayCancellable;
import oracle.pgx.graphviz.library.watcher.Watchdog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WatchdogManager
implements Thread.UncaughtExceptionHandler {
    private final AtomicBoolean started = new AtomicBoolean();
    private final DelayQueue<DelayCancellable> interruptQueue = new DelayQueue();
    private final Canceller canceller = new Canceller(this.interruptQueue);
    private final Set<Integer> lessees = new CopyOnWriteArraySet<Integer>();
    private static final Logger LOG = LoggerFactory.getLogger(WatchdogManager.class);
    private static final WatchdogManager INSTANCE = new WatchdogManager();

    WatchdogManager() {
    }

    public static <T> Watchdog<T> lease(Object lessee) {
        return INSTANCE.doLease(lessee);
    }

    public static <T> void cancelLease(Watchdog<?> watchdog) {
        INSTANCE.doCancelLease(watchdog);
    }

    synchronized <T> Watchdog<T> doLease(Object lessee) {
        int owner = System.identityHashCode(lessee);
        this.lessees.add(owner);
        return new Watchdog(this, owner);
    }

    private synchronized void doCancelLease(Watchdog<?> watchdog) {
        if (this.lessees.remove(watchdog.owner()) && this.lessees.isEmpty()) {
            LOG.info("Last interpreter closed, stopping watchdog thread.");
            this.canceller.shutdown();
            this.started.set(false);
        }
    }

    private synchronized void startWatchdogThread() {
        this.canceller.reset();
        Thread poller = new Thread((Runnable)this.canceller, "PGX interpreter watchdog thread");
        poller.setDaemon(true);
        poller.setPriority(2);
        poller.setUncaughtExceptionHandler(this);
        poller.start();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        LOG.error("Uncaught exception in " + t.getName(), e);
    }

    void enqueue(DelayCancellable cancellable) {
        if (this.started.compareAndSet(false, true)) {
            this.startWatchdogThread();
        }
        this.interruptQueue.offer(cancellable);
    }

    void dequeue(DelayCancellable cancellable) {
        this.interruptQueue.remove(cancellable);
    }

    private static final class Canceller
    implements Runnable {
        private volatile boolean cancelled;
        private Thread runnerThread;
        private final DelayQueue<DelayCancellable> interruptQueue;

        public Canceller(DelayQueue<DelayCancellable> interruptQueue) {
            this.interruptQueue = interruptQueue;
        }

        synchronized void reset() {
            this.cancelled = false;
            this.runnerThread = null;
        }

        synchronized void shutdown() {
            this.cancelled = true;
            if (this.runnerThread != null) {
                this.runnerThread.interrupt();
            }
        }

        boolean isStopped() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("Start {}", (Object)Thread.currentThread().getName());
            try {
                if (this.cancelled) {
                    return;
                }
                Canceller canceller = this;
                synchronized (canceller) {
                    this.runnerThread = Thread.currentThread();
                }
                do {
                    try {
                        DelayCancellable w = (DelayCancellable)this.interruptQueue.take();
                        if (w == null) continue;
                        w.timeout();
                    }
                    catch (InterruptedException ex) {
                        if (this.cancelled) continue;
                        LOG.warn("Spurious interrupt in watchdog thread", (Throwable)ex);
                    }
                } while (!this.cancelled);
                return;
            }
            finally {
                LOG.info("{} exit", (Object)Thread.currentThread().getName());
            }
        }
    }
}

