/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultAccess;
import oracle.pgql.lang.ResultSet;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.PgqlUtils;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgx.graphviz.formatter.Pair;
import oracle.pgx.graphviz.library.enhancer.Enhancement;
import oracle.pgx.graphviz.library.enhancer.EnhancerUtil;
import oracle.pgx.graphviz.library.enhancer.PropertyColumn;
import oracle.pgx.graphviz.library.graph.Edge;
import oracle.pgx.graphviz.library.graph.Entity;
import oracle.pgx.graphviz.library.graph.Graph;
import oracle.pgx.graphviz.library.graph.Path;
import oracle.pgx.graphviz.library.graph.Property;
import oracle.pgx.graphviz.library.graph.Vertex;

public class GraphBuilder {
    @Nonnull
    private final ResultSet rs;
    @Nonnull
    private final Enhancement enhancement;
    private final int start;
    private final int size;
    @Nonnull
    private final Map<String, Set<PropertyColumn>> propertyColumns;
    @Nonnull
    private final Set<oracle.pgx.graphviz.formatter.Path> paths = new HashSet<oracle.pgx.graphviz.formatter.Path>();
    @Nonnull
    private Collection<? extends oracle.pgx.graphviz.formatter.Vertex> vertices = Collections.emptySet();
    @Nonnull
    private Collection<? extends oracle.pgx.graphviz.formatter.Edge> edges = Collections.emptySet();
    private final boolean isDirectedSupported;

    public GraphBuilder(@Nonnull ResultSet rs, @Nonnull Enhancement enhancement, int start, int size, boolean isDirectedSupported) {
        this.rs = rs;
        this.enhancement = enhancement;
        this.start = start;
        this.size = size;
        this.isDirectedSupported = isDirectedSupported;
        this.propertyColumns = new LinkedHashMap<String, Set<PropertyColumn>>();
        this.fillPropertyColumns(enhancement);
    }

    private void fillPropertyColumns(Enhancement enhancement) {
        LinkedHashMap variableToBaseVertexOrEdge = new LinkedHashMap();
        enhancement.getProjection().stream().map(expAsVar -> PgqlUtils.getVariables((QueryExpression)expAsVar.getExp())).flatMap(Collection::stream).forEach(var -> {
            QueryVariable baseVariable = EnhancerUtil.recursivelyDereference(var);
            if (baseVariable.getVariableType() == QueryVariable.VariableType.VERTEX || baseVariable.getVariableType() == QueryVariable.VariableType.EDGE) {
                variableToBaseVertexOrEdge.put(var, baseVariable);
                this.propertyColumns.putIfAbsent(var.getName(), new LinkedHashSet());
            }
        });
        block0: for (PropertyColumn propertyColumn : enhancement.getPropertyColumns()) {
            QueryVariable baseVariable;
            Set variables = PgqlUtils.getVariables((QueryExpression)propertyColumn.getExpAsVar().getExp());
            if (variables.size() != 1 || (baseVariable = this.getBaseVariable((QueryVariable)variables.iterator().next())) == null) continue;
            for (Map.Entry entry : variableToBaseVertexOrEdge.entrySet()) {
                if (entry.getValue() != baseVariable) continue;
                String vertexOrEdgeName = ((QueryVariable)entry.getKey()).getName();
                this.propertyColumns.get(vertexOrEdgeName).add(propertyColumn);
                continue block0;
            }
        }
    }

    private QueryVariable getBaseVariable(QueryVariable variable) {
        QueryVariable.VariableType type = variable.getVariableType();
        switch (type) {
            case VERTEX: 
            case EDGE: {
                return variable;
            }
            case EXP_AS_VAR: {
                ExpAsVar expAsVar = (ExpAsVar)variable;
                Set variables = PgqlUtils.getVariables((QueryExpression)expAsVar.getExp());
                if (variables.size() == 1) {
                    return this.getBaseVariable((QueryVariable)variables.iterator().next());
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected variable type: " + type);
    }

    @Nonnull
    public oracle.pgx.graphviz.formatter.Graph buildGraph() throws ExecutionException {
        this.buildEdges();
        this.buildVertices();
        this.buildPaths();
        return new Graph(this.vertices, this.edges, this.paths);
    }

    private void buildEdges() throws ExecutionException {
        this.edges = this.extractWithCache(EnhancerUtil.getVariableProjectionsOfVarType(false, true, this.enhancement.getProjection()).collect(Collectors.toSet()), this::createEdge);
    }

    private void buildVertices() throws ExecutionException {
        this.vertices = this.extractWithCache(EnhancerUtil.getVariableProjectionsOfVarType(true, false, this.enhancement.getProjection()).collect(Collectors.toSet()), this::createVertex);
    }

    private void buildPaths() throws ExecutionException {
        if (!this.enhancement.getSupportsOneRowPerStep()) {
            this.iterateOverCells(this.enhancement.getPaths().filter(p -> !p.getSrc().isAnonymous()).filter(p -> !p.getDst().isAnonymous()).map(p -> new Pair((Object)p.getSrc().getName(), (Object)p.getDst().getName())).collect(Collectors.toSet()), (row, col) -> {
                String srcIdColumn = this.enhancement.getIdColumn((String)col.getFirst());
                String dstIdColumn = this.enhancement.getIdColumn((String)col.getSecond());
                if (srcIdColumn != null && dstIdColumn != null) {
                    Object src = row.getObject(srcIdColumn);
                    Object dst = row.getObject(dstIdColumn);
                    this.paths.add(new Path(src, dst));
                }
            });
        }
    }

    @Nonnull
    private <T extends Entity> Collection<T> extractWithCache(@Nonnull Collection<ExpAsVar> cols, @Nonnull EntityCreator<T> creator) throws ExecutionException {
        HashMap cache = new HashMap();
        this.iterateOverCells(cols, (row, column) -> {
            String variableName = ((QueryExpression.VarRef)column.getExp()).getVariable().getName();
            Object elementId = row.getObject(this.enhancement.getIdColumn(variableName));
            if (!cache.containsKey(elementId)) {
                cache.put(elementId, creator.create((ResultAccess)row, variableName, this.getProperties(variableName, (ResultAccess)row)));
            } else {
                List selectedProperties = this.getProperties(variableName, (ResultAccess)row).stream().filter(p -> p.isSelected()).collect(Collectors.toList());
                List<oracle.pgx.graphviz.formatter.Property> finalProperties = ((Entity)cache.get(elementId)).getProperties().stream().map(p -> selectedProperties.stream().filter(np -> np.getName().equals(p.getName())).findAny().orElse((oracle.pgx.graphviz.formatter.Property)p)).collect(Collectors.toList());
                Collection<String> groups = ((Entity)cache.get(elementId)).getGroups();
                cache.put(elementId, creator.create((ResultAccess)row, variableName, finalProperties));
                ((Entity)cache.get(elementId)).getGroups().addAll(groups);
            }
            ((Entity)cache.get(elementId)).getGroups().add(variableName);
        });
        return cache.values();
    }

    @Nonnull
    private List<oracle.pgx.graphviz.formatter.Property> getProperties(@Nonnull String columnName, @Nonnull ResultAccess row) throws PgqlException {
        Collection columns = this.propertyColumns.getOrDefault(columnName, new HashSet());
        ArrayList<oracle.pgx.graphviz.formatter.Property> properties = new ArrayList<oracle.pgx.graphviz.formatter.Property>(columns.size());
        for (PropertyColumn propertyColumn : columns) {
            oracle.pgx.graphviz.formatter.Property property = Property.fromPropertyColumn(propertyColumn, row);
            if (property == null) continue;
            properties.add(property);
        }
        return properties;
    }

    @Nonnull
    private Vertex createVertex(@Nonnull ResultAccess r, @Nonnull String name, @Nonnull List<oracle.pgx.graphviz.formatter.Property> properties) throws PgqlException {
        Collection<String> labels = this.getLabels(r, name, this.enhancement.getGraph().supportsMultipleVertexLabels());
        return Vertex.fromResult(r.getObject(this.enhancement.getIdColumn(name)), labels, properties);
    }

    @Nonnull
    private Edge createEdge(@Nonnull ResultAccess r, @Nonnull String name, @Nonnull List<oracle.pgx.graphviz.formatter.Property> properties) throws PgqlException {
        String isDestinationRes;
        boolean correctDestination;
        String srcVertex = Objects.requireNonNull(this.enhancement.getSourceVertexForEdge(name));
        String dstVertex = Objects.requireNonNull(this.enhancement.getDestVertexForEdge(name));
        Object src = r.getObject(this.enhancement.getIdColumn(srcVertex));
        Object dest = r.getObject(this.enhancement.getIdColumn(dstVertex));
        boolean undirected = this.isDirectedSupported ? !r.getBoolean(Objects.requireNonNull(this.enhancement.getEdgeDirection(name))).booleanValue() : false;
        String isDestinationColumn = this.enhancement.getIsDestinationOf(name);
        if (!undirected && isDestinationColumn != null && !(correctDestination = r.getBoolean(isDestinationRes = Objects.requireNonNull(isDestinationColumn)).booleanValue())) {
            Object swap = dest;
            dest = src;
            src = swap;
        }
        Collection<String> labels = this.getLabels(r, name, this.enhancement.getGraph().supportsMultipleEdgeLabels());
        return Edge.fromResult(r.getObject(this.enhancement.getIdColumn(name)), src, dest, undirected, labels, properties);
    }

    @Nonnull
    private Collection<String> getLabels(@Nonnull ResultAccess r, @Nonnull String name, boolean supportsMultipleLabels) throws PgqlException {
        String col = this.enhancement.getLabelColumn(name);
        if (col == null) {
            return Collections.emptySet();
        }
        if (supportsMultipleLabels) {
            return r.getVertexLabels(col);
        }
        return Collections.singleton(r.getString(col));
    }

    private <T> void iterateOverCells(@Nonnull Collection<T> columns, @Nonnull BiConsumer<ResultAccess, T> c) throws ExecutionException {
        if (!columns.isEmpty()) {
            try {
                this.rs.absolute((long)this.start);
                for (int idx = 0; (this.size < 0 || idx < this.size) && this.rs.next(); ++idx) {
                    for (T column : columns) {
                        c.consume((ResultAccess)this.rs, (ResultAccess)column);
                    }
                }
            }
            catch (PgqlException e) {
                throw new ExecutionException(e);
            }
        }
    }

    @FunctionalInterface
    private static interface EntityCreator<T> {
        @Nonnull
        public T create(ResultAccess var1, String var2, List<oracle.pgx.graphviz.formatter.Property> var3) throws PgqlException;
    }

    @FunctionalInterface
    private static interface BiConsumer<T, U> {
        public void consume(T var1, U var2) throws PgqlException;
    }
}

