/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.graphviz.library.enhancer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgql.lang.ir.ExpAsVar;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.GraphQuery;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryPath;
import oracle.pgql.lang.ir.QueryVariable;
import oracle.pgql.lang.ir.SelectQuery;
import oracle.pgql.lang.ir.TableExpression;
import oracle.pgql.lang.ir.VertexPairConnection;
import oracle.pgx.graphviz.driver.GraphInformation;
import oracle.pgx.graphviz.driver.Property;
import oracle.pgx.graphviz.library.enhancer.EnhancerUtil;
import oracle.pgx.graphviz.library.enhancer.PropertyColumn;

public class Enhancement {
    @Nonnull
    private final Map<String, String> edgeToSrcVertexMapping = new HashMap<String, String>();
    @Nonnull
    private final Map<String, String> edgeToDestVertexMapping = new HashMap<String, String>();
    @Nonnull
    private final Map<String, String> varToLabelMapping = new HashMap<String, String>();
    @Nonnull
    private final Map<String, String> varToIdMapping = new HashMap<String, String>();
    private final Map<String, String> edgeToIsDirected = new HashMap<String, String>();
    private final Map<String, String> edgeToIsDestinationMapping = new HashMap<String, String>();
    @Nonnull
    private final Set<PropertyColumn> propertyColumns = new HashSet<PropertyColumn>();
    @Nonnull
    private final GraphQuery query;
    @Nonnull
    private final GraphInformation graph;
    private final List<ExpAsVar> projectionOfEdgesAndVertices;
    private final boolean isDirectedSupported;
    private final boolean supportsOneRowPerStep;

    Enhancement(@Nonnull GraphQuery query, @Nonnull GraphInformation graph, boolean isDirectedSupported, boolean supportsOneRowPerStep) {
        this.query = query;
        this.graph = graph;
        this.isDirectedSupported = isDirectedSupported;
        this.supportsOneRowPerStep = supportsOneRowPerStep;
        this.projectionOfEdgesAndVertices = new ArrayList<ExpAsVar>();
        this.getProjection().stream().filter(expAsVar -> expAsVar.getExp().getExpType() == QueryExpression.ExpressionType.PROP_ACCESS).map(expAsVar -> this.createPropertyColumn((ExpAsVar)expAsVar, true)).forEach(this.propertyColumns::add);
    }

    @Nonnull
    private static ExpAsVar createFunctionExpression(@Nonnull Enhancement enhancement, @Nonnull QueryVariable argument, @Nonnull String functionName) {
        QueryExpression.VarRef funArg = new QueryExpression.VarRef(argument);
        QueryExpression.FunctionCall fun = new QueryExpression.FunctionCall(functionName, Collections.singletonList(funArg));
        String columnName = Enhancement.makeUnique(argument.getName() + "_" + functionName, enhancement.getProjectedVariableNames());
        return new ExpAsVar((QueryExpression)fun, columnName, false);
    }

    private static ExpAsVar createBiFunctionExpression(@Nonnull Enhancement enhancement, @Nonnull QueryVariable argument1, @Nonnull QueryVariable argument2, @Nonnull String functionName) {
        QueryExpression.VarRef funArg1 = new QueryExpression.VarRef(argument1);
        QueryExpression.VarRef funArg2 = new QueryExpression.VarRef(argument2);
        QueryExpression.FunctionCall fun = new QueryExpression.FunctionCall(functionName, Arrays.asList(funArg1, funArg2));
        String columnName = Enhancement.makeUnique(argument1.getName() + "_" + functionName, enhancement.getProjectedVariableNames());
        return new ExpAsVar((QueryExpression)fun, columnName, false);
    }

    @Nonnull
    private static String makeUnique(@Nonnull String variable, @Nonnull Collection<String> others) {
        String attempt;
        int counter = 1;
        do {
            attempt = variable + "_" + counter;
            ++counter;
        } while (others.contains(attempt));
        return attempt;
    }

    @Nonnull
    public GraphQuery getQuery() {
        return this.query;
    }

    @Nonnull
    public List<ExpAsVar> getProjection() {
        return ((SelectQuery)this.query).getProjection().getElements();
    }

    @Nonnull
    public GraphInformation getGraph() {
        return this.graph;
    }

    public boolean getSupportsOneRowPerStep() {
        return this.supportsOneRowPerStep;
    }

    void addEdgeMapping(@Nonnull String edge, @Nonnull String src, @Nonnull String dst) {
        this.edgeToSrcVertexMapping.put(edge, src);
        this.edgeToDestVertexMapping.put(edge, dst);
    }

    @Nullable
    public String getSourceVertexForEdge(@Nonnull String edge) {
        return this.edgeToSrcVertexMapping.get(edge);
    }

    @Nullable
    public String getDestVertexForEdge(@Nonnull String edge) {
        return this.edgeToDestVertexMapping.get(edge);
    }

    void addLabelsToQuery(@Nonnull QueryVariable var, String functionName) {
        if (!this.varToLabelMapping.containsKey(var.getName())) {
            ExpAsVar funExp = Enhancement.createFunctionExpression(this, var, functionName);
            this.getProjection().add(funExp);
            this.varToLabelMapping.put(var.getName(), funExp.getName());
        }
    }

    @Nullable
    public String getLabelColumn(@Nonnull String edge) {
        return this.varToLabelMapping.get(edge);
    }

    void addIdToQuery(@Nonnull QueryVariable var) {
        if (!this.varToIdMapping.containsKey(var.getName())) {
            ExpAsVar funExp = Enhancement.createFunctionExpression(this, var, "id");
            this.varToIdMapping.put(var.getName(), funExp.getName());
            this.getProjection().add(funExp);
        }
    }

    void addDirectionToEdge(@Nonnull QueryVariable queryVar) {
        if (this.isDirectedSupported) {
            ExpAsVar funExp = Enhancement.createFunctionExpression(this, queryVar, "is_directed");
            this.getProjection().add(funExp);
            this.edgeToIsDirected.put(queryVar.getName(), funExp.getName());
        }
    }

    public String getEdgeDirection(@Nonnull String edge) {
        return this.edgeToIsDirected.get(edge);
    }

    public void addIsDestinationOf(@Nonnull QueryVariable edge, @Nonnull QueryVariable queryDestinationVertex) {
        ExpAsVar funExp = Enhancement.createBiFunctionExpression(this, edge, queryDestinationVertex, "is_destination_of");
        if (!this.edgeToIsDestinationMapping.containsKey(edge.getName()) && !this.edgeToIsDestinationMapping.containsValue(funExp.getName())) {
            this.getProjection().add(funExp);
            this.edgeToIsDestinationMapping.put(edge.getName(), funExp.getName());
        }
    }

    public String getIsDestinationOf(@Nonnull String edge) {
        return this.edgeToIsDestinationMapping.get(edge);
    }

    @Nullable
    public String getIdColumn(@Nonnull String edgeOrVertex) {
        return this.varToIdMapping.get(edgeOrVertex);
    }

    void addPropertyColumn(@Nonnull ExpAsVar exp, boolean addExpAsVar, boolean selected) {
        if (addExpAsVar) {
            this.getProjection().add(exp);
        }
        this.propertyColumns.add(this.createPropertyColumn(exp, selected));
    }

    private PropertyColumn createPropertyColumn(ExpAsVar expAsVar, boolean selected) {
        QueryVariable baseVariable = EnhancerUtil.recursivelyDereference((QueryVariable)expAsVar);
        if (baseVariable.getVariableType() != QueryVariable.VariableType.EXP_AS_VAR || ((ExpAsVar)baseVariable).getExp().getExpType() != QueryExpression.ExpressionType.PROP_ACCESS) {
            return new PropertyColumn(expAsVar, expAsVar.getName(), selected);
        }
        ExpAsVar baseExpAsVar = (ExpAsVar)baseVariable;
        QueryExpression.PropertyAccess propertyAccess = (QueryExpression.PropertyAccess)baseExpAsVar.getExp();
        String propertyReference = propertyAccess.getPropertyName();
        Set properties = propertyAccess.getVariable().getVariableType() == QueryVariable.VariableType.VERTEX ? this.graph.getVertexProperties() : this.graph.getEdgeProperties();
        Set<String> propertyNames = properties.stream().map(Property::getName).collect(Collectors.toSet());
        String propertyName = EnhancerUtil.getPropertyNameFromReference(propertyNames, propertyReference);
        if (propertyName == null) {
            propertyName = propertyReference;
        }
        return new PropertyColumn(expAsVar, propertyName, selected);
    }

    @Nonnull
    public Set<PropertyColumn> getPropertyColumns() {
        return this.propertyColumns;
    }

    @Nonnull
    public <T extends QueryExpression> Stream<T> getProjectionsOfType(@Nonnull Class<T> expresionType) {
        return EnhancerUtil.getProjectionsFromQueryOfType(this.getQuery(), expresionType);
    }

    @Nonnull
    public Stream<ExpAsVar> getExpsAsVar() {
        return this.getProjection().stream();
    }

    @Nonnull
    public Set<String> getProjectedVariableNames() {
        return EnhancerUtil.getProjectedVariableNamesFromQuery(this.getQuery());
    }

    @Nonnull
    public Stream<QueryPath> getPaths() {
        HashSet<QueryPath> result = new HashSet<QueryPath>();
        block4: for (TableExpression tableExpression : this.query.getTableExpressions()) {
            switch (tableExpression.getTableExpressionType()) {
                case GRAPH_PATTERN: {
                    GraphPattern graphPattern = (GraphPattern)tableExpression;
                    for (VertexPairConnection connection : graphPattern.getConnections()) {
                        if (connection.getVariableType() != QueryVariable.VariableType.PATH) continue;
                        result.add((QueryPath)connection);
                    }
                    continue block4;
                }
                case DERIVED_TABLE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported table expression " + tableExpression.getTableExpressionType());
                }
            }
        }
        return result.stream();
    }
}

