/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import oracle.pg.rdbms.exception.GraphClientException;
import oracle.pg.rdbms.internal.UriUtils;
import oracle.pgx.common.util.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdbGraphClientConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdbGraphClientConfiguration.class);
    private static final String GET_CONNECTION_DETAILS_QUERY = "select " + "json_value(cloud_identity,'$.DATABASE_NAME') as database_name, " + "sys_context('userenv','service_name') as service_name, " + "json_value(cloud_identity,'$.PUBLIC_DOMAIN_NAME') as public_domain_name, " + "json_value(cloud_identity,'$.TENANT_OCID') as tenant_ocid, " + "json_value(cloud_identity,'$.DATABASE_OCID') as database_ocid " + "from v$pdbs";
    private static final String HTTPS = "https://";
    private static final String ORACLECLOUD_COM = "oraclecloud.com";
    private static final String ORACLECLOUDAPPS_COM = "oraclecloudapps.com";
    private static final String ADB_ORACLECLOUD_COM = "adb.oraclecloud.com";
    public static final TimeUnit DEFAULT_REFRESH_TIME_BEFORE_TOKEN_EXPIRY_TIME_UNIT = TimeUnit.SECONDS;
    private static final long DEFAULT_JOB_POLL_INTERVAL = 1000L;
    private static final TimeUnit DEFAULT_JOB_POLL_INTERVAL_TIME_UNIT = TimeUnit.MILLISECONDS;
    private static final String DEFAULT_GRAPH_STUDIO_API_VERSION = "20230315";
    private static final String DEFAULT_DATA_STUDIO_API_VERSION = "20230315";
    private String endpoint;
    @Deprecated
    private String tenant;
    private String database;
    private String username;
    private String password;
    private String tenancyOcid;
    private String databaseOcid;
    @Deprecated
    private String cloudDatabaseName;
    private HttpClient httpClient;
    private int refreshTimeBeforeTokenExpiry;
    private TimeUnit refreshTimeBeforeTokenExpiryTimeUnit;
    private ExecutorService executorService;
    private long jobPollInterval;
    private TimeUnit jobPollIntervalTimeUnit;
    private String graphStudioApiVersion;
    private String dataStudioApiVersion;
    private String brokerBaseUrl;
    private String pgxBaseUrl;
    private String graphStudioBaseUrl;

    public URI createBrokerBaseURI() {
        return this.createBaseURI(this.brokerBaseUrl, "/broker/pdbcs");
    }

    public URI createPgxBaseURI() {
        return this.createBaseURI(this.pgxBaseUrl, "/graph/pgx");
    }

    public URI createGraphStudioBaseURI() {
        return this.createBaseURI(this.graphStudioBaseUrl, "/graphstudio");
    }

    private URI createBaseURI(String overwriteUrl, String path) {
        try {
            if (overwriteUrl != null) {
                return new URI(overwriteUrl);
            }
            return UriUtils.appendPath(new URI(this.endpoint), path);
        }
        catch (URISyntaxException e) {
            throw new GraphClientException("invalid URL given", null, e);
        }
    }

    static final String buildEndpoint(String serviceName, String publicDomainName) {
        if (StringUtils.isEmpty((String)serviceName) || StringUtils.isEmpty((String)publicDomainName)) {
            throw new IllegalArgumentException("Unable to fetch connection details", null);
        }
        String[] serviceNameParsed = serviceName.split("_");
        serviceNameParsed = Arrays.copyOf(serviceNameParsed, serviceNameParsed.length - 1);
        serviceName = "";
        boolean isTenancy = true;
        for (String s : serviceNameParsed) {
            serviceName = serviceName + s + (isTenancy ? "-" : "_");
            isTenancy = false;
        }
        serviceName = serviceName.substring(0, serviceName.length() - 1);
        return HTTPS + serviceName.replace(".adb.oraclecloud.com", "") + "." + publicDomainName.replace(ORACLECLOUD_COM, ORACLECLOUDAPPS_COM) + "/";
    }

    /*
     * Exception decompiling
     */
    public static AdbGraphClientConfiguration fromConnection(Connection connection, String password) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AdbGraphClientConfiguration fromCredentials(String jdbcUrl, String username, String password) {
        if (StringUtils.isEmpty((String)jdbcUrl)) {
            throw new IllegalArgumentException("Please provide a jdbc url");
        }
        if (StringUtils.isEmpty((String)username)) {
            throw new IllegalArgumentException("Please provide a username");
        }
        if (StringUtils.isEmpty((String)password)) {
            throw new IllegalArgumentException("Please provide a password");
        }
        try (Connection connection = DriverManager.getConnection(jdbcUrl, username, password);){
            AdbGraphClientConfiguration adbGraphClientConfiguration = AdbGraphClientConfiguration.fromConnection(connection, password);
            return adbGraphClientConfiguration;
        }
        catch (SQLException e) {
            throw new GraphClientException("Unable to build the configuration from connection details", null, e);
        }
    }

    @Generated
    private static String $default$cloudDatabaseName() {
        return null;
    }

    @Generated
    private static HttpClient $default$httpClient() {
        return HttpClients.createDefault();
    }

    @Generated
    private static int $default$refreshTimeBeforeTokenExpiry() {
        return 1800;
    }

    @Generated
    private static TimeUnit $default$refreshTimeBeforeTokenExpiryTimeUnit() {
        return DEFAULT_REFRESH_TIME_BEFORE_TOKEN_EXPIRY_TIME_UNIT;
    }

    @Generated
    private static ExecutorService $default$executorService() {
        return null;
    }

    @Generated
    private static long $default$jobPollInterval() {
        return 1000L;
    }

    @Generated
    private static TimeUnit $default$jobPollIntervalTimeUnit() {
        return DEFAULT_JOB_POLL_INTERVAL_TIME_UNIT;
    }

    @Generated
    private static String $default$graphStudioApiVersion() {
        return "20230315";
    }

    @Generated
    private static String $default$dataStudioApiVersion() {
        return "20230315";
    }

    @Generated
    private static String $default$brokerBaseUrl() {
        return null;
    }

    @Generated
    private static String $default$pgxBaseUrl() {
        return null;
    }

    @Generated
    private static String $default$graphStudioBaseUrl() {
        return null;
    }

    @Generated
    AdbGraphClientConfiguration(String endpoint, String tenant, String database, String username, String password, String tenancyOcid, String databaseOcid, String cloudDatabaseName, HttpClient httpClient, int refreshTimeBeforeTokenExpiry, TimeUnit refreshTimeBeforeTokenExpiryTimeUnit, ExecutorService executorService, long jobPollInterval, TimeUnit jobPollIntervalTimeUnit, String graphStudioApiVersion, String dataStudioApiVersion, String brokerBaseUrl, String pgxBaseUrl, String graphStudioBaseUrl) {
        this.endpoint = endpoint;
        this.tenant = tenant;
        this.database = database;
        this.username = username;
        this.password = password;
        this.tenancyOcid = tenancyOcid;
        this.databaseOcid = databaseOcid;
        this.cloudDatabaseName = cloudDatabaseName;
        this.httpClient = httpClient;
        this.refreshTimeBeforeTokenExpiry = refreshTimeBeforeTokenExpiry;
        this.refreshTimeBeforeTokenExpiryTimeUnit = refreshTimeBeforeTokenExpiryTimeUnit;
        this.executorService = executorService;
        this.jobPollInterval = jobPollInterval;
        this.jobPollIntervalTimeUnit = jobPollIntervalTimeUnit;
        this.graphStudioApiVersion = graphStudioApiVersion;
        this.dataStudioApiVersion = dataStudioApiVersion;
        this.brokerBaseUrl = brokerBaseUrl;
        this.pgxBaseUrl = pgxBaseUrl;
        this.graphStudioBaseUrl = graphStudioBaseUrl;
    }

    @Generated
    public static AdbGraphClientConfigurationBuilder builder() {
        return new AdbGraphClientConfigurationBuilder();
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Deprecated
    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getTenancyOcid() {
        return this.tenancyOcid;
    }

    @Generated
    public String getDatabaseOcid() {
        return this.databaseOcid;
    }

    @Deprecated
    @Generated
    public String getCloudDatabaseName() {
        return this.cloudDatabaseName;
    }

    @Generated
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Generated
    public int getRefreshTimeBeforeTokenExpiry() {
        return this.refreshTimeBeforeTokenExpiry;
    }

    @Generated
    public TimeUnit getRefreshTimeBeforeTokenExpiryTimeUnit() {
        return this.refreshTimeBeforeTokenExpiryTimeUnit;
    }

    @Generated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Generated
    public long getJobPollInterval() {
        return this.jobPollInterval;
    }

    @Generated
    public TimeUnit getJobPollIntervalTimeUnit() {
        return this.jobPollIntervalTimeUnit;
    }

    @Generated
    public String getGraphStudioApiVersion() {
        return this.graphStudioApiVersion;
    }

    @Generated
    public String getDataStudioApiVersion() {
        return this.dataStudioApiVersion;
    }

    @Generated
    public String getBrokerBaseUrl() {
        return this.brokerBaseUrl;
    }

    @Generated
    public String getPgxBaseUrl() {
        return this.pgxBaseUrl;
    }

    @Generated
    public String getGraphStudioBaseUrl() {
        return this.graphStudioBaseUrl;
    }

    @Generated
    public static class AdbGraphClientConfigurationBuilder {
        @Generated
        private String endpoint;
        @Generated
        private String tenant;
        @Generated
        private String database;
        @Generated
        private String username;
        @Generated
        private String password;
        @Generated
        private String tenancyOcid;
        @Generated
        private String databaseOcid;
        @Generated
        private boolean cloudDatabaseName$set;
        @Generated
        private String cloudDatabaseName$value;
        @Generated
        private boolean httpClient$set;
        @Generated
        private HttpClient httpClient$value;
        @Generated
        private boolean refreshTimeBeforeTokenExpiry$set;
        @Generated
        private int refreshTimeBeforeTokenExpiry$value;
        @Generated
        private boolean refreshTimeBeforeTokenExpiryTimeUnit$set;
        @Generated
        private TimeUnit refreshTimeBeforeTokenExpiryTimeUnit$value;
        @Generated
        private boolean executorService$set;
        @Generated
        private ExecutorService executorService$value;
        @Generated
        private boolean jobPollInterval$set;
        @Generated
        private long jobPollInterval$value;
        @Generated
        private boolean jobPollIntervalTimeUnit$set;
        @Generated
        private TimeUnit jobPollIntervalTimeUnit$value;
        @Generated
        private boolean graphStudioApiVersion$set;
        @Generated
        private String graphStudioApiVersion$value;
        @Generated
        private boolean dataStudioApiVersion$set;
        @Generated
        private String dataStudioApiVersion$value;
        @Generated
        private boolean brokerBaseUrl$set;
        @Generated
        private String brokerBaseUrl$value;
        @Generated
        private boolean pgxBaseUrl$set;
        @Generated
        private String pgxBaseUrl$value;
        @Generated
        private boolean graphStudioBaseUrl$set;
        @Generated
        private String graphStudioBaseUrl$value;

        @Generated
        AdbGraphClientConfigurationBuilder() {
        }

        @Generated
        public AdbGraphClientConfigurationBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Deprecated
        @Generated
        public AdbGraphClientConfigurationBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder database(String database) {
            this.database = database;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder tenancyOcid(String tenancyOcid) {
            this.tenancyOcid = tenancyOcid;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder databaseOcid(String databaseOcid) {
            this.databaseOcid = databaseOcid;
            return this;
        }

        @Deprecated
        @Generated
        public AdbGraphClientConfigurationBuilder cloudDatabaseName(String cloudDatabaseName) {
            this.cloudDatabaseName$value = cloudDatabaseName;
            this.cloudDatabaseName$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder httpClient(HttpClient httpClient) {
            this.httpClient$value = httpClient;
            this.httpClient$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder refreshTimeBeforeTokenExpiry(int refreshTimeBeforeTokenExpiry) {
            this.refreshTimeBeforeTokenExpiry$value = refreshTimeBeforeTokenExpiry;
            this.refreshTimeBeforeTokenExpiry$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder refreshTimeBeforeTokenExpiryTimeUnit(TimeUnit refreshTimeBeforeTokenExpiryTimeUnit) {
            this.refreshTimeBeforeTokenExpiryTimeUnit$value = refreshTimeBeforeTokenExpiryTimeUnit;
            this.refreshTimeBeforeTokenExpiryTimeUnit$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder executorService(ExecutorService executorService) {
            this.executorService$value = executorService;
            this.executorService$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder jobPollInterval(long jobPollInterval) {
            this.jobPollInterval$value = jobPollInterval;
            this.jobPollInterval$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder jobPollIntervalTimeUnit(TimeUnit jobPollIntervalTimeUnit) {
            this.jobPollIntervalTimeUnit$value = jobPollIntervalTimeUnit;
            this.jobPollIntervalTimeUnit$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder graphStudioApiVersion(String graphStudioApiVersion) {
            this.graphStudioApiVersion$value = graphStudioApiVersion;
            this.graphStudioApiVersion$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder dataStudioApiVersion(String dataStudioApiVersion) {
            this.dataStudioApiVersion$value = dataStudioApiVersion;
            this.dataStudioApiVersion$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder brokerBaseUrl(String brokerBaseUrl) {
            this.brokerBaseUrl$value = brokerBaseUrl;
            this.brokerBaseUrl$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder pgxBaseUrl(String pgxBaseUrl) {
            this.pgxBaseUrl$value = pgxBaseUrl;
            this.pgxBaseUrl$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfigurationBuilder graphStudioBaseUrl(String graphStudioBaseUrl) {
            this.graphStudioBaseUrl$value = graphStudioBaseUrl;
            this.graphStudioBaseUrl$set = true;
            return this;
        }

        @Generated
        public AdbGraphClientConfiguration build() {
            String cloudDatabaseName$value = this.cloudDatabaseName$value;
            if (!this.cloudDatabaseName$set) {
                cloudDatabaseName$value = AdbGraphClientConfiguration.$default$cloudDatabaseName();
            }
            HttpClient httpClient$value = this.httpClient$value;
            if (!this.httpClient$set) {
                httpClient$value = AdbGraphClientConfiguration.$default$httpClient();
            }
            int refreshTimeBeforeTokenExpiry$value = this.refreshTimeBeforeTokenExpiry$value;
            if (!this.refreshTimeBeforeTokenExpiry$set) {
                refreshTimeBeforeTokenExpiry$value = AdbGraphClientConfiguration.$default$refreshTimeBeforeTokenExpiry();
            }
            TimeUnit refreshTimeBeforeTokenExpiryTimeUnit$value = this.refreshTimeBeforeTokenExpiryTimeUnit$value;
            if (!this.refreshTimeBeforeTokenExpiryTimeUnit$set) {
                refreshTimeBeforeTokenExpiryTimeUnit$value = AdbGraphClientConfiguration.$default$refreshTimeBeforeTokenExpiryTimeUnit();
            }
            ExecutorService executorService$value = this.executorService$value;
            if (!this.executorService$set) {
                executorService$value = AdbGraphClientConfiguration.$default$executorService();
            }
            long jobPollInterval$value = this.jobPollInterval$value;
            if (!this.jobPollInterval$set) {
                jobPollInterval$value = AdbGraphClientConfiguration.$default$jobPollInterval();
            }
            TimeUnit jobPollIntervalTimeUnit$value = this.jobPollIntervalTimeUnit$value;
            if (!this.jobPollIntervalTimeUnit$set) {
                jobPollIntervalTimeUnit$value = AdbGraphClientConfiguration.$default$jobPollIntervalTimeUnit();
            }
            String graphStudioApiVersion$value = this.graphStudioApiVersion$value;
            if (!this.graphStudioApiVersion$set) {
                graphStudioApiVersion$value = AdbGraphClientConfiguration.$default$graphStudioApiVersion();
            }
            String dataStudioApiVersion$value = this.dataStudioApiVersion$value;
            if (!this.dataStudioApiVersion$set) {
                dataStudioApiVersion$value = AdbGraphClientConfiguration.$default$dataStudioApiVersion();
            }
            String brokerBaseUrl$value = this.brokerBaseUrl$value;
            if (!this.brokerBaseUrl$set) {
                brokerBaseUrl$value = AdbGraphClientConfiguration.$default$brokerBaseUrl();
            }
            String pgxBaseUrl$value = this.pgxBaseUrl$value;
            if (!this.pgxBaseUrl$set) {
                pgxBaseUrl$value = AdbGraphClientConfiguration.$default$pgxBaseUrl();
            }
            String graphStudioBaseUrl$value = this.graphStudioBaseUrl$value;
            if (!this.graphStudioBaseUrl$set) {
                graphStudioBaseUrl$value = AdbGraphClientConfiguration.$default$graphStudioBaseUrl();
            }
            return new AdbGraphClientConfiguration(this.endpoint, this.tenant, this.database, this.username, this.password, this.tenancyOcid, this.databaseOcid, cloudDatabaseName$value, httpClient$value, refreshTimeBeforeTokenExpiry$value, refreshTimeBeforeTokenExpiryTimeUnit$value, executorService$value, jobPollInterval$value, jobPollIntervalTimeUnit$value, graphStudioApiVersion$value, dataStudioApiVersion$value, brokerBaseUrl$value, pgxBaseUrl$value, graphStudioBaseUrl$value);
        }

        @Generated
        public String toString() {
            return "AdbGraphClientConfiguration.AdbGraphClientConfigurationBuilder(endpoint=" + this.endpoint + ", tenant=" + this.tenant + ", database=" + this.database + ", username=" + this.username + ", password=" + this.password + ", tenancyOcid=" + this.tenancyOcid + ", databaseOcid=" + this.databaseOcid + ", cloudDatabaseName$value=" + this.cloudDatabaseName$value + ", httpClient$value=" + this.httpClient$value + ", refreshTimeBeforeTokenExpiry$value=" + this.refreshTimeBeforeTokenExpiry$value + ", refreshTimeBeforeTokenExpiryTimeUnit$value=" + (Object)((Object)this.refreshTimeBeforeTokenExpiryTimeUnit$value) + ", executorService$value=" + this.executorService$value + ", jobPollInterval$value=" + this.jobPollInterval$value + ", jobPollIntervalTimeUnit$value=" + (Object)((Object)this.jobPollIntervalTimeUnit$value) + ", graphStudioApiVersion$value=" + this.graphStudioApiVersion$value + ", dataStudioApiVersion$value=" + this.dataStudioApiVersion$value + ", brokerBaseUrl$value=" + this.brokerBaseUrl$value + ", pgxBaseUrl$value=" + this.pgxBaseUrl$value + ", graphStudioBaseUrl$value=" + this.graphStudioBaseUrl$value + ")";
        }
    }
}

