/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.validation;

import java.util.function.Predicate;
import oracle.pgx.validation.Validator;

public class IsPositiveOrNullValidator<T extends Number>
implements Validator<T> {
    public static final IsPositiveOrNullValidator<Integer> IS_POSITIVE_INTEGER = new IsPositiveOrNullValidator<Integer>(i -> i > 0);
    private final Predicate<T> greaterNullPredicate;

    private IsPositiveOrNullValidator(Predicate<T> greaterNullPredicate) {
        this.greaterNullPredicate = greaterNullPredicate;
    }

    @Override
    public String formatError(T value, String key) {
        return key + " needs to be a positive integer, but was: " + value;
    }

    @Override
    public boolean test(T value) {
        return value == null || this.greaterNullPredicate.test(value);
    }
}

