/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import oracle.pgx.common.Link;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.common.util.EdgeModule;
import oracle.pgx.common.util.FutureProgressModule;
import oracle.pgx.common.util.GraphLocationModule;
import oracle.pgx.common.util.VertexModule;

public final class JsonUtil
extends ConfigJsonUtil {
    private static final JsonUtil UTIL = new JsonUtil();
    public static final JavaType STRING_SET_CLASS = JsonUtil.getTypeFactory().constructCollectionType(Set.class, String.class);
    public static final JavaType STRING_ARRAY_CLASS = JsonUtil.getTypeFactory().constructCollectionType(List.class, String.class);

    public static JsonNode wrapPrimitiveEntity(String strEntity, List<Link> links, String id) throws IOException {
        return JsonUtil.getUtil().instanceWrapPrimitiveEntity(strEntity, links, id);
    }

    public static DeserializationContext getDeserializationContext() {
        return JsonUtil.getUtil().getInstanceDeserializationContext();
    }

    public static JsonParser treeAsTokens(TreeNode node) {
        return JsonUtil.getUtil().instanceTreeAsTokens(node);
    }

    public static <T> T treeToValue(TreeNode node, Class<T> type) throws JsonProcessingException {
        return (T)JsonUtil.getUtil().instanceTreeToValue(node, type);
    }

    public static <T> T reparseObject(Object object, Class<T> newType) throws IOException {
        return (T)JsonUtil.getUtil().instanceReparseObject(object, newType);
    }

    public static String toJsonNullable(Object object) throws JsonProcessingException {
        return JsonUtil.getUtil().instanceToJsonNullable(object);
    }

    public static String toJson(Object object) throws JsonProcessingException {
        return JsonUtil.getUtil().instanceToJson(object);
    }

    public static <T> T fromJsonNode(JsonNode node, Class<T> type) throws JsonProcessingException {
        return (T)JsonUtil.getUtil().instanceFromJsonNode(node, type);
    }

    public static <T> T fromJsonInputStream(InputStream jsonInputStream, Class<T> type) throws JsonParseException, JsonMappingException, IOException {
        return (T)JsonUtil.getUtil().instanceFromJsonInputStream(jsonInputStream, type);
    }

    public static InputStream toJsonInputStream(Object object) throws JsonProcessingException {
        return JsonUtil.getUtil().instanceToJsonInputStream(object);
    }

    public static JsonNode readTree(File file) throws IOException, JsonProcessingException {
        return JsonUtil.getUtil().instanceReadTree(file);
    }

    static <T extends JsonNode> T valueToTree(Object fromValue) throws IllegalArgumentException {
        return (T)JsonUtil.getUtil().instanceValueToTree(fromValue);
    }

    public static JsonParser getValues(JsonNode node, String value) {
        return JsonUtil.treeAsTokens((TreeNode)node.get(value));
    }

    public static TypeFactory getTypeFactory() {
        return JsonUtil.getUtil().instanceGetTypeFactory();
    }

    public static JsonNode readTopLevelJsonToTree(String json) throws JsonGenerationException, JsonMappingException, IOException {
        return JsonUtil.getUtil().instanceReadTopLevelJsonToTree(json);
    }

    public static <T> T readTopLevelJson(String json, Class<T> type) throws IOException, JsonParseException, JsonMappingException {
        return (T)JsonUtil.getUtil().instanceReadTopLevelJson(json, type);
    }

    public static <T> T readTopLevelJson(String json, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)JsonUtil.getUtil().instanceReadTopLevelJson(json, valueType);
    }

    public static <T> T readValue(JsonParser p, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)JsonUtil.getUtil().instanceReadValue(p, valueTypeRef);
    }

    public static <T> T readValue(JsonParser p, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)JsonUtil.getUtil().instanceReadValue(p, valueType);
    }

    public static <T> T readValue(JsonParser p, Class<T> type) throws IOException, JsonParseException, JsonMappingException {
        return (T)JsonUtil.getUtil().instanceReadValue(p, type);
    }

    public static <T> T readValue(String content, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        if (content == null || content.length() == 0) {
            return null;
        }
        return (T)JsonUtil.getUtil().instanceReadValue(content, valueType);
    }

    public static <T> T readValue(File content, JavaType valueType) throws IOException {
        return (T)JsonUtil.getUtil().instanceReadValue(content, valueType);
    }

    public static <T> T readValue(String content, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)JsonUtil.getUtil().instanceReadValue(content, valueType);
    }

    public static <T> T readValue(InputStream src, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)JsonUtil.getUtil().instanceReadValue(src, valueTypeRef);
    }

    public static byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        return JsonUtil.getUtil().instanceWriteValueAsBytes(value);
    }

    static ObjectWriter writerWithDefaultPrettyPrinter() {
        return JsonUtil.getUtil().instanceWriterWithDefaultPrettyPrinter();
    }

    private static JsonUtil getUtil() {
        return UTIL;
    }

    private JsonUtil() {
    }

    protected void registerModules(ObjectMapper objectMapper) {
        super.registerModules(objectMapper);
        objectMapper.registerModule((Module)new VertexModule());
        objectMapper.registerModule((Module)new EdgeModule());
        objectMapper.registerModule((Module)new GraphLocationModule());
        objectMapper.registerModules(new Module[]{new FutureProgressModule()});
    }

    private JsonNode instanceWrapPrimitiveEntity(String strEntity, List<Link> links, String id) throws IOException {
        ObjectNode wrappedEntity = this.getObjectMapper().createObjectNode();
        ArrayNode linkNode = this.getObjectMapper().createArrayNode();
        JsonNode entity = this.getObjectMapper().readTree(strEntity);
        links.forEach(link -> linkNode.add(this.getObjectMapper().valueToTree(link)));
        wrappedEntity.put("links", (JsonNode)linkNode);
        wrappedEntity.put("entity", entity);
        wrappedEntity.put("id", id);
        return wrappedEntity;
    }
}

