/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import oracle.pgx.api.DefaultFutureProgress;
import oracle.pgx.api.FutureProgress;
import oracle.pgx.api.GraphLoadingProgress;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.util.JsonUtil;

public class FutureProgressModule
extends SimpleModule {
    FutureProgressModule() {
        super("FutureProgressModule", Version.unknownVersion());
        this.addDeserializer(FutureProgress.class, new FutureProgressDeserializer());
    }

    public static class FutureProgressDeserializer
    extends JsonDeserializer<FutureProgress> {
        public FutureProgress deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode rootNode = (JsonNode)p.readValueAsTree();
            JsonNode typeNode = rootNode.get("@type");
            FutureProgress.FutureProgressType futureProgressType = FutureProgress.FutureProgressType.fromTypeId(typeNode.asText());
            switch (futureProgressType) {
                case DEFAULT_FUTURE_PROGRESS: {
                    return JsonUtil.treeToValue((TreeNode)rootNode, DefaultFutureProgress.class);
                }
                case GRAPH_LOADING_PROGRESS: {
                    return JsonUtil.treeToValue((TreeNode)rootNode, GraphLoadingProgress.class);
                }
            }
            throw new IllegalEnumConstantException((Enum)futureProgressType);
        }
    }
}

