/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.mutations;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.mutations.EdgeStrategy;

public class MutationStrategy {
    private final Collection<PgxId> edgePropIds;
    private final Collection<PgxId> vertexPropIds;
    private final Map<String, String> edgeLabelMapping;
    private final boolean inPlace;
    private final String newGraphName;
    private final EdgeMappingAction edgeLabelMappingAction;
    private final boolean noTrivialVertices;
    private final boolean generateLabelHistogram;
    private final boolean generateDegreeCaches;
    private final EdgeStrategy edgeStrategy;

    public MutationStrategy(Collection<PgxId> vertexPropIds, Collection<PgxId> edgePropIds, boolean inPlace, String newGraphName, boolean noTrivialVertices, EdgeStrategy edgeStrategy, Map<String, String> edgeLabelMapping, boolean generateLabelHistogram, boolean generateDegreeCaches) {
        this.vertexPropIds = vertexPropIds;
        this.edgePropIds = edgePropIds;
        this.inPlace = inPlace;
        this.newGraphName = newGraphName;
        this.noTrivialVertices = noTrivialVertices;
        this.edgeStrategy = edgeStrategy;
        this.edgeLabelMapping = edgeLabelMapping;
        this.edgeLabelMappingAction = this.getEdgeLabelMappingAction();
        this.generateLabelHistogram = generateLabelHistogram;
        this.generateDegreeCaches = generateDegreeCaches;
    }

    public MutationStrategy(Collection<PgxId> vertexPropIds, Collection<PgxId> edgePropIds, boolean inPlace, String newGraphName, boolean noTrivialVertices, EdgeStrategy edgeStrategy, Map<String, String> edgeLabelMapping) {
        this(vertexPropIds, edgePropIds, inPlace, newGraphName, noTrivialVertices, edgeStrategy, edgeLabelMapping, false, false);
    }

    public MutationStrategy(Collection<PgxId> vertexPropIds, Collection<PgxId> edgePropIds, boolean inPlace, String newGraphName, boolean noTrivialVertices, EdgeStrategy edgeStrategy) {
        this(vertexPropIds, edgePropIds, inPlace, newGraphName, noTrivialVertices, edgeStrategy, Collections.emptyMap());
    }

    protected EdgeMappingAction getEdgeLabelMappingAction() {
        if (this.edgeLabelMapping == null) {
            return EdgeMappingAction.REMOVE;
        }
        return this.edgeLabelMapping.isEmpty() ? EdgeMappingAction.IGNORE : EdgeMappingAction.MAP;
    }

    public boolean isInPlace() {
        return this.inPlace;
    }

    public boolean getDegreeCachesGenerationFlag() {
        return this.generateDegreeCaches;
    }

    public boolean isNoMultiEdges() {
        return this.getEdgeStrategy().strategyType != EdgeStrategy.StrategyType.KEEP_ALL;
    }

    public boolean isNoSelfEdges() {
        return this.getEdgeStrategy().isNoSelfEdges();
    }

    public Collection<PgxId> getEdgePropIds() {
        return this.edgePropIds;
    }

    public Collection<PgxId> getVertexPropIds() {
        return this.vertexPropIds;
    }

    public Map<String, String> getEdgeLabelMapping() {
        return this.edgeLabelMapping;
    }

    public boolean isEdgeLabelMapping() {
        return this.edgeLabelMappingAction == EdgeMappingAction.MAP;
    }

    public boolean isEdgeLabelIgnored() {
        return this.edgeLabelMappingAction == EdgeMappingAction.IGNORE;
    }

    public boolean isEdgeLabelRemoved() {
        return this.edgeLabelMappingAction == EdgeMappingAction.REMOVE;
    }

    public boolean isRemovingProperties() {
        return this.edgePropIds != null || this.vertexPropIds != null;
    }

    public boolean isGenerateLabelHistogram() {
        return this.generateLabelHistogram;
    }

    public String getNewGraphName() {
        return this.newGraphName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        MutationStrategy that = (MutationStrategy)o;
        if (this.inPlace != that.inPlace) {
            return false;
        }
        if (this.noTrivialVertices != that.noTrivialVertices) {
            return false;
        }
        if (this.newGraphName != null ? !this.newGraphName.equals(that.newGraphName) : that.newGraphName != null) {
            return false;
        }
        return this.edgeStrategy != null ? this.edgeStrategy.equals(that.edgeStrategy) : that.edgeStrategy == null;
    }

    public int hashCode() {
        return Objects.hash(this.inPlace, this.newGraphName, this.noTrivialVertices, this.edgeStrategy);
    }

    public boolean isNoTrivialVertices() {
        return this.noTrivialVertices;
    }

    public String toString() {
        return "MutationStrategy{edgePropIds=" + this.edgePropIds + ", vertexPropIds=" + this.vertexPropIds + ", inPlace=" + this.inPlace + ", newGraphName='" + this.newGraphName + '\'' + ", noTrivialVertices=" + this.noTrivialVertices + ", edgeStrategy=" + this.edgeStrategy + ", edgeLabelMappingAction=" + (Object)((Object)this.edgeLabelMappingAction) + "}";
    }

    public EdgeStrategy getEdgeStrategy() {
        return this.edgeStrategy;
    }

    private static enum EdgeMappingAction {
        REMOVE,
        MAP,
        IGNORE;

    }
}

