/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.hypermedia.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import oracle.pgx.common.hypermedia.uri.UriBuilder;
import oracle.pgx.common.hypermedia.uri.UriBuilderException;
import oracle.pgx.common.hypermedia.uri.UriComponent;
import oracle.pgx.common.hypermedia.uri.UriParser;
import oracle.pgx.common.hypermedia.uri.UriTemplate;
import oracle.pgx.common.util.ErrorMessages;

public class UriBuilderImpl
extends UriBuilder {
    private String scheme;
    private String ssp;
    private String authority;
    private String userInfo;
    private String host;
    private String port;
    private final StringBuilder path;
    private final StringBuilder query;
    private String fragment;

    public UriBuilderImpl() {
        this.path = new StringBuilder();
        this.query = new StringBuilder();
    }

    private UriBuilderImpl(UriBuilderImpl that) {
        this.scheme = that.scheme;
        this.ssp = that.ssp;
        this.authority = that.authority;
        this.userInfo = that.userInfo;
        this.host = that.host;
        this.port = that.port;
        this.path = new StringBuilder(that.path);
        this.query = new StringBuilder(that.query);
        this.fragment = that.fragment;
    }

    @Override
    public UriBuilderImpl clone() {
        return new UriBuilderImpl(this);
    }

    @Override
    public UriBuilderImpl uri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("PARAM_NULL(\"hypermedia\")");
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        if (uri.isOpaque()) {
            this.scheme = uri.getScheme();
            this.ssp = uri.getRawSchemeSpecificPart();
            return this;
        }
        if (uri.getScheme() == null) {
            if (this.ssp != null && uri.getRawSchemeSpecificPart() != null) {
                this.ssp = uri.getRawSchemeSpecificPart();
                return this;
            }
        } else {
            this.scheme = uri.getScheme();
        }
        this.ssp = null;
        if (uri.getRawAuthority() != null) {
            if (uri.getRawUserInfo() == null && uri.getHost() == null && uri.getPort() == -1) {
                this.authority = uri.getRawAuthority();
                this.userInfo = null;
                this.host = null;
                this.port = null;
            } else {
                this.authority = null;
                if (uri.getRawUserInfo() != null) {
                    this.userInfo = uri.getRawUserInfo();
                }
                if (uri.getHost() != null) {
                    this.host = uri.getHost();
                }
                if (uri.getPort() != -1) {
                    this.port = String.valueOf(uri.getPort());
                }
            }
        }
        if (uri.getRawPath() != null && !uri.getRawPath().isEmpty()) {
            this.path.setLength(0);
            this.path.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null && !uri.getRawQuery().isEmpty()) {
            this.query.setLength(0);
            this.query.append(uri.getRawQuery());
        }
        return this;
    }

    @Override
    public UriBuilderImpl uri(String uriTemplate) {
        if (uriTemplate == null) {
            throw new IllegalArgumentException("PARAM_NULL(\"UriTemplate\")");
        }
        UriParser parser = new UriParser(uriTemplate);
        parser.parse();
        String parsedScheme = parser.getScheme();
        if (parsedScheme != null) {
            this.scheme(parsedScheme);
        } else if (this.ssp != null) {
            this.ssp = null;
            parser = new UriParser(this.scheme + ":" + uriTemplate);
            parser.parse();
        }
        this.schemeSpecificPart(parser);
        String parserFragment = parser.getFragment();
        if (parserFragment != null) {
            this.fragment(parserFragment);
        }
        return this;
    }

    private void schemeSpecificPart(UriParser parser) {
        if (parser.isOpaque()) {
            if (parser.getSsp() != null) {
                this.port = null;
                this.host = null;
                this.authority = null;
                this.path.setLength(0);
                this.query.setLength(0);
                this.ssp = parser.getSsp();
            }
            return;
        }
        this.ssp = null;
        if (parser.getAuthority() != null) {
            if (parser.getUserInfo() == null && parser.getHost() == null && parser.getPort() == null) {
                this.authority = this.encode(parser.getAuthority(), UriComponent.Type.AUTHORITY);
                this.userInfo = null;
                this.host = null;
                this.port = null;
            } else {
                this.authority = null;
                if (parser.getUserInfo() != null) {
                    this.userInfo(parser.getUserInfo());
                }
                if (parser.getHost() != null) {
                    this.host(parser.getHost());
                }
                if (parser.getPort() != null) {
                    this.port = parser.getPort();
                }
            }
        }
        if (parser.getPath() != null) {
            this.path.setLength(0);
            this.path(parser.getPath());
        }
        if (parser.getQuery() != null) {
            this.query.setLength(0);
            this.query.append(parser.getQuery());
        }
    }

    @Override
    public UriBuilderImpl scheme(String scheme) {
        if (scheme != null) {
            this.scheme = scheme;
            UriComponent.validate(scheme, UriComponent.Type.SCHEME, true);
        } else {
            this.scheme = null;
        }
        return this;
    }

    @Override
    public UriBuilderImpl schemeSpecificPart(String ssp) {
        if (ssp == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_BUILDER_SCHEME_PART_NULL", (Object[])new Object[0]));
        }
        UriParser parser = new UriParser(this.scheme != null ? this.scheme + ":" + ssp : ssp);
        parser.parse();
        if (parser.getScheme() != null && !parser.getScheme().equals(this.scheme)) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"URI_BUILDER_SCHEME_PART_UNEXPECTED_COMPONENT", (Object[])new Object[]{ssp, parser.getScheme()}));
        }
        if (parser.getFragment() != null) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"URI_BUILDER_URI_PART_FRAGMENT", (Object[])new Object[]{ssp, parser.getFragment()}));
        }
        this.schemeSpecificPart(parser);
        return this;
    }

    @Override
    public UriBuilderImpl userInfo(String ui) {
        this.checkSsp();
        this.userInfo = ui != null ? this.encode(ui, UriComponent.Type.USER_INFO) : null;
        return this;
    }

    @Override
    public UriBuilderImpl host(String host) {
        this.checkSsp();
        if (host != null) {
            if (host.isEmpty()) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_INVALID_HOST", (Object[])new Object[0]));
            }
            this.host = this.encode(host, UriComponent.Type.HOST);
        } else {
            this.host = null;
        }
        return this;
    }

    @Override
    public UriBuilderImpl port(int port) {
        this.checkSsp();
        if (port < -1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_INVALID_PORT", (Object[])new Object[0]));
        }
        this.port = port == -1 ? null : String.valueOf(port);
        return this;
    }

    @Override
    public UriBuilderImpl replacePath(String path) {
        this.checkSsp();
        this.path.setLength(0);
        if (path != null) {
            this.appendPath(path);
        }
        return this;
    }

    @Override
    public UriBuilderImpl path(String path) {
        this.checkSsp();
        this.appendPath(path);
        return this;
    }

    @Override
    public UriBuilderImpl segment(String ... segments) throws IllegalArgumentException {
        this.checkSsp();
        if (segments == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_PARAM_NULL", (Object[])new Object[]{"segments"}));
        }
        for (String segment : segments) {
            this.appendPath(segment, true);
        }
        return this;
    }

    @Override
    public UriBuilderImpl resolveTemplate(String name, Object value) throws IllegalArgumentException {
        this.resolveTemplate(name, value, true, true);
        return this;
    }

    @Override
    public UriBuilderImpl resolveTemplate(String name, Object value, boolean encodeSlashInPath) {
        this.resolveTemplate(name, value, true, encodeSlashInPath);
        return this;
    }

    @Override
    public UriBuilderImpl resolveTemplateFromEncoded(String name, Object value) {
        this.resolveTemplate(name, value, false, false);
        return this;
    }

    private UriBuilderImpl resolveTemplate(String name, Object value, boolean encode, boolean encodeSlashInPath) {
        if (name == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_PARAM_NULL", (Object[])new Object[]{"name"}));
        }
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_PARAM_NULL", (Object[])new Object[]{"value"}));
        }
        HashMap<String, Object> templateValues = new HashMap<String, Object>();
        templateValues.put(name, value);
        this.resolveTemplates(templateValues, encode, encodeSlashInPath);
        return this;
    }

    @Override
    public UriBuilderImpl resolveTemplates(Map<String, Object> templateValues) throws IllegalArgumentException {
        this.resolveTemplates(templateValues, true, true);
        return this;
    }

    @Override
    public UriBuilderImpl resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws IllegalArgumentException {
        this.resolveTemplates(templateValues, true, encodeSlashInPath);
        return this;
    }

    @Override
    public UriBuilderImpl resolveTemplatesFromEncoded(Map<String, Object> templateValues) {
        this.resolveTemplates(templateValues, false, false);
        return this;
    }

    private UriBuilderImpl resolveTemplates(Map<String, Object> templateValues, boolean encode, boolean encodeSlashInPath) {
        if (templateValues == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_PARAM_NULL", (Object[])new Object[]{"templateValues"}));
        }
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            if (entry.getKey() != null && entry.getValue() != null) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_TEMPLATE_PARAM_NULL", (Object[])new Object[0]));
        }
        this.scheme = UriTemplate.resolveTemplateValues(UriComponent.Type.SCHEME, this.scheme, false, templateValues);
        this.userInfo = UriTemplate.resolveTemplateValues(UriComponent.Type.USER_INFO, this.userInfo, encode, templateValues);
        this.host = UriTemplate.resolveTemplateValues(UriComponent.Type.HOST, this.host, encode, templateValues);
        this.port = UriTemplate.resolveTemplateValues(UriComponent.Type.PORT, this.port, false, templateValues);
        this.authority = UriTemplate.resolveTemplateValues(UriComponent.Type.AUTHORITY, this.authority, encode, templateValues);
        UriComponent.Type pathComponent = encodeSlashInPath ? UriComponent.Type.PATH_SEGMENT : UriComponent.Type.PATH;
        String newPath = UriTemplate.resolveTemplateValues(pathComponent, this.path.toString(), encode, templateValues);
        this.path.setLength(0);
        this.path.append(newPath);
        String newQuery = UriTemplate.resolveTemplateValues(UriComponent.Type.QUERY_PARAM, this.query.toString(), encode, templateValues);
        this.query.setLength(0);
        this.query.append(newQuery);
        this.fragment = UriTemplate.resolveTemplateValues(UriComponent.Type.FRAGMENT, this.fragment, encode, templateValues);
        return this;
    }

    @Override
    public UriBuilderImpl fragment(String fragment) {
        this.fragment = fragment != null ? this.encode(fragment, UriComponent.Type.FRAGMENT) : null;
        return this;
    }

    private void checkSsp() {
        if (this.ssp != null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_BUILDER_SCHEMA_PART_OPAQUE", (Object[])new Object[0]));
        }
    }

    private void appendPath(String path) {
        this.appendPath(path, false);
    }

    private void appendPath(String segments, boolean isSegment) {
        boolean segmentStartsWithSlash;
        if (segments == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_PARAM_NULL", (Object[])new Object[]{"segments"}));
        }
        if (segments.isEmpty()) {
            return;
        }
        segments = this.encode(segments, isSegment ? UriComponent.Type.PATH_SEGMENT : UriComponent.Type.PATH);
        boolean pathEndsInSlash = this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/';
        boolean bl = segmentStartsWithSlash = segments.charAt(0) == '/';
        if (this.path.length() > 0 && !pathEndsInSlash && !segmentStartsWithSlash) {
            this.path.append('/');
        } else if (pathEndsInSlash && segmentStartsWithSlash && (segments = segments.substring(1)).isEmpty()) {
            return;
        }
        this.path.append(segments);
    }

    private String encode(String s, UriComponent.Type type) {
        return UriComponent.contextualEncode(s, type, true);
    }

    @Override
    public URI build(Object ... values) {
        return this.buildUri(true, true, values);
    }

    @Override
    public URI build(Object[] values, boolean encodeSlashInPath) {
        return this.buildUri(true, encodeSlashInPath, values);
    }

    @Override
    public URI buildFromEncoded(Object ... values) {
        return this.buildUri(false, false, values);
    }

    @Override
    public String toTemplate() {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (this.ssp != null) {
            sb.append(this.ssp);
        } else {
            boolean hasAuthority = false;
            if (this.userInfo != null || this.host != null || this.port != null) {
                hasAuthority = true;
                sb.append("//");
                if (this.userInfo != null && !this.userInfo.isEmpty()) {
                    sb.append(this.userInfo).append('@');
                }
                if (this.host != null) {
                    sb.append(this.host);
                }
                if (this.port != null) {
                    sb.append(':').append(this.port);
                }
            } else if (this.authority != null) {
                hasAuthority = true;
                sb.append("//").append(this.authority);
            }
            if (this.path.length() > 0) {
                if (hasAuthority && this.path.charAt(0) != '/') {
                    sb.append("/");
                }
                sb.append((CharSequence)this.path);
            } else if (hasAuthority && (this.query.length() > 0 || this.fragment != null && !this.fragment.isEmpty())) {
                sb.append("/");
            }
            if (this.query.length() > 0) {
                sb.append('?').append((CharSequence)this.query);
            }
        }
        if (this.fragment != null && !this.fragment.isEmpty()) {
            sb.append('#').append(this.fragment);
        }
        return sb.toString();
    }

    private URI buildUri(boolean encode, boolean encodeSlashInPath, Object ... values) {
        if (this.ssp != null) {
            if (values == null || values.length == 0) {
                return this.createURI(this.create());
            }
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"URI_BUILDER_SCHEMA_PART_OPAQUE", (Object[])new Object[0]));
        }
        String uri = UriTemplate.createURI(this.scheme, this.authority, this.userInfo, this.host, this.port, this.path.toString(), this.query.toString(), this.fragment, values, encode, encodeSlashInPath);
        return this.createURI(uri);
    }

    private String create() {
        return UriComponent.encodeTemplateNames(this.toTemplate());
    }

    private URI createURI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new UriBuilderException(ex);
        }
    }

    public String toString() {
        return this.toTemplate();
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }
}

