/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import oracle.pgx.api.GraphLoadingProgress;

public abstract class FutureProgress {
    public static final String TYPE_ID_PROPERTY = "@type";
    @Nonnull
    private final FutureProgressType futureProgressType;

    public abstract Optional<GraphLoadingProgress> asGraphLoadingProgress();

    public FutureProgress(@Nonnull FutureProgressType futureProgressType) {
        this.futureProgressType = futureProgressType;
    }

    @JsonProperty(value="@type")
    @Nonnull
    public final FutureProgressType getFutureProgressType() {
        return this.futureProgressType;
    }

    public static enum FutureProgressType {
        DEFAULT_FUTURE_PROGRESS("DefaultFutureProgress"),
        GRAPH_LOADING_PROGRESS("GraphLoadingProgress");

        private final String typeId;

        private FutureProgressType(String typeId) {
            this.typeId = typeId;
        }

        @JsonValue
        public String getTypeId() {
            return this.typeId;
        }

        public static FutureProgressType fromTypeId(String typeId) {
            return Stream.of(FutureProgressType.values()).filter(t -> Objects.equals(typeId, t.typeId)).findAny().orElseThrow(() -> new IllegalArgumentException("Graph progress type not found"));
        }
    }
}

